package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamGradePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamGradeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamGradeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 考核结果等级
 */

@RestController
@RequestMapping("/api/prdPerformanceExamGrade")
@RequiredArgsConstructor
@Api(value = "考核结果等级", tags = {"考核结果等级"})
public class PrdPerformanceExamGradeController {

    private final PrdPerformanceExamGradeService prdPerformanceExamGradeService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-考核结果等级")
    public TwOutputUtil<PrdPerformanceExamGradeVO> get(@PathVariable Long id) {

        PrdPerformanceExamGradeVO res = prdPerformanceExamGradeService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-考核结果等级")
    public TwOutputUtil<Long> save(@RequestBody PrdPerformanceExamGradePayload prdPerformanceExamGradePayload) {

        PrdPerformanceExamGradeVO res = prdPerformanceExamGradeService.save(prdPerformanceExamGradePayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-考核结果等级")
    public TwOutputUtil<Long> update(@RequestBody PrdPerformanceExamGradePayload prdPerformanceExamGradePayload) {

        PrdPerformanceExamGradeVO res = prdPerformanceExamGradeService.update(prdPerformanceExamGradePayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-考核结果等级")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdPerformanceExamGradeService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-考核结果等级")
    public TwOutputUtil<PagingVO<PrdPerformanceExamGradeVO>> page(PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery) {

        PagingVO<PrdPerformanceExamGradeVO> res = prdPerformanceExamGradeService.page(prdPerformanceExamGradeQuery);
        return TwOutputUtil.ok(res);

    }


}

