package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdProbationExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdProbationExamQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdProbationExamService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdProbationExamVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-12-2
 * @desc : 试用期考核
 */

@RestController
@RequestMapping("/api/prdProbationExam")
@RequiredArgsConstructor
@Api(value = "试用期考核", tags = {"试用期考核"})
public class PrdProbationExamController {

    private final PrdProbationExamService prdProbationExamService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-试用期考核")
    public TwOutputUtil<PrdProbationExamVO> get(@PathVariable Long id) {

        PrdProbationExamVO res = prdProbationExamService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-试用期考核")
    public TwOutputUtil<Long> save(@RequestBody PrdProbationExamPayload prdProbationExamPayload) {

        PrdProbationExamVO res = prdProbationExamService.save(prdProbationExamPayload);
        return TwOutputUtil.ok(res.getId());
    }


//    @PostMapping("update")
//    @ApiOperation("修改-试用期考核")
//    public TwOutputUtil<Long> update(@RequestBody PrdProbationExamPayload prdProbationExamPayload) {
//
//        PrdProbationExamVO res = prdProbationExamService.update(prdProbationExamPayload);
//        return TwOutputUtil.ok(res.getId());
//
//    }


    @PostMapping("updateByCondition")
    @ApiOperation("根据条件修改-试用期考核")
    public TwOutputUtil<Long> updateByCondition(@RequestBody PrdProbationExamPayload prdProbationExamPayload) {

        Long res = prdProbationExamService.updateByCondition(prdProbationExamPayload);
        return TwOutputUtil.ok(res);

    }


    @DeleteMapping("del")
    @ApiOperation("删除-试用期考核")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdProbationExamService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-试用期考核")
    public TwOutputUtil<PagingVO<PrdProbationExamVO>> page(PrdProbationExamQuery prdProbationExamQuery) {

        PagingVO<PrdProbationExamVO> res = prdProbationExamService.page(prdProbationExamQuery);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("/testTask1")
    @ApiOperation("测试定时任务-试用期中期考核")
    public void testTask1(String param) {
        prdProbationExamService.taskPrdProbationExamMid(param);
    }

    @GetMapping("/testTask2")
    @ApiOperation("测试定时任务-试用期末期考核")
    public void testTask2(String param) {
        prdProbationExamService.taskPrdProbationExamLate(param);
    }

}

