package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdProbationExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdProbationExamQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdProbationExamVO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdProbationExamDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdProbationExamDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-12-2
 * @desc : 试用期考核RepoProc
 */

@Component
public class PrdProbationExamDao extends BaseRepoProc<PrdProbationExamDO> {

    private static final QPrdProbationExamDO qPrdProbationExamDO = QPrdProbationExamDO.prdProbationExamDO;


    protected PrdProbationExamDao() {

        super(qPrdProbationExamDO);

    }


    public PagingVO<PrdProbationExamVO> page(PrdProbationExamQuery prdProbationExamQuery) {

        JPAQuery<PrdProbationExamVO> query =
                select(PrdProbationExamVO.class)
                        .where(bulidPredicate(prdProbationExamQuery));
        prdProbationExamQuery.setPaging(query);
        prdProbationExamQuery.fillOrders(query, qPrdProbationExamDO);
        return PagingVO.<PrdProbationExamVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdProbationExamDO)
                .set(qPrdProbationExamDO.deleteFlag, 1)
                .where(qPrdProbationExamDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdProbationExamVO get(Long id) {

        PrdProbationExamVO prdProbationExamVO = select(PrdProbationExamVO.class)
                .where(qPrdProbationExamDO.id.eq(id))
                .fetchOne();

        return prdProbationExamVO;

    }


    public List<PrdProbationExamVO> getList(PrdProbationExamQuery prdProbationExamQuery) {

        List<PrdProbationExamVO> res =
                select(PrdProbationExamVO.class)
                        .where(bulidPredicate(prdProbationExamQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdProbationExamDO.userId,
                        qPrdProbationExamDO.name,
                        qPrdProbationExamDO.userName,
                        qPrdProbationExamDO.baseBuId,
                        qPrdProbationExamDO.pUserId,
                        qPrdProbationExamDO.pUserName,
                        qPrdProbationExamDO.probationStart,
                        qPrdProbationExamDO.probationEnd,
                        qPrdProbationExamDO.phone,
                        qPrdProbationExamDO.email,
                        qPrdProbationExamDO.applyUserId,
                        qPrdProbationExamDO.applyUser,
                        qPrdProbationExamDO.applyDate,
                        qPrdProbationExamDO.enrollTrainFlag,
                        qPrdProbationExamDO.trainDesc,
                        qPrdProbationExamDO.selfEval1,
                        qPrdProbationExamDO.selfEval2,
                        qPrdProbationExamDO.selfEval3,
                        qPrdProbationExamDO.selfEval4,
                        qPrdProbationExamDO.selfEval5,
                        qPrdProbationExamDO.pUserEvalDecs,
                        qPrdProbationExamDO.pUserEvalId,
                        qPrdProbationExamDO.examRes,
                        qPrdProbationExamDO.formalData,
                        qPrdProbationExamDO.type,
                        qPrdProbationExamDO.baseBuEvalDesc,
                        qPrdProbationExamDO.baseBuEvalId,
                        qPrdProbationExamDO.finishFlag,
                        qPrdProbationExamDO.examReward,
                        qPrdProbationExamDO.procInstStatus,
                        qPrdProbationExamDO.procInstId,
                        qPrdProbationExamDO.approvedTime,
                        qPrdProbationExamDO.id,
                        qPrdProbationExamDO.recommendFlag,
                        qPrdProbationExamDO.createTime,
                        qPrdProbationExamDO.remark

                )).from(qPrdProbationExamDO);

    }


    private Predicate bulidPredicate(PrdProbationExamQuery prdProbationExamQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdProbationExamQuery.getUserId(), qPrdProbationExamDO.userId, prdProbationExamQuery.getUserId())
                .andEq(null != prdProbationExamQuery.getBaseBuId(), qPrdProbationExamDO.baseBuId, prdProbationExamQuery.getBaseBuId())
                .andEq(null != prdProbationExamQuery.getPUserId(), qPrdProbationExamDO.pUserId, prdProbationExamQuery.getPUserId())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getPUserName()), qPrdProbationExamDO.pUserName, prdProbationExamQuery.getPUserName())
                .andLike(StringUtils.isNotBlank(prdProbationExamQuery.getName()), qPrdProbationExamDO.name, prdProbationExamQuery.getName())
                .andGoe(null != prdProbationExamQuery.getProbationStart(), qPrdProbationExamDO.probationStart, prdProbationExamQuery.getProbationStart())
                .andLoe(null != prdProbationExamQuery.getProbationEnd(), qPrdProbationExamDO.probationEnd, prdProbationExamQuery.getProbationEnd())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getPhone()), qPrdProbationExamDO.phone, prdProbationExamQuery.getPhone())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getEmail()), qPrdProbationExamDO.email, prdProbationExamQuery.getEmail())
                .andEq(null != prdProbationExamQuery.getApplyUserId(), qPrdProbationExamDO.applyUserId, prdProbationExamQuery.getApplyUserId())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getApplyUser()), qPrdProbationExamDO.applyUser, prdProbationExamQuery.getApplyUser())
                .andEq(null != prdProbationExamQuery.getApplyDate(), qPrdProbationExamDO.applyDate, prdProbationExamQuery.getApplyDate())
                .andEq(null != prdProbationExamQuery.getEnrollTrainFlag(), qPrdProbationExamDO.enrollTrainFlag, prdProbationExamQuery.getEnrollTrainFlag())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getTrainDesc()), qPrdProbationExamDO.trainDesc, prdProbationExamQuery.getTrainDesc())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getSelfEval1()), qPrdProbationExamDO.selfEval1, prdProbationExamQuery.getSelfEval1())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getSelfEval2()), qPrdProbationExamDO.selfEval2, prdProbationExamQuery.getSelfEval2())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getSelfEval3()), qPrdProbationExamDO.selfEval3, prdProbationExamQuery.getSelfEval3())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getSelfEval4()), qPrdProbationExamDO.selfEval4, prdProbationExamQuery.getSelfEval4())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getSelfEval5()), qPrdProbationExamDO.selfEval5, prdProbationExamQuery.getSelfEval5())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getPUserEvalDecs()), qPrdProbationExamDO.pUserEvalDecs, prdProbationExamQuery.getPUserEvalDecs())
                .andEq(null != prdProbationExamQuery.getPUserEvalId(), qPrdProbationExamDO.pUserEvalId, prdProbationExamQuery.getPUserEvalId())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getExamRes()), qPrdProbationExamDO.examRes, prdProbationExamQuery.getExamRes())
                .andGoe(null != prdProbationExamQuery.getFormalDataStart(), qPrdProbationExamDO.formalData, prdProbationExamQuery.getFormalDataStart())
                .andLoe(null != prdProbationExamQuery.getFormalDataEnd(), qPrdProbationExamDO.formalData, prdProbationExamQuery.getFormalDataEnd())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getType()), qPrdProbationExamDO.type, prdProbationExamQuery.getType())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getBaseBuEvalDesc()), qPrdProbationExamDO.baseBuEvalDesc, prdProbationExamQuery.getBaseBuEvalDesc())
                .andEq(null != prdProbationExamQuery.getBaseBuEvalId(), qPrdProbationExamDO.baseBuEvalId, prdProbationExamQuery.getBaseBuEvalId())
                .andEq(null != prdProbationExamQuery.getFinishFlag(), qPrdProbationExamDO.finishFlag, prdProbationExamQuery.getFinishFlag())
                .andEq(null != prdProbationExamQuery.getProcInstStatus(), qPrdProbationExamDO.procInstStatus, prdProbationExamQuery.getProcInstStatus())
                .andEq(StringUtils.isNotBlank(prdProbationExamQuery.getExamReward()), qPrdProbationExamDO.examReward, prdProbationExamQuery.getExamReward())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(PrdProbationExamQuery prdProbationExamQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 用户id
        if (null != prdProbationExamQuery.getUserId()) {
            predicates.add(qPrdProbationExamDO.userId.eq(prdProbationExamQuery.getUserId()));
        }
        // 流程名称
        if (null != prdProbationExamQuery.getName()) {
            predicates.add(qPrdProbationExamDO.name.eq(prdProbationExamQuery.getName()));
        }
        // baseBU
        if (null != prdProbationExamQuery.getBaseBuId()) {
            predicates.add(qPrdProbationExamDO.baseBuId.eq(prdProbationExamQuery.getBaseBuId()));
        }
        // 上级
        if (null != prdProbationExamQuery.getPUserId()) {
            predicates.add(qPrdProbationExamDO.pUserId.eq(prdProbationExamQuery.getPUserId()));
        }
        // 上级名称
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getPUserName())) {
            predicates.add(qPrdProbationExamDO.pUserName.eq(prdProbationExamQuery.getPUserName()));
        }
        // 试用期开始
        if (null != prdProbationExamQuery.getProbationStart()) {
            predicates.add(qPrdProbationExamDO.probationStart.eq(prdProbationExamQuery.getProbationStart()));
        }
        // 试用期结束
        if (null != prdProbationExamQuery.getProbationEnd()) {
            predicates.add(qPrdProbationExamDO.probationEnd.eq(prdProbationExamQuery.getProbationEnd()));
        }
        // 手机号
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getPhone())) {
            predicates.add(qPrdProbationExamDO.phone.eq(prdProbationExamQuery.getPhone()));
        }
        // 邮箱
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getEmail())) {
            predicates.add(qPrdProbationExamDO.email.eq(prdProbationExamQuery.getEmail()));
        }
        // 申请人id
        if (null != prdProbationExamQuery.getApplyUserId()) {
            predicates.add(qPrdProbationExamDO.applyUserId.eq(prdProbationExamQuery.getApplyUserId()));
        }
        // 申请人
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getApplyUser())) {
            predicates.add(qPrdProbationExamDO.applyUser.eq(prdProbationExamQuery.getApplyUser()));
        }
        // 申请日期
        if (null != prdProbationExamQuery.getApplyDate()) {
            predicates.add(qPrdProbationExamDO.applyDate.eq(prdProbationExamQuery.getApplyDate()));
        }
        // 入职培训标记
        if (null != prdProbationExamQuery.getEnrollTrainFlag()) {
            predicates.add(qPrdProbationExamDO.enrollTrainFlag.eq(prdProbationExamQuery.getEnrollTrainFlag()));
        }
        // 培训说明
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getTrainDesc())) {
            predicates.add(qPrdProbationExamDO.trainDesc.eq(prdProbationExamQuery.getTrainDesc()));
        }
        // 成长收获
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getSelfEval1())) {
            predicates.add(qPrdProbationExamDO.selfEval1.eq(prdProbationExamQuery.getSelfEval1()));
        }
        // 近期工作成果
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getSelfEval2())) {
            predicates.add(qPrdProbationExamDO.selfEval2.eq(prdProbationExamQuery.getSelfEval2()));
        }
        // 自我定位
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getSelfEval3())) {
            predicates.add(qPrdProbationExamDO.selfEval3.eq(prdProbationExamQuery.getSelfEval3()));
        }
        // 需要改进的方面
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getSelfEval4())) {
            predicates.add(qPrdProbationExamDO.selfEval4.eq(prdProbationExamQuery.getSelfEval4()));
        }
        // 建议
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getSelfEval5())) {
            predicates.add(qPrdProbationExamDO.selfEval5.eq(prdProbationExamQuery.getSelfEval5()));
        }
        // 上级评价说明
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getPUserEvalDecs())) {
            predicates.add(qPrdProbationExamDO.pUserEvalDecs.eq(prdProbationExamQuery.getPUserEvalDecs()));
        }
        // 上级评价id
        if (null != prdProbationExamQuery.getPUserEvalId()) {
            predicates.add(qPrdProbationExamDO.pUserEvalId.eq(prdProbationExamQuery.getPUserEvalId()));
        }
        // 考核结果
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getExamRes())) {
            predicates.add(qPrdProbationExamDO.examRes.eq(prdProbationExamQuery.getExamRes()));
        }
        // 转正日期
        if (null != prdProbationExamQuery.getFormalData()) {
            predicates.add(qPrdProbationExamDO.formalData.eq(prdProbationExamQuery.getFormalData()));
        }
        // 考核类型(中/末)
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getType())) {
            predicates.add(qPrdProbationExamDO.type.eq(prdProbationExamQuery.getType()));
        }
        // bu负责人评价说明
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getBaseBuEvalDesc())) {
            predicates.add(qPrdProbationExamDO.baseBuEvalDesc.eq(prdProbationExamQuery.getBaseBuEvalDesc()));
        }
        // bu负责人评价id
        if (null != prdProbationExamQuery.getBaseBuEvalId()) {
            predicates.add(qPrdProbationExamDO.baseBuEvalId.eq(prdProbationExamQuery.getBaseBuEvalId()));
        }
        // 完成标记
        if (null != prdProbationExamQuery.getFinishFlag()) {
            predicates.add(qPrdProbationExamDO.finishFlag.eq(prdProbationExamQuery.getFinishFlag()));
        }
        // 考核奖励
        if (StringUtils.isNotEmpty(prdProbationExamQuery.getExamReward())) {
            predicates.add(qPrdProbationExamDO.examReward.eq(prdProbationExamQuery.getExamReward()));
        }
        if (null != prdProbationExamQuery.getProcInstStatus()) {
            predicates.add(qPrdProbationExamDO.procInstStatus.eq(prdProbationExamQuery.getProcInstStatus()));
        }
        if (null != prdProbationExamQuery.getProcInstId()) {
            predicates.add(qPrdProbationExamDO.procInstId.eq(prdProbationExamQuery.getProcInstId()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(PrdProbationExamQuery prdProbationExamQuery) {

        long res = select(PrdProbationExamVO.class)
                .where(bulidPredicates(prdProbationExamQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdProbationExamPayload prdProbationExamPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdProbationExamDO);

        // 用户id
        if (null != prdProbationExamPayload.getUserId()) {
            update.set(qPrdProbationExamDO.userId, prdProbationExamPayload.getUserId());
        }
        // baseBU
        if (null != prdProbationExamPayload.getBaseBuId()) {
            update.set(qPrdProbationExamDO.baseBuId, prdProbationExamPayload.getBaseBuId());
        }
        if (null != prdProbationExamPayload.getName()) {
            update.set(qPrdProbationExamDO.name, prdProbationExamPayload.getName());
        }
        // 上级
        if (null != prdProbationExamPayload.getpUserId()) {
            update.set(qPrdProbationExamDO.pUserId, prdProbationExamPayload.getpUserId());
        }
        // 上级名称
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getpUserName())) {
            update.set(qPrdProbationExamDO.pUserName, prdProbationExamPayload.getpUserName());
        }
        // 试用期开始
        if (null != prdProbationExamPayload.getProbationStart()) {
            update.set(qPrdProbationExamDO.probationStart, prdProbationExamPayload.getProbationStart());
        }
        // 试用期结束
        if (null != prdProbationExamPayload.getProbationEnd()) {
            update.set(qPrdProbationExamDO.probationEnd, prdProbationExamPayload.getProbationEnd());
        }
        // 手机号
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getPhone())) {
            update.set(qPrdProbationExamDO.phone, prdProbationExamPayload.getPhone());
        }
        // 邮箱
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getEmail())) {
            update.set(qPrdProbationExamDO.email, prdProbationExamPayload.getEmail());
        }
        // 申请人id
        if (null != prdProbationExamPayload.getApplyUserId()) {
            update.set(qPrdProbationExamDO.applyUserId, prdProbationExamPayload.getApplyUserId());
        }
        // 申请人
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getApplyUser())) {
            update.set(qPrdProbationExamDO.applyUser, prdProbationExamPayload.getApplyUser());
        }
        // 申请日期
        if (null != prdProbationExamPayload.getApplyDate()) {
            update.set(qPrdProbationExamDO.applyDate, prdProbationExamPayload.getApplyDate());
        }
        // 入职培训标记
        if (null != prdProbationExamPayload.getEnrollTrainFlag()) {
            update.set(qPrdProbationExamDO.enrollTrainFlag, prdProbationExamPayload.getEnrollTrainFlag());
        }
        // 培训说明
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getTrainDesc())) {
            update.set(qPrdProbationExamDO.trainDesc, prdProbationExamPayload.getTrainDesc());
        }
        // 成长收获
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getSelfEval1())) {
            update.set(qPrdProbationExamDO.selfEval1, prdProbationExamPayload.getSelfEval1());
        }
        // 近期工作成果
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getSelfEval2())) {
            update.set(qPrdProbationExamDO.selfEval2, prdProbationExamPayload.getSelfEval2());
        }
        // 自我定位
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getSelfEval3())) {
            update.set(qPrdProbationExamDO.selfEval3, prdProbationExamPayload.getSelfEval3());
        }
        // 需要改进的方面
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getSelfEval4())) {
            update.set(qPrdProbationExamDO.selfEval4, prdProbationExamPayload.getSelfEval4());
        }
        // 建议
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getSelfEval5())) {
            update.set(qPrdProbationExamDO.selfEval5, prdProbationExamPayload.getSelfEval5());
        }
        // 上级评价说明
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getpUserEvalDecs())) {
            update.set(qPrdProbationExamDO.pUserEvalDecs, prdProbationExamPayload.getpUserEvalDecs());
        }
        // 上级评价id
        if (null != prdProbationExamPayload.getpUserEvalId()) {
            update.set(qPrdProbationExamDO.pUserEvalId, prdProbationExamPayload.getpUserEvalId());
        }
        // 考核结果
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getExamRes())) {
            update.set(qPrdProbationExamDO.examRes, prdProbationExamPayload.getExamRes());
        }
        // 转正日期
        if (null != prdProbationExamPayload.getFormalData()) {
            update.set(qPrdProbationExamDO.formalData, prdProbationExamPayload.getFormalData());
        }
        // 考核类型(中/末)
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getType())) {
            update.set(qPrdProbationExamDO.type, prdProbationExamPayload.getType());
        }
        // bu负责人评价说明
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getBaseBuEvalDesc())) {
            update.set(qPrdProbationExamDO.baseBuEvalDesc, prdProbationExamPayload.getBaseBuEvalDesc());
        }
        // bu负责人评价id
        if (null != prdProbationExamPayload.getBaseBuEvalId()) {
            update.set(qPrdProbationExamDO.baseBuEvalId, prdProbationExamPayload.getBaseBuEvalId());
        }
        // 完成标记
        if (null != prdProbationExamPayload.getFinishFlag()) {
            update.set(qPrdProbationExamDO.finishFlag, prdProbationExamPayload.getFinishFlag());
        }
        // 考核奖励
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getExamReward())) {
            update.set(qPrdProbationExamDO.examReward, prdProbationExamPayload.getExamReward());
        }
        if (StringUtils.isNotEmpty(prdProbationExamPayload.getProcInstId())) {
            update.set(qPrdProbationExamDO.procInstId, prdProbationExamPayload.getProcInstId());
        }
        if (null != (prdProbationExamPayload.getProcInstStatus())) {
            update.set(qPrdProbationExamDO.procInstStatus, prdProbationExamPayload.getProcInstStatus());
        }
        // 内推标志
        if (null != prdProbationExamPayload.getRecommendFlag()) {
            update.set(qPrdProbationExamDO.recommendFlag, prdProbationExamPayload.getRecommendFlag());
        }
        // 内推用户
        if (null != prdProbationExamPayload.getRecommendUserId()) {
            update.set(qPrdProbationExamDO.recommendUserId, prdProbationExamPayload.getRecommendUserId());
        }
        long res = update.where(qPrdProbationExamDO.id.eq(prdProbationExamPayload.getId()))
                .execute();
        return res;

    }

}

