package com.elitesland.tw.tw5.server.prd.humanresources.examination.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


 /**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板-绩效考核点
 */
 
@Entity
@Table(name="prd_exam_temp_point")
@org.hibernate.annotations.Table(appliesTo = "prd_exam_temp_point", comment = "绩效考核模板-绩效考核点")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdExamTempPointDO extends BaseModel {


    /**
     * 模板id
     */
    @Column(name = "temp_id", columnDefinition = "bigint(20) comment '模板id'")
    private Long tempId;
    
    /**
     * 考核点来源
     */
    @Column(name = "source", columnDefinition = "varchar(255) comment '考核点来源'")
    private String source;
    
    /**
     * 考核点名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '考核点名称'")
    private String name;
    
    /**
     * 评分类型
     */
    @Column(name = "score_type", columnDefinition = "varchar(50) comment '评分类型'")
    private String scoreType;
    
    /**
     * 权重比率
     */
    @Column(name = "weight_ratio", columnDefinition = "decimal(20,2) comment '权重比率'")
    private BigDecimal weightRatio;
    
    /**
     * 评分标准说明
     */
    @Column(name = "standard_desc", columnDefinition = "varchar(2000) comment '评分标准说明'")
    private String standardDesc;
    

}

