package com.elitesland.tw.tw5.server.prd.humanresources.examination.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 可查看考核相关人员
 */
 
@Entity
@Table(name="prd_performance_exam_relate")
@org.hibernate.annotations.Table(appliesTo = "prd_performance_exam_relate", comment = "可查看考核相关人员")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdPerformanceExamRelateDO extends BaseModel {


    /**
     * 绩效考核id
     */
    @Column(name = "exam_id", columnDefinition = "bigint(20) comment '绩效考核id'")
    private Long examId;
    
    /**
     * 角色类型
     */
    @Column(name = "role_type", columnDefinition = "varchar(50) comment '角色类型'")
    private String roleType;
    
    /**
     * 用户id
     */
    @Column(name = "user_id", columnDefinition = "bigint(20) comment '用户id'")
    private Long userId;
    
    /**
     * 资源id
     */
    @Column(name = "res_id", columnDefinition = "bigint(20) comment '资源id'")
    private Long resId;
    

}

