package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamGradePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamGradeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamGradeVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdPerformanceExamGradeConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdPerformanceExamGradeDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamGradeDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdPerformanceExamGradeRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import javax.servlet.http.HttpServletResponse;

import com.elitescloud.boot.exception.BusinessException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.boot.exception.BusinessException;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 考核结果等级Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdPerformanceExamGradeServiceImpl implements PrdPerformanceExamGradeService {


    private final PrdPerformanceExamGradeDao prdPerformanceExamGradeDao;

    private final PrdPerformanceExamGradeRepo prdPerformanceExamGradeRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamGradeVO save(PrdPerformanceExamGradePayload prdPerformanceExamGradePayload) {

        checkData(prdPerformanceExamGradePayload);
        PrdPerformanceExamGradeDO prdPerformanceExamGradeDO = new PrdPerformanceExamGradeDO();
        prdPerformanceExamGradeDO = PrdPerformanceExamGradeConvert.INSTANCE.p2d(prdPerformanceExamGradePayload);
        PrdPerformanceExamGradeDO res = prdPerformanceExamGradeRepo.save(prdPerformanceExamGradeDO);
        return PrdPerformanceExamGradeConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamGradeVO update(PrdPerformanceExamGradePayload prdPerformanceExamGradePayload) {

        Assert.notNull(prdPerformanceExamGradePayload.getId(), "id is null");
        PrdPerformanceExamGradeVO res = save(prdPerformanceExamGradePayload);
        return res;

    }


    @Override
    public PrdPerformanceExamGradeVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdPerformanceExamGradeVO res = prdPerformanceExamGradeDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdPerformanceExamGradeVO> page(PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery) {

        PagingVO<PrdPerformanceExamGradeVO> res = prdPerformanceExamGradeDao.page(prdPerformanceExamGradeQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdPerformanceExamGradeDao.del(ids);
        return res;

    }

    @Override
    public List<PrdPerformanceExamGradeVO> getList(PrdPerformanceExamGradeQuery prdPerformanceExamGradeQuery) {

        List<PrdPerformanceExamGradeVO> res = prdPerformanceExamGradeDao.getList(prdPerformanceExamGradeQuery);
        return res;

    }


    /**
     * 数据校验
     *
     * @param prdPerformanceExamGradePayload
     */
    private void checkData(PrdPerformanceExamGradePayload prdPerformanceExamGradePayload) {

//        if (StringUtils.isBlank(prdPerformanceExamGradePayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdPerformanceExamGradePayload prdPerformanceExamGradePayload) {
        Assert.notNull(prdPerformanceExamGradePayload.getId(), "id不能为空");
        Long res = prdPerformanceExamGradeDao.update(prdPerformanceExamGradePayload);
        return res;
    }

    @Override
    @Transactional
    public Long delByExamId(Long id) {
        Long res = prdPerformanceExamGradeDao.delByExamId(id);
        return res;
    }


}

