package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonRewardPunishPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonRewardPunishService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonRewardPunishVO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonRewardPunishConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonRewardPunishDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonRewardPunishDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonRewardPunishRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class PersonRewardPunishServiceImpl implements PersonRewardPunishService {

    private final PersonRewardPunishRepo personRewardPunishRepo;

    private final PersonRewardPunishDAO personRewardPunishDAO;

    @Override
    public void save(PersonRewardPunishPayload save) {
        PersonRewardPunishDO personRewardPunishDO = PersonRewardPunishConvert.INSTANCE.toDo(save);
        personRewardPunishRepo.save(personRewardPunishDO);
    }

    @Override
    public List<PersonRewardPunishVO> findAllByPersonId(Long personId) {
        List<PersonRewardPunishDO> personRewardPunishDOList = personRewardPunishRepo.findAllByPersonId(personId);
        return PersonRewardPunishConvert.INSTANCE.toVos(personRewardPunishDOList);
    }

    @Override
    public void saveAll(List<PersonRewardPunishVO> personRewardPunishVOList, Long personId) {
        if (personRewardPunishVOList != null) {
            if (personRewardPunishVOList.size() == 0) {
                personRewardPunishDAO.deleteAllByPersonId(personId);
            } else {
                for (PersonRewardPunishVO personRewardPunishVO : personRewardPunishVOList) {
                    if (personRewardPunishVO.getPersonId() == null) {
                        personRewardPunishVO.setPersonId(personId);
                    }
                }
                personRewardPunishDAO.saveAll(PersonRewardPunishConvert.INSTANCE.toDos(personRewardPunishVOList));
            }
        }
    }

    @Override
    public void deleteAllByPersonId(Long personId) {
        personRewardPunishDAO.deleteAllByPersonId(personId);
    }

}
