package com.elitesland.tw.tw5.server.prd.humanresources.recommended.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdRecruitPositionPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdRecruitPositionQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdRecruitPositionService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdRecruitPositionVO;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.convert.PrdRecruitPositionConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.dao.PrdRecruitPositionDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.entity.PrdRecruitPositionDO;
import com.elitesland.tw.tw5.server.prd.humanresources.recommended.repo.PrdRecruitPositionRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 内部招聘管理
 *
 * @author zhangxiao
 * @date 2023-12-13
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdRecruitPositionServiceImpl extends BaseServiceImpl implements PrdRecruitPositionService {

    private final PrdRecruitPositionRepo prdRecruitPositionRepo;
    private final PrdRecruitPositionDAO prdRecruitPositionDAO;
    private final CacheUtil cacheUtil;

    @Override
    public PagingVO<PrdRecruitPositionVO> queryPaging(PrdRecruitPositionQuery query) {

        PagingVO<PrdRecruitPositionVO> res = prdRecruitPositionDAO.queryPaging(query);
        res.getRecords().forEach(x -> {
            x.setJobType1Desc(cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", x.getJobType1()));
            x.setJobType2Desc(cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", x.getJobType2()));
            x.setBaseRegionName(cacheUtil.transferSystemSelection("SYSTEM_BASIC:PCD", x.getBaseRegion()));
            x.setBaseBuName(cacheUtil.getOrgName(x.getBaseBuId()));
            x.setManagerUserName(cacheUtil.getUserName(x.getManagerUserId()));
        });
        return res;
    }

    @Override
    public List<PrdRecruitPositionVO> queryListDynamic(PrdRecruitPositionQuery query) {
        return prdRecruitPositionDAO.queryListDynamic(query);
    }

    @Override
    public PrdRecruitPositionVO queryByKey(Long key) {
        PrdRecruitPositionDO entity = prdRecruitPositionRepo.findById(key).orElseGet(PrdRecruitPositionDO::new);

        Assert.notNull(entity.getId(), "不存在");
        PrdRecruitPositionVO x = PrdRecruitPositionConvert.INSTANCE.toVo(entity);
        x.setJobType1Desc(cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", x.getJobType1()));
        x.setJobType2Desc(cacheUtil.transferSystemSelection("INTERIOR_RECO:TYPE", x.getJobType2()));
        x.setBaseRegionName(cacheUtil.transferSystemSelection("SYSTEM_BASIC:PCD", x.getBaseRegion()));
        x.setBaseBuName(cacheUtil.getOrgName(x.getBaseBuId()));
        x.setManagerUserName(cacheUtil.getUserName(x.getManagerUserId()));
        return x;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdRecruitPositionVO insert(PrdRecruitPositionPayload payload) {
        //检验字段是否为空
        checkData(payload);
        //设置发号器
        payload.setJobNo(generateSeqNum(GenerateSeqNumConstants.INTEEIOR_RECOMMEND_NO));
        PrdRecruitPositionDO entityDo = PrdRecruitPositionConvert.INSTANCE.toDo(payload);
        return PrdRecruitPositionConvert.INSTANCE.toVo(prdRecruitPositionRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdRecruitPositionVO update(PrdRecruitPositionPayload payload) {
        //检验更新字段
        checkData(payload);
        PrdRecruitPositionDO entity = prdRecruitPositionRepo.findById(payload.getId()).orElseGet(PrdRecruitPositionDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdRecruitPositionDO entityDo = PrdRecruitPositionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdRecruitPositionConvert.INSTANCE.toVo(prdRecruitPositionRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PrdRecruitPositionPayload payload) {
        PrdRecruitPositionDO entity = prdRecruitPositionRepo.findById(payload.getId()).orElseGet(PrdRecruitPositionDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = prdRecruitPositionDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdRecruitPositionDAO.deleteSoft(keys);
        }
    }

    /**
     * 数据校验
     *
     * @param prdRecruitPositionPayload
     */
    private void checkData(PrdRecruitPositionPayload prdRecruitPositionPayload) {

        if (StringUtils.isBlank(prdRecruitPositionPayload.getJobTitle())) {
            throw new BusinessException("岗位名称不能为空");
        }
        if (StringUtils.isBlank(prdRecruitPositionPayload.getBaseBuId().toString())) {
            throw new BusinessException("招聘部门不能为空");
        }
        if (StringUtils.isBlank(prdRecruitPositionPayload.getJobType1())) {
            throw new BusinessException("分类不能为空");
        }
//        if (StringUtils.isBlank(prdRecruitPositionPayload.getBaseRegion())) {
//            throw new BusinessException("工作地不能为空");
//        }
        if (StringUtils.isBlank(prdRecruitPositionPayload.getRecruitQty().toString())) {
            throw new BusinessException("招聘人数不能为空");
        }
//        if (StringUtils.isBlank(prdRecruitPositionPayload.getJobRequirement())) {
//            throw new BusinessException("岗位简介不能为空");
//        }
//        if (StringUtils.isBlank(prdRecruitPositionPayload.getJobProfile())) {
//            throw new BusinessException("岗位要求不能为空");
//        }
        if (prdRecruitPositionPayload.getInternalFlag() == null) {
            throw new BusinessException("内部推荐字段不能为空");
        }
        if (prdRecruitPositionPayload.getExternalVisible() == null) {
            throw new BusinessException("外部资源可见字段不能为空");
        }
        if (prdRecruitPositionPayload.getRecruitmentStatus() == null) {
            throw new BusinessException("招聘状态字段不能为空");
        }
    }
}
