package com.elitesland.tw.tw5.server.prd.humanresources.resource.dao;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdAbilityLevelDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdCompositeAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.PrdEmployeCompositeAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.QPrdEmployeCompositeAbilityDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-复合能力RepoProc
 */

@Component
public class PrdEmployeCompositeAbilityDao extends BaseRepoProc<PrdEmployeCompositeAbilityDO> {

    private static final QPrdEmployeCompositeAbilityDO qPrdEmployeCompositeAbilityDO = QPrdEmployeCompositeAbilityDO.prdEmployeCompositeAbilityDO;
    private static final QPrdAbilityLevelDO qPrdAbilityLevelDO = QPrdAbilityLevelDO.prdAbilityLevelDO;
    private static final QPrdCompositeAbilityDO qPrdCompositeAbilityDO = QPrdCompositeAbilityDO.prdCompositeAbilityDO;


    protected PrdEmployeCompositeAbilityDao() {

        super(qPrdEmployeCompositeAbilityDO);

    }


    public PagingVO<PrdEmployeCompositeAbilityVO> page(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {

        JPAQuery<PrdEmployeCompositeAbilityVO> query =
                select(PrdEmployeCompositeAbilityVO.class)
                        .where(bulidPredicate(prdEmployeCompositeAbilityQuery))
                        .where(qPrdCompositeAbilityDO.state.eq(1));

        prdEmployeCompositeAbilityQuery.setPaging(query);
        prdEmployeCompositeAbilityQuery.fillOrders(query, qPrdEmployeCompositeAbilityDO);
        return PagingVO.<PrdEmployeCompositeAbilityVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdEmployeCompositeAbilityDO)
                .set(qPrdEmployeCompositeAbilityDO.deleteFlag, 1)
                .where(qPrdEmployeCompositeAbilityDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdEmployeCompositeAbilityVO get(Long id) {

        PrdEmployeCompositeAbilityVO prdEmployeCompositeAbilityVO = select(PrdEmployeCompositeAbilityVO.class)
                .where(qPrdEmployeCompositeAbilityDO.id.eq(id))
                .fetchOne();

        return prdEmployeCompositeAbilityVO;

    }


    public List<PrdEmployeCompositeAbilityVO> getList(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {

        List<PrdEmployeCompositeAbilityVO> res =
                select(PrdEmployeCompositeAbilityVO.class)
                        .where(bulidPredicate(prdEmployeCompositeAbilityQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                                qPrdCompositeAbilityDO.docNo,
                                qPrdCompositeAbilityDO.name.as("abilityName"),
                                qPrdAbilityLevelDO.levelDtlName,
                                qPrdEmployeCompositeAbilityDO.abilityId,
                                qPrdAbilityLevelDO.id.as("abilityLevelId"),
                                qPrdAbilityLevelDO.abilityDesc,
                                qPrdEmployeCompositeAbilityDO.mainFlag,
                                qPrdEmployeCompositeAbilityDO.auxFlag,
                                qPrdAbilityLevelDO.dlRatio,
                                qPrdEmployeCompositeAbilityDO.obtainTime,
                                qPrdEmployeCompositeAbilityDO.lastCertTime,
                                qPrdEmployeCompositeAbilityDO.expirateTime,
                                qPrdEmployeCompositeAbilityDO.userId,
                                qPrdEmployeCompositeAbilityDO.empName,
                                qPrdEmployeCompositeAbilityDO.empDocNo,
                                qPrdEmployeCompositeAbilityDO.id,
                                qPrdEmployeCompositeAbilityDO.createTime,
                                qPrdEmployeCompositeAbilityDO.remark

                        )).from(qPrdEmployeCompositeAbilityDO)
                        .leftJoin(qPrdAbilityLevelDO).on(qPrdAbilityLevelDO.id.eq(qPrdEmployeCompositeAbilityDO.abilityLevelId))
                        .leftJoin(qPrdCompositeAbilityDO).on(qPrdCompositeAbilityDO.id.eq(qPrdEmployeCompositeAbilityDO.abilityId));

    }


    private Predicate bulidPredicate(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(StringUtils.isNotBlank(prdEmployeCompositeAbilityQuery.getDocNo()), qPrdEmployeCompositeAbilityDO.docNo, prdEmployeCompositeAbilityQuery.getDocNo())
                .andEq(StringUtils.isNotBlank(prdEmployeCompositeAbilityQuery.getAbilityName()), qPrdEmployeCompositeAbilityDO.abilityName, prdEmployeCompositeAbilityQuery.getAbilityName())
                .andEq(null != prdEmployeCompositeAbilityQuery.getAbilityId(), qPrdEmployeCompositeAbilityDO.abilityId, prdEmployeCompositeAbilityQuery.getAbilityId())
                .andIn(CollUtil.isNotEmpty(prdEmployeCompositeAbilityQuery.getAbilityIds()), qPrdEmployeCompositeAbilityDO.abilityId, prdEmployeCompositeAbilityQuery.getAbilityIds())
                .andEq(StringUtils.isNotBlank(prdEmployeCompositeAbilityQuery.getAbilityDesc()), qPrdEmployeCompositeAbilityDO.abilityDesc, prdEmployeCompositeAbilityQuery.getAbilityDesc())
                .andEq(null != prdEmployeCompositeAbilityQuery.getMainFlag(), qPrdEmployeCompositeAbilityDO.mainFlag, prdEmployeCompositeAbilityQuery.getMainFlag())
                .andEq(null != prdEmployeCompositeAbilityQuery.getAuxFlag(), qPrdEmployeCompositeAbilityDO.auxFlag, prdEmployeCompositeAbilityQuery.getAuxFlag())
                .andEq(null != prdEmployeCompositeAbilityQuery.getDlRatio(), qPrdEmployeCompositeAbilityDO.dlRatio, prdEmployeCompositeAbilityQuery.getDlRatio())
                .andEq(null != prdEmployeCompositeAbilityQuery.getObtainTime(), qPrdEmployeCompositeAbilityDO.obtainTime, prdEmployeCompositeAbilityQuery.getObtainTime())
                .andEq(null != prdEmployeCompositeAbilityQuery.getLastCertTime(), qPrdEmployeCompositeAbilityDO.lastCertTime, prdEmployeCompositeAbilityQuery.getLastCertTime())
                .andEq(null != prdEmployeCompositeAbilityQuery.getExpirateTime(), qPrdEmployeCompositeAbilityDO.expirateTime, prdEmployeCompositeAbilityQuery.getExpirateTime())
                .andEq(null != prdEmployeCompositeAbilityQuery.getUserId(), qPrdEmployeCompositeAbilityDO.userId, prdEmployeCompositeAbilityQuery.getUserId())
                .andIn(CollUtil.isNotEmpty(prdEmployeCompositeAbilityQuery.getUserIds()), qPrdEmployeCompositeAbilityDO.userId, prdEmployeCompositeAbilityQuery.getUserIds())
                .andEq(StringUtils.isNotBlank(prdEmployeCompositeAbilityQuery.getEmpName()), qPrdEmployeCompositeAbilityDO.empName, prdEmployeCompositeAbilityQuery.getEmpName())
                .andEq(StringUtils.isNotBlank(prdEmployeCompositeAbilityQuery.getEmpDocNo()), qPrdEmployeCompositeAbilityDO.empDocNo, prdEmployeCompositeAbilityQuery.getEmpDocNo())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 编号
        if (StringUtils.isNotEmpty(prdEmployeCompositeAbilityQuery.getDocNo())) {
            predicates.add(qPrdEmployeCompositeAbilityDO.docNo.eq(prdEmployeCompositeAbilityQuery.getDocNo()));
        }
        // 能力名称
        if (StringUtils.isNotEmpty(prdEmployeCompositeAbilityQuery.getAbilityName())) {
            predicates.add(qPrdEmployeCompositeAbilityDO.abilityName.eq(prdEmployeCompositeAbilityQuery.getAbilityName()));
        }
        // 能力id
        if (null != prdEmployeCompositeAbilityQuery.getAbilityId()) {
            predicates.add(qPrdEmployeCompositeAbilityDO.abilityId.eq(prdEmployeCompositeAbilityQuery.getAbilityId()));
        }
        // 能力描述
        if (StringUtils.isNotEmpty(prdEmployeCompositeAbilityQuery.getAbilityDesc())) {
            predicates.add(qPrdEmployeCompositeAbilityDO.abilityDesc.eq(prdEmployeCompositeAbilityQuery.getAbilityDesc()));
        }
        // 主能力
        if (null != prdEmployeCompositeAbilityQuery.getMainFlag()) {
            predicates.add(qPrdEmployeCompositeAbilityDO.mainFlag.eq(prdEmployeCompositeAbilityQuery.getMainFlag()));
        }
        // 辅能力
        if (null != prdEmployeCompositeAbilityQuery.getAuxFlag()) {
            predicates.add(qPrdEmployeCompositeAbilityDO.auxFlag.eq(prdEmployeCompositeAbilityQuery.getAuxFlag()));
        }
        // 当量系数
        if (null != prdEmployeCompositeAbilityQuery.getDlRatio()) {
            predicates.add(qPrdEmployeCompositeAbilityDO.dlRatio.eq(prdEmployeCompositeAbilityQuery.getDlRatio()));
        }
        // 获取时间
        if (null != prdEmployeCompositeAbilityQuery.getObtainTime()) {
            predicates.add(qPrdEmployeCompositeAbilityDO.obtainTime.eq(prdEmployeCompositeAbilityQuery.getObtainTime()));
        }
        // 上次认证时间
        if (null != prdEmployeCompositeAbilityQuery.getLastCertTime()) {
            predicates.add(qPrdEmployeCompositeAbilityDO.lastCertTime.eq(prdEmployeCompositeAbilityQuery.getLastCertTime()));
        }
        // 过期时间
        if (null != prdEmployeCompositeAbilityQuery.getExpirateTime()) {
            predicates.add(qPrdEmployeCompositeAbilityDO.expirateTime.eq(prdEmployeCompositeAbilityQuery.getExpirateTime()));
        }
        // 员工id
        if (null != prdEmployeCompositeAbilityQuery.getUserId()) {
            predicates.add(qPrdEmployeCompositeAbilityDO.userId.eq(prdEmployeCompositeAbilityQuery.getUserId()));
        }
        // 员工名称
        if (StringUtils.isNotEmpty(prdEmployeCompositeAbilityQuery.getEmpName())) {
            predicates.add(qPrdEmployeCompositeAbilityDO.empName.eq(prdEmployeCompositeAbilityQuery.getEmpName()));
        }
        // 员工编号
        if (StringUtils.isNotEmpty(prdEmployeCompositeAbilityQuery.getEmpDocNo())) {
            predicates.add(qPrdEmployeCompositeAbilityDO.empDocNo.eq(prdEmployeCompositeAbilityQuery.getEmpDocNo()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {

        long res = select(PrdEmployeCompositeAbilityVO.class)
                .where(bulidPredicate(prdEmployeCompositeAbilityQuery))
                .fetchCount();

        return res;


    }

    public Long updateAbility(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdEmployeCompositeAbilityDO);
        if (null != prdEmployeCompositeAbilityPayload.getMainFlag()) {
            update.set(qPrdEmployeCompositeAbilityDO.mainFlag, prdEmployeCompositeAbilityPayload.getMainFlag());
        }
        if (null != prdEmployeCompositeAbilityPayload.getAuxFlag()) {
            update.set(qPrdEmployeCompositeAbilityDO.auxFlag, prdEmployeCompositeAbilityPayload.getAuxFlag());
        }
        long res = update.where(qPrdEmployeCompositeAbilityDO.id.eq(prdEmployeCompositeAbilityPayload.getId()))
                .execute();
        return res;

    }


    public Long update(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdEmployeCompositeAbilityDO);
        if (null != prdEmployeCompositeAbilityPayload.getMainFlag()) {
            update.set(qPrdEmployeCompositeAbilityDO.mainFlag, prdEmployeCompositeAbilityPayload.getMainFlag());
        }
        // 编号
        if (StringUtils.isNotEmpty(prdEmployeCompositeAbilityPayload.getDocNo())) {
            update.set(qPrdEmployeCompositeAbilityDO.docNo, prdEmployeCompositeAbilityPayload.getDocNo());
        }
        // 能力名称
        if (StringUtils.isNotEmpty(prdEmployeCompositeAbilityPayload.getAbilityName())) {
            update.set(qPrdEmployeCompositeAbilityDO.abilityName, prdEmployeCompositeAbilityPayload.getAbilityName());
        }
        // 能力id
        if (null != prdEmployeCompositeAbilityPayload.getAbilityId()) {
            update.set(qPrdEmployeCompositeAbilityDO.abilityId, prdEmployeCompositeAbilityPayload.getAbilityId());
        }
        // 能力描述
        if (StringUtils.isNotEmpty(prdEmployeCompositeAbilityPayload.getAbilityDesc())) {
            update.set(qPrdEmployeCompositeAbilityDO.abilityDesc, prdEmployeCompositeAbilityPayload.getAbilityDesc());
        }
        // 主能力
        if (null != prdEmployeCompositeAbilityPayload.getMainFlag()) {
            update.set(qPrdEmployeCompositeAbilityDO.mainFlag, prdEmployeCompositeAbilityPayload.getMainFlag());
        }
        // 辅能力
        if (null != prdEmployeCompositeAbilityPayload.getAuxFlag()) {
            update.set(qPrdEmployeCompositeAbilityDO.auxFlag, prdEmployeCompositeAbilityPayload.getAuxFlag());
        }
        // 当量系数
        if (null != prdEmployeCompositeAbilityPayload.getDlRatio()) {
            update.set(qPrdEmployeCompositeAbilityDO.dlRatio, prdEmployeCompositeAbilityPayload.getDlRatio());
        }
        // 获取时间
        if (null != prdEmployeCompositeAbilityPayload.getObtainTime()) {
            update.set(qPrdEmployeCompositeAbilityDO.obtainTime, prdEmployeCompositeAbilityPayload.getObtainTime());
        }
        // 上次认证时间
        if (null != prdEmployeCompositeAbilityPayload.getLastCertTime()) {
            update.set(qPrdEmployeCompositeAbilityDO.lastCertTime, prdEmployeCompositeAbilityPayload.getLastCertTime());
        }
        // 过期时间
        if (null != prdEmployeCompositeAbilityPayload.getExpirateTime()) {
            update.set(qPrdEmployeCompositeAbilityDO.expirateTime, prdEmployeCompositeAbilityPayload.getExpirateTime());
        }
        // 员工id
        if (null != prdEmployeCompositeAbilityPayload.getUserId()) {
            update.set(qPrdEmployeCompositeAbilityDO.userId, prdEmployeCompositeAbilityPayload.getUserId());
        }
        // 员工名称
        if (StringUtils.isNotEmpty(prdEmployeCompositeAbilityPayload.getEmpName())) {
            update.set(qPrdEmployeCompositeAbilityDO.empName, prdEmployeCompositeAbilityPayload.getEmpName());
        }
        // 员工编号
        if (StringUtils.isNotEmpty(prdEmployeCompositeAbilityPayload.getEmpDocNo())) {
            update.set(qPrdEmployeCompositeAbilityDO.empDocNo, prdEmployeCompositeAbilityPayload.getEmpDocNo());
        }
        long res = update.where(qPrdEmployeCompositeAbilityDO.id.eq(prdEmployeCompositeAbilityPayload.getId()))
                .execute();
        return res;
    }

    public void updateAllMainFlag() {
        long res = jpaQueryFactory.update(qPrdEmployeCompositeAbilityDO)
                .set(qPrdEmployeCompositeAbilityDO.mainFlag, false)
                .where(qPrdEmployeCompositeAbilityDO.deleteFlag.eq(0))
                .execute();

    }

    public void updateAllAuxFlag() {
        long res = jpaQueryFactory.update(qPrdEmployeCompositeAbilityDO)
                .set(qPrdEmployeCompositeAbilityDO.auxFlag, false)
                .where(qPrdEmployeCompositeAbilityDO.deleteFlag.eq(0))
                .execute();

    }

    public Boolean updateStateByFormId(PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {
        long res = jpaQueryFactory.update(qPrdEmployeCompositeAbilityDO)
                .set(qPrdEmployeCompositeAbilityDO.state, prdEmployeCompositeAbilityPayload.getState())
                .where(qPrdEmployeCompositeAbilityDO.userId.eq(prdEmployeCompositeAbilityPayload.getUserId()))
                .where(qPrdEmployeCompositeAbilityDO.formId.eq(prdEmployeCompositeAbilityPayload.getFormId()))
                .execute();
        return res > 0;
    }
}

