package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;


import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeIndividAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeIndividAbilityService;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdEmployeIndividAbilityConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.PrdEmployeIndividAbilityDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeIndividAbilityPayload;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.repo.PrdEmployeIndividAbilityRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.PrdEmployeIndividAbilityDao;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeIndividAbilityVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.time.LocalDate;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-单项能力Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdEmployeIndividAbilityServiceImpl implements PrdEmployeIndividAbilityService {


    private final PrdEmployeIndividAbilityDao prdEmployeIndividAbilityDao;

    private final PrdEmployeIndividAbilityRepo prdEmployeIndividAbilityRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEmployeIndividAbilityVO save(PrdEmployeIndividAbilityPayload prdEmployeIndividAbilityPayload) {

        if (null == prdEmployeIndividAbilityPayload.getState()) {
            prdEmployeIndividAbilityPayload.setState(1);
        }
        checkData(prdEmployeIndividAbilityPayload);
        prdEmployeIndividAbilityPayload.setObtainTime(LocalDate.now());
        PrdEmployeIndividAbilityDO prdEmployeIndividAbilityDO = new PrdEmployeIndividAbilityDO();
        prdEmployeIndividAbilityDO = PrdEmployeIndividAbilityConvert.INSTANCE.p2d(prdEmployeIndividAbilityPayload);
        PrdEmployeIndividAbilityDO res = prdEmployeIndividAbilityRepo.save(prdEmployeIndividAbilityDO);
        return PrdEmployeIndividAbilityConvert.INSTANCE.d2v(res);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdEmployeIndividAbilityVO update(PrdEmployeIndividAbilityPayload prdEmployeIndividAbilityPayload) {

        Assert.notNull(prdEmployeIndividAbilityPayload.getId(), "id is null");
        PrdEmployeIndividAbilityVO res = save(prdEmployeIndividAbilityPayload);
        return res;

    }


    @Override
    public PrdEmployeIndividAbilityVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdEmployeIndividAbilityVO res = prdEmployeIndividAbilityDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdEmployeIndividAbilityVO> page(PrdEmployeIndividAbilityQuery prdEmployeIndividAbilityQuery) {

        PagingVO<PrdEmployeIndividAbilityVO> res = prdEmployeIndividAbilityDao.page(prdEmployeIndividAbilityQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdEmployeIndividAbilityDao.del(ids);
        return res;

    }

    @Override
    public List<PrdEmployeIndividAbilityVO> getList(PrdEmployeIndividAbilityQuery prdEmployeIndividAbilityQuery) {

        List<PrdEmployeIndividAbilityVO> res = prdEmployeIndividAbilityDao.getList(prdEmployeIndividAbilityQuery);
        return res;

    }

    @Override
    @Transactional
    public Boolean batchSave(List<PrdEmployeIndividAbilityPayload> prdEmployeIndividAbilityPayload) {
        for (PrdEmployeIndividAbilityPayload payload : prdEmployeIndividAbilityPayload) {
            save(payload);
        }
        return true;
    }


    /**
     * 数据校验
     *
     * @param prdEmployeIndividAbilityPayload
     */
    private void checkData(PrdEmployeIndividAbilityPayload prdEmployeIndividAbilityPayload) {

        if (null == (prdEmployeIndividAbilityPayload.getUserId())) {
            throw new BusinessException("userId不能为空");
        }
        if (null == (prdEmployeIndividAbilityPayload.getAbilityLevelId())) {
            throw new BusinessException("abilityLevelId不能为空");
        }

    }


}

