package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResPortrayalEvalConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.*;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResPortrayalEvalConfigDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResPortrayalEvalConfigDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

@Service
@RequiredArgsConstructor
@Slf4j
public class ResEvaluateServiceImpl implements ResEvaluateService {

    private final PrdEvaluateService prdEvaluateService;

    private final ResPortrayalEvalConfigDAO resPortrayalEvalConfigDAO;

    @Override
    public ResEvaluateVO getResEvaluateScore(Long userId) {
        PrdEvaluateQuery prdEvaluateQuery = new PrdEvaluateQuery();
        prdEvaluateQuery.setToEvalUserId(userId);
        List<PrdEvaluateVO> prdEvaluateVOList = prdEvaluateService.getList(prdEvaluateQuery);
        if (prdEvaluateVOList == null) {
            return null;
        }
        Map<Long, ResEvalScoreVO> evaluateMap = new HashMap<>();
        for (PrdEvaluateVO prdEvaluateVO : prdEvaluateVOList) {
            List<PrdEvaluateDtlVO> prdEvaluateDtlVOList = prdEvaluateVO.getPrdEvaluateDtlVOList();
            if (prdEvaluateDtlVOList != null && prdEvaluateDtlVOList.size() > 0) {
                for (PrdEvaluateDtlVO prdEvaluateDtlVO : prdEvaluateDtlVOList) {
                    if (evaluateMap.containsKey(prdEvaluateDtlVO.getPointId())) {
                        ResEvalScoreVO resEvalScoreVO = evaluateMap.get(prdEvaluateDtlVO.getPointId());
                        BigDecimal totalScore = resEvalScoreVO.getTotalScore().add(prdEvaluateDtlVO.getScore());
                        Long size = resEvalScoreVO.getSize() + 1;
                        ResEvalScoreVO newResEvalScoreVO = new ResEvalScoreVO();
                        newResEvalScoreVO.setTotalScore(totalScore);
                        newResEvalScoreVO.setSize(size);
                        newResEvalScoreVO.setPointId(prdEvaluateDtlVO.getPointId());
                        newResEvalScoreVO.setPointName(prdEvaluateDtlVO.getPointName());
                        evaluateMap.put(prdEvaluateDtlVO.getPointId(), newResEvalScoreVO);
                    } else {
                        BigDecimal totalScore = prdEvaluateDtlVO.getScore();
                        Long size = 1L;
                        ResEvalScoreVO newResEvalScoreVO = new ResEvalScoreVO();
                        newResEvalScoreVO.setTotalScore(totalScore);
                        newResEvalScoreVO.setSize(size);
                        newResEvalScoreVO.setPointId(prdEvaluateDtlVO.getPointId());
                        newResEvalScoreVO.setPointName(prdEvaluateDtlVO.getPointName());
                        evaluateMap.put(prdEvaluateDtlVO.getPointId(), newResEvalScoreVO);
                    }
                }
            }
        }
        List<ResEvaluateDtlVO> resEvaluateDtlVOList = new ArrayList<>();
        BigDecimal evalTotalScore = new BigDecimal(0);
        BigDecimal resComprehensiveScore = null;
        if (!ObjectUtils.isEmpty(evaluateMap)) {
            for (Long key : evaluateMap.keySet()) {
                ResEvalScoreVO resEvalScoreVO = evaluateMap.get(key);
                BigDecimal evalPointTotalScore = resEvalScoreVO.getTotalScore();
                evalTotalScore = evalTotalScore.add(evalTotalScore);
                Long evalSize = resEvalScoreVO.getSize();
                BigDecimal avgScore = evalPointTotalScore.divide(BigDecimal.valueOf(evalSize), 1, RoundingMode.HALF_DOWN);
                ResEvaluateDtlVO resEvaluateDtlVO = new ResEvaluateDtlVO();
                resEvaluateDtlVO.setEvalPointId(key);
                resEvaluateDtlVO.setEvalPoint(resEvalScoreVO.getPointName());
                resEvaluateDtlVO.setEvalScore(avgScore);
                resEvaluateDtlVOList.add(resEvaluateDtlVO);
            }
            BigDecimal allTotalScore = BigDecimal.ZERO;
            for (ResEvaluateDtlVO resEvaluateDtlVO : resEvaluateDtlVOList) {
                allTotalScore = allTotalScore.add(resEvaluateDtlVO.getEvalScore());
            }
            resComprehensiveScore = allTotalScore.divide(BigDecimal.valueOf(resEvaluateDtlVOList.size()), 1, RoundingMode.HALF_DOWN);
        }
        ResEvaluateVO resEvaluateVO = new ResEvaluateVO();
        resEvaluateVO.setEvalDtl(resEvaluateDtlVOList);
        resEvaluateVO.setComprehensiveScore(resComprehensiveScore);
        return resEvaluateVO;
    }


    @Override
    @Transactional
    public void updateResPortrayalEvalConfig(ResPortrayalEvalConfigPayload payload) {
        Long userId = payload.getUserId();
        String oldResEvalPointIds = resPortrayalEvalConfigDAO.getResEvalPointIds(userId);
        String newEvalPointIdList = null;
        StringBuilder evalPointIdList = new StringBuilder();
        for (Long evalPointId : payload.getEvalPointIds()) {
            evalPointIdList.append(',').append(evalPointId);
        }
        if (!ObjectUtils.isEmpty(payload.getEvalPointIds())) {
            newEvalPointIdList = evalPointIdList.substring(1);
        }
        ResPortrayalEvalConfigDO defaultConfigDO = new ResPortrayalEvalConfigDO();
        defaultConfigDO.setUserId(userId);
        defaultConfigDO.setEvalPointIds(newEvalPointIdList);
        if (oldResEvalPointIds != null) {
            resPortrayalEvalConfigDAO.updateResConfig(defaultConfigDO);
        } else {
            resPortrayalEvalConfigDAO.saveConfig(defaultConfigDO);
        }


    }

    @Override
    @Transactional
    public void updateResPortrayalEvalDefaultConfig(Long[] evalPointIds) {
        String oldDefaultEvalPointIds = resPortrayalEvalConfigDAO.getDefaultEvalPointIds();
        StringBuilder evalPointIdList = new StringBuilder();
        String newEvalPointIdList = null;
        for (Long evalPointId : evalPointIds) {
            evalPointIdList.append(',').append(evalPointId);
        }
        if (!ObjectUtils.isEmpty(evalPointIds)) {
            newEvalPointIdList = evalPointIdList.substring(1);
        }
        if (oldDefaultEvalPointIds != null) {
            resPortrayalEvalConfigDAO.updateDefaultConfig(newEvalPointIdList);
        } else {
            ResPortrayalEvalConfigDO defaultConfigDO = new ResPortrayalEvalConfigDO();
            defaultConfigDO.setDefaultFlag(true);
            defaultConfigDO.setEvalPointIds(newEvalPointIdList);
            resPortrayalEvalConfigDAO.saveConfig(defaultConfigDO);
        }
    }

    @Override
    public List<Long> getResPortrayalEvalPoints(Long userId) {
        String resEvalPoints = resPortrayalEvalConfigDAO.getResEvalPointIds(userId);
        if (resEvalPoints == null) {
            return null;
        } else {
            String[] arr = resEvalPoints.split(",");
            return Arrays.stream(arr)
                    .map(Long::parseLong).toList();
        }

    }

    @Override
    public List<Long> getResPortrayalEvalDefaultConfig() {
        String defaultEvalPoints = resPortrayalEvalConfigDAO.getDefaultEvalPointIds();
        if (defaultEvalPoints == null) {
            return null;
        } else {
            String[] arr = defaultEvalPoints.split(",");
            return Arrays.stream(arr)
                    .map(Long::parseLong).toList();
        }

    }

    @Override
    public List<Long> getResPortrayalEvalConfig(Long userId) {
        String resEvalPoints = resPortrayalEvalConfigDAO.getResEvalPointIds(userId);
        if (resEvalPoints == null) {
            String defaultEvalPoints = resPortrayalEvalConfigDAO.getDefaultEvalPointIds();
            if (defaultEvalPoints == null) {
                return null;
            } else {
                String[] arr = defaultEvalPoints.split(",");
                return Arrays.stream(arr)
                        .map(Long::parseLong).toList();
            }
        } else {
            String[] arr = resEvalPoints.split(",");
            return Arrays.stream(arr)
                    .map(Long::parseLong).toList();
        }
    }

    public BigDecimal getResProjEvaluateScore(Long userId) {
        PrdEvaluateQuery prdEvaluateQuery = new PrdEvaluateQuery();
        prdEvaluateQuery.setToEvalUserId(userId);
        prdEvaluateQuery.setCate("PROJ");
        BigDecimal projEvalScore = new BigDecimal(0);
        List<PrdEvaluateVO> prdEvaluateVOList = prdEvaluateService.getList(prdEvaluateQuery);
        if (prdEvaluateVOList != null && prdEvaluateVOList.size() > 0) {
            BigDecimal totalScore = new BigDecimal(0);
            int size = 0;
            for (PrdEvaluateVO prdEvaluateVO : prdEvaluateVOList) {
                totalScore = totalScore.add(prdEvaluateVO.getAverageScore());
                size++;
            }
            projEvalScore = totalScore.subtract(BigDecimal.valueOf(size)).setScale(1, RoundingMode.HALF_DOWN);
        }
        return projEvalScore;
    }
}
