package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResultQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResSearchQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.*;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.*;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResSearchDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class ResSearchServiceImpl implements ResSearchService {
    private final ResSearchDAO resSearchDAO;

    private final PersonResService personResService;

    private final PrdEmployeCompositeAbilityService employeCompositeAbilityService;

    private final PrdPerformanceExamResultService performanceExamResultService;

    private final ResEvaluateService resEvaluateService;

    private final UdcUtil udcUtil;

    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;


    @Override
    public PagingVO<ResSearchVO> queryPaging(ResSearchQuery query) {
        //仅查询在职人员
        List<String> resStatusList = Arrays.asList("3", "4", "5");
        query.setResourceStatusList(resStatusList);
        PagingVO<ResSearchVO> resSearchPage = resSearchDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty(resSearchPage)) {
            List<ResSearchVO> resSearchVOList = resSearchPage.getRecords();
            for (ResSearchVO resSearchVO : resSearchVOList) {
                PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery = new PrdEmployeCompositeAbilityQuery();
                prdEmployeCompositeAbilityQuery.setUserId(resSearchVO.getUserId());
                prdEmployeCompositeAbilityQuery.setMainFlag(true);
                List<PrdEmployeCompositeAbilityVO> prdEmployeCompositeAbilityVOList = prdEmployeCompositeAbilityService.getList(prdEmployeCompositeAbilityQuery);
                if (!ObjectUtils.isEmpty(prdEmployeCompositeAbilityVOList)) {
                    resSearchVO.setCapsetLevelName(prdEmployeCompositeAbilityVOList.get(0).getAbilityName());
                }
            }
            resSearchPage.setRecords(resSearchVOList);
        }
        return resSearchPage;
    }


    @Override
    public ResPortrayalVO getPortrayal(Long userId) {
        ResPortrayalVO resPortrayalVO = new ResPortrayalVO();
        PersonResVO personResVO = personResService.queryByUserId(userId);
        ResEvaluateVO resEvaluateVO = personResVO.getResEvaluateVO();
        if (resEvaluateVO != null) {
            List<Long> keyPointIds = resEvaluateService.getResPortrayalEvalConfig(userId);
            if (keyPointIds == null) {
                resEvaluateVO.setEvalDtl(null);
            } else {
                List<ResEvaluateDtlVO> resEvaluateDtlVOList = resEvaluateVO.getEvalDtl();
                resEvaluateDtlVOList = resEvaluateDtlVOList.stream().filter(e -> keyPointIds.contains(e.getEvalPointId())).collect(Collectors.toList());
                resEvaluateVO.setEvalDtl(resEvaluateDtlVOList);
            }
            personResVO.setResEvaluateVO(resEvaluateVO);
        }
        List<PersonEduExperienceVO> personEduExperienceVOList = personResVO.getEduExperienceVOList();
        udcUtil.translateList(personEduExperienceVOList);
        resPortrayalVO.setPersonResVO(personResVO);
        BigDecimal resProjEvaluateScore = resEvaluateService.getResProjEvaluateScore(userId);
        resPortrayalVO.setProjEvalScore(resProjEvaluateScore);

        PrdEmployeCompositeAbilityQuery abilityQuery = new PrdEmployeCompositeAbilityQuery();
        abilityQuery.setUserId(userId);
        List<PrdEmployeCompositeAbilityVO> employeCompositeAbilityVOList = employeCompositeAbilityService.getList(abilityQuery);
        resPortrayalVO.setCompositeAbilityVOList(employeCompositeAbilityVOList);
        PrdPerformanceExamResultQuery examResultQuery = new PrdPerformanceExamResultQuery();
        examResultQuery.setUserId(userId);
        List<PrdPerformanceExamResultVO> prdPerformanceExamResultVOList = performanceExamResultService.getList(examResultQuery);
        resPortrayalVO.setPrdPerformanceExamResultVOList(prdPerformanceExamResultVOList);
        return resPortrayalVO;
    }
}
