package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResourcePlanQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResourcePlanQueryService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.*;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetPlanService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetPlanVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanDtlQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.DayJsonVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanRoleService;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResourcePlanQueryDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgPersonDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class ResourcePlanQueryServiceImpl implements ResourcePlanQueryService {

    private final PmsResourcePlanRoleService resourcePlanRoleService;

    private final TimesheetPlanService timesheetPlanService;

    private final ResourcePlanQueryDAO resourcePlanQueryDAO;

    private final CacheUtil cacheUtil;

    private final TaskInfoService taskInfoService;

    private final PrdOrgPersonDAO prdOrgPersonDAO;

    private final PrdOrgEmployeeDAO employeeDAO;
    private final PersonPlanDtlService personPlanDtlService;
    private final PersonPlanService personPlanService;

    public PagingVO<ResourcePlanQueryVO> query(ResourcePlanQuery query) {

        List<ResourcePlanQueryVO> resourcePlanQueryVOList = new ArrayList<>();
        long resCount = 0L;
        PagingVO<Long> resPage = resourcePlanQueryDAO.listResIds(query);
        resCount = resPage.getTotal();
        List<Long> resIds = resPage.getRecords();
        for (Long resId : resIds) {
            ResourcePlanQueryVO resourcePlanQueryVO = new ResourcePlanQueryVO();
            PrdOrgEmployeeVO employeeVO = cacheUtil.getEmployee(resId);
            PrdOrgPersonDO prdOrgPersonDO = employeeDAO.queryPersonById(employeeVO.getPersonId());
//            PrdOrgPersonDO prdOrgPersonDO = prdOrgPersonDAO.findByKey(employeeVO.getPersonId());
            resourcePlanQueryVO.setEmployeeName(prdOrgPersonDO.getPersonName());
            resourcePlanQueryVO.setRoleName(employeeVO.getRoleName());
            resourcePlanQueryVO.setUserId(employeeVO.getUserId());
            LocalDate planStartDate = query.getPlanStartDate();
            LocalDate planEndDate = query.getPlanEndDate();
            List<String> yearWeekList = getWeeks(planStartDate, planEndDate);
            List<WorkingCalendarPlanVO> workingCalendarPlanVOList = new ArrayList<>();
            List<TaskInfoVO> taskInfoVOList = new ArrayList<>();
            if (query.getShowItems() != null && query.getShowItems().contains("tasks")) {
                TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
                taskInfoQuery.setTaskResId(resId);
                taskInfoVOList = taskInfoService.queryList(taskInfoQuery);
            }
            List<PersonPlanDtlVO> pmsResourcePlanRoleVOList = new ArrayList<>();
            if (query.getShowItems() != null && query.getShowItems().contains("projectResPlans")) {
                PersonPlanDtlQuery planRoleQuery = new PersonPlanDtlQuery();
                planRoleQuery.setResId(resId);
                pmsResourcePlanRoleVOList = personPlanDtlService.getList(planRoleQuery);
            }
            List<TimesheetPlanVO> timesheetPlanVOList = new ArrayList<>();
            if (query.getShowItems() != null && query.getShowItems().contains("workPlans")) {
                TimesheetPlanQuery timesheetPlanQuery = new TimesheetPlanQuery();
                timesheetPlanQuery.setTsUserId(resId);
                timesheetPlanVOList = timesheetPlanService.queryList(timesheetPlanQuery);
            }

            for (String yearWeek : yearWeekList) {
                WorkingCalendarPlanVO workingCalendarPlanVO = new WorkingCalendarPlanVO();
                LocalDate[] weekStartEndList = getWeekStartEndDate(yearWeek);//周一,周日
                workingCalendarPlanVO.setYearWeek(yearWeek);
                LocalDate weekStartDate = weekStartEndList[0];
                LocalDate weekEndDate = weekStartEndList[1];
                List<TaskItemVO> taskItemVOList = new ArrayList<>();
                List<WorkPlanVO> workPlanVOList = new ArrayList<>();
                List<PlanItemVO> planItemVOList = new ArrayList<>();//项目资源规划
                List<PlanItemVO> planOppoViews = new ArrayList<>();//商机

                if (!ObjectUtils.isEmpty(timesheetPlanVOList)) {
                    //获取资源工作计划
                    List<TimesheetPlanVO> collect = timesheetPlanVOList.stream().filter(v -> !v.getWorkDate().isBefore(weekStartDate) && !v.getWorkDate().isAfter(weekEndDate)).collect(Collectors.toList());
                    for (TimesheetPlanVO timesheetPlanVO : collect) {
                        WorkPlanVO workPlanVO = new WorkPlanVO();
                        workPlanVO.setDateFrom(timesheetPlanVO.getWorkDate());
                        workPlanVO.setDateTo(timesheetPlanVO.getWorkDate());
                        workPlanVO.setPlanType(timesheetPlanVO.getType());
                        workPlanVO.setTaskName(timesheetPlanVO.getTaskName());
                        workPlanVO.setId(timesheetPlanVO.getId());
                        workPlanVO.setPlanStatus(timesheetPlanVO.getApprStatus());
                        workPlanVOList.add(workPlanVO);
                    }
                }
                //获取资源项目和商机规划
                if (!ObjectUtils.isEmpty(pmsResourcePlanRoleVOList)) {
                    //资源规划主表ids
                    List<Long> planIds = pmsResourcePlanRoleVOList.stream().map(PersonPlanDtlVO::getPlanId).distinct().collect(Collectors.toList());
                    PersonPlanQuery personPlanQuery = new PersonPlanQuery();
                    personPlanQuery.setIds(planIds);
                    List<PersonPlanVO> personPlanList = personPlanService.getList(personPlanQuery);
                    pmsResourcePlanRoleVOList.forEach(vo -> {
                        Optional<PersonPlanVO> personPlan = personPlanList.stream().filter(plan -> plan.getId().equals(vo.getPlanId())).findFirst();
                        if (personPlan.isPresent()) {
                            PlanItemVO planItemVO = new PlanItemVO();
                            String planType = personPlan.get().getPlanType();
                            if (StringUtils.hasText(planType) && (planType.equals(PersonPlanTypeEnum.PRE_SALES.getCode()) || planType.equals(PersonPlanTypeEnum.DELIVERY.getCode()))) {
                                planOppoViews.add(planItemVO);
                            } else {
                                planItemVOList.add(planItemVO);
                            }
                            planItemVO.setProjName(personPlan.get().getObjName());
                            planItemVO.setProjdays(BigDecimal.ZERO);
                            List<LocalDate> planDays = new ArrayList<>();
                            if (StringUtils.hasText(vo.getDaysJson())) {
                                List<DayJsonVO> dayJsonVOS = JSON.parseArray(vo.getDaysJson(), DayJsonVO.class);
                                for (DayJsonVO dayJsonVO : dayJsonVOS) {
                                    LocalDate date = LocalDate.parse(dayJsonVO.getDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                                    if (!date.isBefore(weekStartDate) && !date.isAfter(weekEndDate)) {
                                        //获取在查询范围内的规划
                                        planDays.add(date);
                                        planItemVO.setProjdays(planItemVO.getProjdays().add(dayJsonVO.getDay()));
                                    }
                                }
                            }
                            planItemVO.setPlanDays(planDays);
                            if (!ObjectUtils.isEmpty(planDays)) {
                                LocalDate min = Collections.min(planDays);
                                LocalDate max = Collections.max(planDays);
                                planItemVO.setPlanStartDate(min);
                                planItemVO.setPlanEndDate(max);
                            }
                        }
                    });
//                    for (PersonPlanDtlVO roleVO : pmsResourcePlanRoleVOList) {
//
//                        List<PmsResourcePlanDaysVO> pmsResourcePlanDaysVOList = roleVO.getDaysInfo();
//                        if (!ObjectUtils.isEmpty(pmsResourcePlanDaysVOList)) {
//                            List<PmsResourcePlanDaysVO> filterPlanDaysList = pmsResourcePlanDaysVOList.
//                                    stream().filter(pmsResourcePlanDaysVO -> pmsResourcePlanDaysVO.getStartDate().isEqual(weekStartDate)).collect(Collectors.toList());
//                            for (PmsResourcePlanDaysVO pmsResourcePlanDaysVO : filterPlanDaysList) {
//                                PlanItemVO planItemVO = new PlanItemVO();
//                                planItemVO.setProjdays(pmsResourcePlanDaysVO.getDays());
//                                planItemVO.setProjName(roleVO.getObjName());
//                                planItemVOList.add(planItemVO);
//                            }
//                        }
//                    }
                }

                //获取任务信息
                if (!ObjectUtils.isEmpty(taskInfoVOList)) {
                    for (TaskInfoVO taskInfoVO : taskInfoVOList) {
                        if (taskInfoVO.getPlanStartDate() == null || taskInfoVO.getPlanEndDate() == null) {
                            continue;
                        }
                        if (taskInfoVO.getPlanEndDate().isBefore(weekStartDate) || taskInfoVO.getPlanStartDate().isAfter(weekEndDate)) {
                            continue;
                        }
                        //计算重叠区间
                        LocalDate overlapStart = weekStartDate.isAfter(taskInfoVO.getPlanStartDate()) ? weekStartDate : taskInfoVO.getPlanStartDate();
                        LocalDate overlapEnd = weekEndDate.isBefore(taskInfoVO.getPlanEndDate()) ? weekEndDate : taskInfoVO.getPlanEndDate();
                        if (!overlapStart.isAfter(overlapEnd)) {
                            TaskItemVO taskItemVO = new TaskItemVO();
                            taskItemVO.setTaskName(taskInfoVO.getTaskName());
                            taskItemVO.setPlanStartDate(overlapStart);
                            taskItemVO.setPlanEndDate(overlapEnd);
                            List<LocalDate> dateList = new ArrayList<>();
                            //计算两个日期内所有日期
                            LocalDate currentDate = overlapStart;
                            while (!currentDate.isAfter(overlapEnd)) {
                                dateList.add(currentDate);
                                currentDate = currentDate.plusDays(1);
                            }
                            taskItemVO.setPlanDays(dateList);
                            taskItemVOList.add(taskItemVO);
                        }
                    }
                }
                workingCalendarPlanVO.setPlanViews(workPlanVOList);
                workingCalendarPlanVO.setPlanItemVies(planItemVOList);
                workingCalendarPlanVO.setTaskViews(taskItemVOList);
                workingCalendarPlanVO.setPlanOppoVies(planOppoViews);
                workingCalendarPlanVOList.add(workingCalendarPlanVO);
            }
            resourcePlanQueryVO.setWorkingCalendarPlan(workingCalendarPlanVOList);
            resourcePlanQueryVOList.add(resourcePlanQueryVO);
        }
        return PagingVO.<ResourcePlanQueryVO>builder().records(resourcePlanQueryVOList).total(resCount).build();

    }

    /**
     * 获取2个日期之间的年周数组
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @return
     */
    public static List<String> getWeeks(LocalDate startDate, LocalDate endDate) {
        //起始日期晚于结束日期，返回空
        if (startDate == null || endDate == null || startDate.isAfter(endDate)) {
            return null;
        }
        List<String> weeks = new ArrayList<>();
        LocalDate mondayS = startDate.with(DayOfWeek.MONDAY);//开始日期的周一日期
        LocalDate mondayE = endDate.with(DayOfWeek.MONDAY);//结束日期的周一日期
        String week = dateToYearWeek(mondayS);//开始日期的周数
        weeks.add(week);
        while (!mondayS.isEqual(mondayE)) {
            mondayS = mondayS.plusWeeks(1);//加1周
            week = dateToYearWeek(mondayS);
            weeks.add(week);
        }
        return weeks;
    }

    /**
     * 日期转年周
     *
     * @param date
     * @return
     */
    public static String dateToYearWeek(LocalDate date) {
        if (date == null) {
            return "";
        }
        int weekBaseYear = date.get(WeekFields.ISO.weekBasedYear());//2018-12-31 返回2019
        int weeks = date.get(WeekFields.ISO.weekOfWeekBasedYear());
        String week = weeks < 10 ? "0" + weeks : "" + weeks;
        return weekBaseYear + week;
    }

    /**
     * 查询指定年周数的周一 和周天
     *
     * @param yearWeek
     * @return 日期数组，周一日期、周天日期
     */
    public static LocalDate[] getWeekStartEndDate(String yearWeek) {
        //参数格式校验
        if (yearWeek == null || yearWeek.length() != 6) {
            log.info("参数参数非法，需要yyyyww格式的数据！非法参数：{}", yearWeek);
            return null;
        }
        int year = -1;
        int week = -1;
        try {
            year = Integer.parseInt(yearWeek.substring(0, 4));
            week = Integer.parseInt(yearWeek.substring(4, 6));
        } catch (NumberFormatException e) {
            log.info("字符串转换数据错误：{}", e);
            return null;
        }
        //最大周数校验
        int max = LocalDate.of(year, 12, 31).get(WeekFields.ISO.weekOfWeekBasedYear());
        if (max == 1) {
            max = LocalDate.of(year, 12, 31).minusWeeks(1).get(WeekFields.ISO.weekOfWeekBasedYear());
        }
        if (week > max) {
            log.info(String.format("查询指定周数的日期失败，查询周数(%d)超过指定年份(%d年)的最大周数(%d)", week, year, max));
        }

        LocalDate monday = null;//指定年周的周一
        LocalDate sunday = null;//指定年周的周天
        //获取年初日期
        LocalDate firstDayOfYear = LocalDate.of(year, 1, 1);
        //获取年初所在周的周一、周天日期
        LocalDate firstMonday = firstDayOfYear.with(DayOfWeek.MONDAY);
        LocalDate firstSunday = firstDayOfYear.with(DayOfWeek.SUNDAY);
        //判断年初是否是第一周
        int firstDayWeek = firstDayOfYear.get(WeekFields.ISO.weekOfWeekBasedYear());
        if (firstDayWeek > 1) {//年初归属于去年的最后一周
            monday = firstMonday.plusWeeks(week);
            sunday = firstSunday.plusWeeks(week);
        } else {
            monday = firstMonday.plusWeeks(week - 1);
            sunday = firstSunday.plusWeeks(week - 1);
        }
        return new LocalDate[]{monday, sunday};
    }

}
