package com.elitesland.tw.tw5.server.prd.mpxj.dao;

import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.mpxj.vo.MpxjMppTaskVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.mpxj.entity.QMpxjMppTaskDO;
import com.elitesland.tw.tw5.server.prd.mpxj.repo.MpxjMppTaskRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class MpxjMppTaskDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final MpxjMppTaskRepo repo;

    private final QMpxjMppTaskDO qdo = QMpxjMppTaskDO.mpxjMppTaskDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<MpxjMppTaskVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(MpxjMppTaskVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.projectId,
                qdo.wbsId,
                qdo.parentId,
                qdo.rowId,
                qdo.rowParentId,
                qdo.tasKLevel,
                qdo.wbsCode,
                qdo.taskName,
                qdo.taskProgress,
                qdo.planStartDate,
                qdo.planFinishDate,
                qdo.baseline2FinishDate,
                qdo.planDueDate,
                qdo.sourceName,
                qdo.taskPredecessors,
                qdo.summaryFlag
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param projectId 查询参数
     * @return jpaQuery对象
     */
    public List<MpxjMppTaskVO> queryListByProjectId(Long projectId) {
        JPAQuery<MpxjMppTaskVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(qdo.projectId.eq(projectId));
        // 动态排序
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.asc("wbsCode"));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));
        return jpaQuery.fetch();
    }

}
