package com.elitesland.tw.tw5.server.prd.mpxj.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.api.prd.mpxj.vo.MpxjMppTaskVO;
import com.elitesland.tw.tw5.api.prd.mpxj.vo.RelationVO;
import com.elitesland.tw.tw5.api.prd.mpxj.vo.ResourceVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.mpxj.dao.MpxjMppTaskDAO;
import com.elitesland.tw.tw5.server.prd.mpxj.entity.MpxjMppTaskDO;
import com.elitesland.tw.tw5.server.prd.mpxj.repo.MpxjMppTaskRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.sf.mpxj.*;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.reader.UniversalProjectReader;
import org.apache.commons.io.FilenameUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

@Service
@RequiredArgsConstructor
@Slf4j
public class MpxjMppConstsServiceImpl {

    private final MpxjMppTaskDAO dao;
    private final MpxjMppTaskRepo repo;

    /**
     * project-mpp d导入
     *
     * @param file
     */
    @Transactional
    public void importElecPlanTask(MultipartFile file, Long projectId) {
        String extension = FilenameUtils.getExtension(file.getOriginalFilename());
        if (!"mpp".equals(extension)) {
            log.info("导入失败，文件名后缀必须为“mpp”！");
        }
        MPPReader mppRead = new MPPReader();
        ProjectFile project = null;
        try {
            project = mppRead.read(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        List<Task> tasks = project.getTasks();
        List<MpxjMppTaskDO> taskDOList = new ArrayList<>();
        for (int i = 1; i < tasks.size(); i++) {
            Task task = tasks.get(i);
            analysisFile(task, taskDOList);
        }
        taskDOList.forEach(taskDO -> taskDO.setProjectId(projectId));
        repo.saveAll(taskDOList);
        updateParentId(taskDOList);
    }


    /**
     * 生成保存数据
     *
     * @param task
     * @param taskDOList
     */
    void analysisFile(Task task, List<MpxjMppTaskDO> taskDOList) {
        //任务项ID
        Integer task_id = task.getID();
        //父级任务项ID
        Integer task_parent_def_id = task.getParentTask().getID();
        //任务项等级
        Integer task_outline_level = task.getOutlineLevel();
        //wbs
        String task_wbs = task.getWBS();
        //任务项名称
        String task_name = task.getName();
        //计划开始日期
        Date task_start_date = task.getStart();
        //计划结束日期
        Date task_finish_date = task.getFinish();
        //基线2完成时间
        Date baselineEstimatedFinish = task.getBaselineEstimatedFinish(2);
        //工期差距
        double duration = task.getDuration().getDuration();


        //资源名称
        String task_leader = "";
        List<ResourceAssignment> resourceAssignments = task.getResourceAssignments();

        if (!ObjectUtils.isEmpty(resourceAssignments)) {
            List<ResourceVO> resources = new ArrayList<>();
            resourceAssignments.forEach(resourceAssignment -> {
                Resource resource = resourceAssignment.getResource();
                if (resource != null) {
                    ResourceVO resourceVO = new ResourceVO();
                    resourceVO.setName(resource.getName());
                    resourceVO.setId(resource.getID());
                    resourceVO.setUniqueID(resource.getUniqueID());
                    resources.add(resourceVO);
                }
            });
            if (resources.size() > 0) {
                task_leader = JSONObject.toJSONString(resources);
            }
        }
        //完成百分比
        String task_percentage = String.valueOf(task.getPercentageComplete().byteValue());
        //是否总账任务
        boolean summary = task.getSummary();
        //获取前置任务（任务流）
        List<Relation> task_predecessors = task.getPredecessors();
        String task_predecessors_str = null;
        if (task_predecessors != null) {
            List<RelationVO> taskRelations = new ArrayList<>();
            task_predecessors.forEach(relation -> {
                if (relation.getTargetTask() != null) {
                    RelationVO relationVO = new RelationVO();
                    relationVO.setUniqueID(relation.getUniqueID());
                    relationVO.setType(relation.getType().getValue());
                    relationVO.setTaskRefId(relation.getTargetTask().getID());
                    relationVO.setDuration(relation.getLag().getDuration());
                    taskRelations.add(relationVO);
                }
            });
            if (taskRelations.size() > 0) {
                task_predecessors_str = JSONObject.toJSONString(taskRelations);
            }
        }
        //前置任务

        MpxjMppTaskDO taskDO = new MpxjMppTaskDO();
        taskDO.setBaseline2FinishDate(baselineEstimatedFinish.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        taskDO.setPlanDueDate(duration);
        taskDO.setPlanFinishDate(task_finish_date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        taskDO.setPlanStartDate(task_start_date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        taskDO.setPlanDueDate(duration);
        taskDO.setRowId(task_id);
        taskDO.setRowParentId(task_parent_def_id);
        taskDO.setSourceName(task_leader);
        taskDO.setTasKLevel(task_outline_level);
        taskDO.setTaskName(task_name);
        taskDO.setTaskPredecessors(task_predecessors_str);
        taskDO.setTaskProgress(task_percentage);
        taskDO.setWbsCode(task_wbs);
        taskDO.setSummaryFlag(summary);
        taskDOList.add(taskDO);
    }

    /**
     * 赋值上级id
     *
     * @param taskDOList
     */
    void updateParentId(List<MpxjMppTaskDO> taskDOList) {
        taskDOList.forEach(taskDO -> {
            Integer rowParentId = taskDO.getRowParentId();
            Optional<MpxjMppTaskDO> first = taskDOList.stream().filter(rowParentTask -> rowParentTask.getRowId().equals(rowParentId)).findFirst();
            if (first.isPresent()) {
                taskDO.setParentId(first.get().getId());
            }

        });

    }

    public void exportElecPlanTask(HttpServletResponse response, Long projectId) {
        try {
            if (projectId == null) {
                throw TwException.error("", "所属项目不可为空");
            }
            List<MpxjMppTaskVO> mpxjMppTaskVOS = dao.queryListByProjectId(projectId);
            if (ObjectUtils.isEmpty(mpxjMppTaskVOS)) {
                throw TwException.error("", "数据不存在");
            }
            ProjectFile projectFile = new ProjectFile();

            mpxjMppTaskVOS.forEach(mpxjMppTaskVO -> {
                Task task = projectFile.addTask();
                //任务行id
                task.setID(mpxjMppTaskVO.getRowId());
                //wbs编码
                task.setWBS(mpxjMppTaskVO.getWbsCode());
                //任务级别
                task.setOutlineLevel(mpxjMppTaskVO.getTasKLevel());
                //任务名称
                task.setName(mpxjMppTaskVO.getTaskName());
                if (StringUtils.hasText(mpxjMppTaskVO.getTaskProgress())) {
                    //任务进度
                    task.setPercentageComplete(Double.parseDouble(mpxjMppTaskVO.getTaskProgress()));
                }
                Date baseline2FinishDate = Date.from(mpxjMppTaskVO.getBaseline2FinishDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());

                //基线二数据
                task.setBaselineEstimatedFinish(2, baseline2FinishDate);
                //工期
                task.setDuration(Duration.getInstance(mpxjMppTaskVO.getPlanDueDate(), TimeUnit.getInstance(TimeUnit.DAYS.getValue())));
                //开始时间
                Date planStartDate = Date.from(mpxjMppTaskVO.getPlanStartDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                task.setStart(planStartDate);
                //结束时间
                Date planFinishDate = Date.from(mpxjMppTaskVO.getPlanFinishDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                task.setFinish(planFinishDate);

                //是否总线任务
                if (mpxjMppTaskVO.getSummaryFlag()) {
                    task.setSummary(true);
                }
                //资源
                if (StringUtils.hasText(mpxjMppTaskVO.getSourceName())) {
                    // List<ResourceVO> os = (List<ResourceVO>) JSONArray.parseObject(mpxjMppTaskVO.getSourceName());
//                    List<ResourceVO> os = JSON.parseObject(mpxjMppTaskVO.getSourceName(), List.class);
                    List<ResourceVO> os = JSON.parseArray(mpxjMppTaskVO.getSourceName(), ResourceVO.class);
                    os.forEach(resourceVO -> {
                        Resource resource = projectFile.addResource();
                        resource.setID(resourceVO.getId());
                        resource.setName(resourceVO.getName());
                        task.addResourceAssignment(resource);
                    });
                }
            });
            //赋值前置任务
            List<Task> tasks = projectFile.getTasks();
            tasks.forEach(task -> {
                MpxjMppTaskVO mpxjMppTaskVO = mpxjMppTaskVOS.stream().filter(taskVO -> taskVO.getRowId().equals(task.getID())).findFirst().get();
                if (StringUtils.hasText(mpxjMppTaskVO.getTaskPredecessors())) {
//                    List<RelationVO> os = JSON.parseObject(mpxjMppTaskVO.getTaskPredecessors(), List.class);
                    List<RelationVO> os = JSON.parseArray(mpxjMppTaskVO.getTaskPredecessors(), RelationVO.class);
                    //List<RelationVO> os = (List<RelationVO>) JSONArray.parseObject(mpxjMppTaskVO.getTaskPredecessors());
                    os.forEach(relation -> {
                        Optional<Task> first = tasks.stream().filter(taskVO -> taskVO.getID().equals(relation.getTaskRefId())).findFirst();
                        if (first.isPresent()) {
                            task.addPredecessor(first.get(), RelationType.getInstance(relation.getType()), Duration.getInstance(relation.getDuration(), TimeUnit.getInstance(TimeUnit.DAYS.getValue())));
                        }
                    });
                }
                if (mpxjMppTaskVO.getParentId() != null) {
                    Optional<Task> first = tasks.stream().filter(taskVO -> taskVO.getID().intValue() == mpxjMppTaskVO.getParentId().intValue()).findFirst();
                    if (first.isPresent()) {
                        first.get().addChildTask(task);
                    }
                }
            });


            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MSPDIWriter writer = new MSPDIWriter();

            writer.write(projectFile, bos);

            InputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment;filename=project.xml");
            byte[] buffer = new byte[1024];
            int bytesRead;
            while ((bytesRead = byteArrayInputStream.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, bytesRead);
            }

            byteArrayInputStream.close();


        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void exportElecPlanTask3(HttpServletResponse response, Long projectId) {
        // 设置响应头，指定内容类型为二进制流，适用于.mpp文件这种二进制格式
        response.setContentType("application/octet-stream");
        // 设置响应头，告知浏览器以下载的方式处理文件，并指定文件名
        response.setHeader("Content-Disposition", "attachment;filename=\"" +
                LocalDate.now() + ".mpp\"");
        try {
            ClassPathResource classPathResource = new ClassPathResource("template/wwwwwwwwww.mpp");
            InputStream inputStream = classPathResource.getInputStream();
            ProjectReader reader = new UniversalProjectReader();
            // 读取.mpp文件的路径，这里需要替换为实际的文件路径
            //  FileInputStream fis = new FileInputStream(file);

//            //任务项ID
//            Integer task_id = task.getID();
//            //父级任务项ID
//            Integer task_parent_def_id = task.getParentTask().getID();
//            //任务项等级
//            Integer task_outline_level = task.getOutlineLevel();
//            //wbs
//            String task_wbs = task.getWBS();
//            //任务项名称
//            String task_name = task.getName();
//            //计划开始日期
//            Date task_start_date = task.getStart();
//            //计划结束日期
//            Date task_finish_date = task.getFinish();
//            //基线2完成时间
//            Date baselineEstimatedFinish = task.getBaselineEstimatedFinish(2);
//            //工期差距
//            double duration = task.getDuration().getDuration();


            ProjectFile project = reader.read(inputStream);
            Task task = project.addTask();
            task.setName("New Task Added");
            task.setID(999);
            // task.getParentTask().setID(222);
            task.setWBS("1.5.12.5");
            task.setSummary(true);
            Task parentTask = task.getParentTask();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MSPDIWriter writer = new MSPDIWriter();
            writer.write(project, bos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());

            OutputStream os = response.getOutputStream();


            byte[] buffer = new byte[1024];
            int bytesRead;
            while ((bytesRead = byteArrayInputStream.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }

            inputStream.close();
            bos.close();
            os.close();
        } catch (Exception e) {

            e.printStackTrace();

        }
    }

    public void exportElecPlanTask1(HttpServletResponse response, Long projectId) {
        // 设置响应头，指定内容类型为二进制流，适用于.mpp文件这种二进制格式
        response.setContentType("application/octet-stream");
        // 设置响应头，告知浏览器以下载的方式处理文件，并指定文件名
        response.setHeader("Content-Disposition", "attachment;filename=your_file_name.mpp");
        try {
            ClassPathResource classPathResource = new ClassPathResource("template/wwwwwwwwww.mpp");
            InputStream inputStream = classPathResource.getInputStream();
            MPPReader reader = new MPPReader();
            // 读取.mpp文件的路径，这里需要替换为实际的文件路径
            //  FileInputStream fis = new FileInputStream(file);


            OutputStream os = response.getOutputStream();

            byte[] buffer = new byte[1024];
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }

            inputStream.close();
            os.close();
        } catch (Exception e) {

            e.printStackTrace();

        }
    }

    public void exportElecPlanTask0(HttpServletResponse response, Long projectId) {

        ClassPathResource classPathResource = new ClassPathResource("template/projectWbs.mpp");
        try {
            File file = new File("template/projectWbs.mpp");
            ProjectReader reader = new UniversalProjectReader();
            ProjectFile project = reader.read(file);

//            InputStream inputStream = classPathResource.getInputStream();
//            MPPReader reader = new MPPReader();
            // 添加一个新任务
            Task newTask = project.addTask();
            newTask.setName("New Task Added");


            // 设置响应头，指定内容类型和文件名
            response.setContentType("application/vnd.ms-project");
            response.setHeader("Content-Disposition", "attachment; filename=modified_example.mpp");

            // 将修改后的项目数据写入输出流（response的输出流）
            OutputStream outputStream = response.getOutputStream();

            MSPDIWriter writer = new MSPDIWriter();

            writer.write(project, outputStream);
            outputStream.close();

        } catch (Exception e) {

            e.printStackTrace();

        }
    }
//    public void exportElecPlanTask(HttpServletResponse response) {
//        ClassPathResource classPathResource = new ClassPathResource("template/mpxjElecPlanTask.mpp");
//        try {
//            InputStream inputStream = classPathResource.getInputStream();
//            MPPReader mppRead = new MPPReader();
//            ProjectFile project = mppRead.read(inputStream);
//
//            List<MpxjMppTaskDO> all = repo.findAll();
//            addTask(project, all);
//
//            String fileName = "员工批量数据-" + LocalDate.now();
//
//            MPXWriter writer = new MPXWriter();
//            //  writer.write(project, fileName);
//
//            ServletOutputStream servletOutputStream = response.getOutputStream();
//            response.setContentType("application/x-download");
//            response.addHeader("Content-Disposition", "attachment;filename=\""
//                    + fileName + ".mpp\"");
//            writer.write(project, servletOutputStream);
//            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(servletOutputStream);
//            bufferedOutputStream.flush();
//            servletOutputStream.close();
//            bufferedOutputStream.close();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//    }
//
//    void addTask(ProjectFile project, List<MpxjMppTaskDO> all) {
//        for (MpxjMppTaskDO taskDO : all) {
//            Task task = project.addTask();
//            task.setID(taskDO.getRowId());
//            task.getParentTask().setID(taskDO.getRowParentId());
//            task.setOutlineLevel(taskDO.getTasKLevel());
//            task.setWBS(taskDO.getWbsCode());
//            //task.setStart(taskDO.getPlanStartDate());
//
//        }
//    }
//    public static boolean convertMpxToMpp(String mpxFilePath) {
//        int i = 0;
//        boolean retBooli = false;
////        if ((Mpx2MppUtil.isNullOrEmpty(mpxFilePath)) || (mpxFilePath.length() < 5)) {
////
////            return retBooli;
////
////        }
//
//        int j = 0;
//        try {
//            int k = 0;
//            boolean retBoolk = false;
//            try {
//                ComThread.InitSTA();
//                j = 1;
//            } catch (Error localError1) {
//                k = i;
//                retBoolk = retBooli;
//                try {
//                    if (activexComponent != null) {
//                        Dispatch.call(activexComponent, "Quit", new Object[]{Integer.valueOf(0)});
//                    }
//                } catch (Exception localException5) {
//                }
//                try {
//                    if (j != 0) {
//                        ComThread.Release();
//                    }
//                } catch (Error localError4) {
//                }
//                return retBoolk;
//
//            }
//
//            activexComponent = new ActiveXComponent("MsProject.Application");
//
//            try {
//
//                Variant localVariant = activexComponent.getProperty("Version");
//                if (localVariant.toDouble() >= 12.0D) {
//                    k = i;
//                    try {
//                        if (activexComponent != null) {
//                            Dispatch.call(activexComponent, "Quit", new Object[]{Integer.valueOf(0)});
//                        }
//                    } catch (Exception localException6) {
//                    }
//                    try {
//                        if (j != 0) {
//                            ComThread.Release();
//                        }
//                    } catch (Error localError5) {
//                    }
//                    return retBoolk;
//
//                    //return k;
//
//
//                }
//
//            } catch (Exception localException1) {
//
//                // LogFactory.getLog(Mpx2MppUtil.class).warn("Please install the Microsoft Project 2003 on the server");
//
//            }
//
//            activexComponent.setProperty("Visible", new Variant(false));
//
//            activexComponent.setProperty("DisplayAlerts", new Variant(false));
//
//            Dispatch.call(activexComponent, "FileOpen", new Object[]{mpxFilePath});
//
//            Dispatch.call(activexComponent, "FileSaveAs", new Object[]{mpxFilePath.substring(0, mpxFilePath.length() - 4) + ".mpp"});
//
//            i = 1;
//
//            retBooli = true;
//
//        } catch (Exception localError3) {
//
//            localError3.printStackTrace();
//
//        } finally {
//            try {
//                if (activexComponent != null)
//                    Dispatch.call(activexComponent, "Quit", new Object[]{Integer.valueOf(0)});
//            } catch (Exception localException7) {
//            }
//            try {
//                if (j != 0)
//                    ComThread.Release();
//
//            } catch (Error localError6) {
//            }
//        }
//
//        return retBooli;
//
//    }


//    public static boolean isNullOrEmpty(String myStr) {
//
//        return (myStr == null) || ("".equals(myStr.trim()));
//
//    }


/**
 * MPP文件的解析过程（此处是根据父子级任务id构造层级关系的）
 *
 * @param fileItem
 * @return
 * @throws Exception
 * <p>
 * 根据WBS编码构造层级关系
 * @param listModel
 * <p>
 * 根据WBS编码构造层级关系
 * @param listModel
 * <p>
 * 根据WBS编码构造层级关系
 * @param listModel
 * <p>
 * 根据WBS编码构造层级关系
 * @param listModel
 * <p>
 * 根据WBS编码构造层级关系
 * @param listModel
 * <p>
 * 根据WBS编码构造层级关系
 * @param listModel
 */
//    private List<ElecPlanTaskModel> importProjectFile(FileItem fileItem) throws Exception {

//        //构造一个临时路径存上传的文件
//        String exportFilePath = FileNameUtils.getExtension(fileItem.getName());
//        File file = new File(exportFilePath);
//
//        FileUtils.forceMkdir(file.getParentFile());
//        //将上传的文件写到临时路径里面
//        fileItem.write(file);
//        //组装目录的基础数据
//        List<ElecPlanTaskModel> listModel = new ArrayList<>();
//        MPPReader mppRead = new MPPReader();
//        //注意，如果在这一步出现了读取异常，肯定是版本不兼容，换个版本试试
//      //  ProjectFile pf = mppRead.read(file);
//        //从文件中获取的任务对象
//     //   List<Task> tasks = pf.getAllTasks();
//        for (int i = 1; i < tasks.size(); i++) {
//            Task task = tasks.get(i);
//            ElecPlanTaskModel taskModel = new ElecPlanTaskModel();
//
//            taskModel.setLevelNum(task.getOutlineLevel());
//            taskModel.setWbs(task.getWBS());
//            taskModel.setPlanStartTime(task.getStart());
//            taskModel.setPlanFinishTime(task.getFinish());
//            taskModel.setTaskName(task.getName());
//            //工期，拿到的是double类型，我存的类型是String需要转换为String
//            taskModel.setPlanDueTime(Long.toString(Math.round(task.getDuration().getDuration())));
//
//            taskModel.setWbsCode(String.valueOf(task.getFieldByAlias(MppConsts.WBS_CODE) == null ? "" : task.getFieldByAlias(MppConsts.WBS_CODE)));
//            taskModel.setGridName(String.valueOf(task.getFieldByAlias(MppConsts.GRID_NAME) == null ? "" : task.getFieldByAlias(MppConsts.GRID_NAME)));
//            taskModel.setFloor(String.valueOf(task.getFieldByAlias(MppConsts.FLOOR) == null ? "" : task.getFieldByAlias(MppConsts.FLOOR)));
//            taskModel.setTaskType(String.valueOf(task.getFieldByAlias(MppConsts.TASK_TYPE) == null ? "" : task.getFieldByAlias(MppConsts.TASK_TYPE)));
//            taskModel.setProfession(String.valueOf(task.getFieldByAlias(MppConsts.PROFESSION) == null ? "" : task.getFieldByAlias(MppConsts.PROFESSION)));
//            taskModel.setSiteName(String.valueOf(task.getFieldByAlias(MppConsts.SITE_NAME) == null ? "" : task.getFieldByAlias(MppConsts.SITE_NAME)));

//行id
//            taskModel.setRowId(task.getID());
//            //行的父级id
//            if (task.getParentTask() != null) {
//                taskModel.setRowParentId(task.getParentTask().getID());
//            }
//            listModel.add(taskModel);
//        }
//        //两种构造层级的关系，选择其中一个就好
//        //根据子父级关系组装层级关系
//        for (ElecPlanTaskModel planTaskModel : listModel) {
//            for (ElecPlanTaskModel parentModel : listModel) {
//                if (planTaskModel.getRowParentId() == parentModel.getRowId()) {
//                  //  planTaskModel.setParentId(parentModel.getPlanTaskId());
//                }
//            }
//        }
//        //根据WBS码构造层级关系
//        // packagePlanTask(listModel);
//        //删除暂存地址的文件，这个可以自己写一个方法，此处就不介绍了
//        FileNameUtils.delete(exportFilePath, false);
//        //返回整个构造好的列表数据
//        resultEntity.setBusinessObject(listModel);
//        resultEntity.setSuccess(true);
//        return resultEntity;
//    }

/**
 * 根据WBS编码构造层级关系
 *
 * @param listModel
 */
//    private void packagePlanTask(List<ElecPlanTaskDO> listModel) {
//        List<ElecPlanTaskDO> parentList = new ArrayList<>();
//        //组装数据，根据WBS 的值确定导入的层级，并分布父子级关系,排序根据层级来设置
//        for (ElecPlanTaskDO planTaskModel : listModel) {
//            String wbs = planTaskModel.getWbs();
//            if (Strings.isEmpty(wbs)) {
//                continue;
//            }
//            String[] wbsList = null;
//            if (Strings.isNotBlank(wbs)) {
//                wbsList = wbs.split("\\.");
//                //levleNum层级：根据“.”分割WBS，分割结果的长度即为目录层级
//                planTaskModel.setLevelNum(wbsList.length);
//            }
//            if (wbsList.length == 1) {
//                //如何确定/匹配父级节点（WBS根据"." 分割，长度为1，即为父级节点）
//                parentList.add(planTaskModel);
//            } else {
//                String lastNum = wbsList[wbsList.length - 1];
//                Integer lastLength = lastNum.length();
//                //1.parentId,否则截取掉wbs最后的".XX"，剩余部分在列表中匹配，匹配到的对象即为父级
//                String subWbs = wbs.substring(0, wbs.length() - (lastLength + 1));
//                for (ElecPlanTaskDO model : listModel) {
//                    if (subWbs.equalsIgnoreCase(model.getWbs())) {
//                        //   planTaskModel.setParentId(model.getPlanTaskId());
//                        break;
//                    }
//                }
//            }
//        }
//    }
}
