package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitesland.tw.tw5.api.prd.my.vo.TwAttendAnceSpecilDate;
import com.elitesland.tw.tw5.server.prd.my.entity.QTAttendanceNormalTimeDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

@Repository
@RequiredArgsConstructor
public class TAttendanceNormalTimeDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final QTAttendanceNormalTimeDO qdo = QTAttendanceNormalTimeDO.tAttendanceNormalTimeDO;

    public TwAttendAnceSpecilDate selectAttendAnceSpectalDate(Long ruleId, Long specilId) {
        return jpaQueryFactory.select(Projections.bean(TwAttendAnceSpecilDate.class,
                        qdo.attendanceTimeStart,
                        qdo.attendanceTimeEnd))
                .from(qdo)
                .where(qdo.attendanceRuleId.eq(ruleId).and(qdo.attendanceNormalDateId.eq(specilId)).and(qdo.attendanceDateWay.eq("YES")))
                .fetchOne();
    }

}
