package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitesland.tw.tw5.server.prd.my.entity.QVacationDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.time.LocalDate;
import java.util.List;

/**
 * @author sunxw
 * @description 假期
 * @Date 2023/5/9
 */
@Repository
@RequiredArgsConstructor
public class VacationDAO {


    private static final QVacationDO qVacationDO = QVacationDO.vacationDO;
    private final JPAQueryFactory jpaQueryFactory;

    public long findWorkDay(LocalDate startDate, LocalDate endDate) {

        long res = jpaQueryFactory.select(qVacationDO.id)
                .from(qVacationDO)
                .where(qVacationDO.naturalDate.between(startDate, endDate))
                .where(qVacationDO.workHours.eq(8F))
                .fetchCount();
        return res;

    }

    public List<LocalDate> findVacationDay(LocalDate startDate, LocalDate endDate) {

        List<LocalDate> res = jpaQueryFactory.select(
                        qVacationDO.naturalDate
                ).distinct()
                .from(qVacationDO)
                .where(qVacationDO.naturalDate.between(startDate, endDate))
                .where(qVacationDO.workHours.eq(0F))
                .where(qVacationDO.deleteFlag.eq(0))
                .fetch();

        return res;
    }

    public List<LocalDate> findVacationDayIn(List<LocalDate> naturalDateList) {

        List<LocalDate> res = jpaQueryFactory.select(
                qVacationDO.naturalDate
            ).distinct()
            .from(qVacationDO)
            .where(qVacationDO.naturalDate.in(naturalDateList))
            .where(qVacationDO.workHours.eq(0F))
            .where(qVacationDO.deleteFlag.eq(0))
            .fetch();

        return res;
    }

    // 获取工作日list
    public List<LocalDate> findWorkLocalDay(LocalDate startDate, LocalDate endDate) {

        List<LocalDate> res = jpaQueryFactory.select(
                        qVacationDO.naturalDate
                ).distinct()
                .from(qVacationDO)
                .where(qVacationDO.naturalDate.between(startDate, endDate))
                .where(qVacationDO.workHours.eq(8F))
                .where(qVacationDO.deleteFlag.eq(0))
                .fetch();

        return res;
    }

    /**
     * 分页查询
     * @param query 查询参数
     * @return
     */
   /* public PagingVO<VacationVO> queryPaging(VacationQuery query) {
        JPAQuery<VacationVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<VacationVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<UserVacationApplyVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<VacationVO> selectByYear(int year){

        JPAQuery<VacationVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }*/


}
