package com.elitesland.tw.tw5.server.prd.my.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author sunxw
 * @description 资源假期申请表
 * @Date 2023/5/8
 */
@Entity
@Table(name = "t_user_vacation_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_user_vacation_apply", comment = "用户假期申请表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class UserVacationApplyDO extends BaseModel {

    /**
     * 4.0主键
     */
    @Comment("4.0主键")
    @Column(name = "apply_id_v4")
    private Long applyIdV4;

    /**
     * 请假单号
     */
    @Comment("请假单号")
    @Column()
    private String applyNo;

    /**
     * 用户id
     */
    @Comment("用户id")
    @Column()
    private Long userId;

    /**
     * 部门id
     */
    @Comment("部门id")
    @Column()
    private Long orgId;

    /**
     * 直属领导
     */
    @Comment("直属领导")
    @Column()
    private Long pUserId;

    /**
     * 假期类型
     */
    @Comment("假期类型")
    @Column()
    private String vacationType;

    /**
     * 请假开始日
     */
    @Comment("请假开始日")
    @Column()
    private LocalDate startDate;
    /**
     * 请假结束日
     */
    @Comment("请假结束日")
    @Column()
    private LocalDate endDate;
    /**
     * 请假天数
     */
    @Comment("请假天数")
    @Column()
    private BigDecimal vacationDays;

    /**
     * 请假事由
     */
    @Comment("请假事由")
    @Column()
    private String reason;

    /**
     * 工作安排
     */
    @Comment("工作安排")
    @Column()
    private String workPlan;

    /**
     * 假期ID
     */
    @Comment("假期ID")
    @Column()
    private Long vacationId;

    /**
     * 补充附件标志
     */
    @Comment("补充附件标志")
    @Column()
    private Byte addFlag;

    /**
     * 补充附件清单
     */
    @Comment("补充附件清单")
    @Column()
    private String addList;

    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String apprStatus;

    /**
     * 申请人资源ID
     */
    @Comment("申请人用户ID")
    @Column()
    private Long apprUserId;

    /**
     * 申请日期
     */
    @Comment("申请日期")
    @Column()
    private LocalDate apprDate;

    /**
     * 是否是系统自动生成，0：否，1：是
     */
    @Comment("是否是系统自动生成，0：否，1：是")
    @Column()
    private Byte autoSaveFlag;

    /**
     * 是否在项目上  0：否，1：是
     */
    @Comment("是否在项目上  0：否，1：是")
    @Column()
    private Byte inProjectFlag;

    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private String projectId;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("附件")
    @Column()
    private String attachmentCodes;

    @Comment("附件说明")
    @Column()
    private String attachmentDesc;

    @Comment("补充附件")
    @Column()
    private String vacationAddAttachCodes;

    @Comment("是否需要延长假期")
    @Column()
    private Byte extVacationFlag;

    @Comment("延长原因")
    @Column()
    private String extVacationReson;

    @Comment("附件(延长假期)")
    @Column()
    private String extVacationAttachCodes;

    @Comment("延长开始时间")
    @Column()
    private LocalDate extVacationStartDate;

    @Comment("延长结束时间")
    @Column()
    private LocalDate extVacationEndDate;

    @ApiModelProperty("延长天数")
    @Column()
    private BigDecimal extVacationDays;

    @Comment("公司id")
    @Column()
    private Long companyId;

    /**
     * 钉钉审批实例业务编号
     */
    @Comment("钉钉审批实例业务编号")
    @Column()
    private String businessId;

    /**
     * 钉钉流程实例id
     */
    @Comment("钉钉流程实例id")
    @Column()
    private String processInstanceId;

    /**
     * 钉钉流程创建时间
     */
    @Comment("钉钉流程创建时间")
    @Column()
    private LocalDateTime dingCreateTime;

}
