package com.elitesland.tw.tw5.server.prd.my.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author sunxw
 * @description
 * @Date 2023/5/8
 */
@Entity
@Table(name = "t_user_vacation_apply_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_user_vacation_apply_detail", comment = "用户假期申请明细表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class UserVacationApplyDetailDO extends BaseModel {

    /**
     * 4.0主键
     */
    @Comment("4.0主键")
    @Column(name = "detail_id_v4")
    private Long detailIdV4;

    /**
     * 请假申请ID
     */
    @Comment("请假申请ID")
    @Column()
    private Long applyId;

    /**
     * 4.0主键
     */
    @Comment("4.0 apply_id")
    @Column(name = "apply_id_v4")
    private Long applyIdV4;

    /**
     * 月份
     */
    @Comment("月份")
    @Column()
    private String vMonth;

    /**
     * 休假日期
     */
    @Comment("休假日期")
    @Column()
    private LocalDate vDate;

    /**
     * 休假天数
     */
    @Comment("休假天数")
    @Column()
    private BigDecimal vDays;

    /**
     * v区间  0.5天区分上午下午 AM上午 PM下午
     */
    @Comment("0.5天区分上午下午 AM上午 PM下午")
    @Column()
    private String vInterval;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("延长假期标志")
    @Column()
    private Boolean extVacationFlag;

    @Comment("奖励假关联的任务id")
    @Column()
    private Long taskId;

    /**
     * 审批实例业务编号
     */
    @Comment("钉钉审批实例业务编号")
    @Column()
    private String businessId;

    /**
     * 钉钉流程实例id
     */
    @Comment("钉钉流程实例id")
    @Column()
    private String processInstanceId;

    /**
     * 钉钉流程创建时间
     */
    @Comment("钉钉流程创建时间")
    @Column()
    private LocalDateTime dingCreateTime;
}
