package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyConfigService;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyDetailService;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyConfigVO;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalRoleResVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.TriggerConditionEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.TsEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.AbnormalWorkApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.AbnormalWorkApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.AbnormalWorkApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.AbnormalWorkApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.AbnormalWorkApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.AbnormalWorkApplyRepo;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;

/**
 * 远程办公申请
 *
 * @author carl
 * @date 2024-04-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AbnormalWorkApplyServiceImpl extends BaseServiceImpl implements AbnormalWorkApplyService {

    private final AbnormalWorkApplyRepo abnormalWorkApplyRepo;
    private final AbnormalWorkApplyDAO abnormalWorkApplyDAO;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final TransactionUtilService transactionUtilService;
    private final AbnormalWorkApplyDetailService abnormalWorkApplyDetailService;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final AbnormalWorkApplyConfigService abnormalWorkApplyConfigService;
    //ProcDefKey.RES_VACATION.name(),
    @Override
    public PagingVO<AbnormalWorkApplyVO> queryPaging(AbnormalWorkApplyQuery query) {
        return abnormalWorkApplyDAO.queryPaging(query);
    }

    @Override
    public List<AbnormalWorkApplyVO> queryListDynamic(AbnormalWorkApplyQuery query) {
        return abnormalWorkApplyDAO.queryListDynamic(query);
    }

    @Override
    public AbnormalWorkApplyVO queryByKey(Long key) {
        AbnormalWorkApplyDO entity = abnormalWorkApplyRepo.findById(key).orElseGet(AbnormalWorkApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AbnormalWorkApplyVO vo = AbnormalWorkApplyConvert.INSTANCE.toVo(entity);
        AbnormalWorkApplyDetailQuery abnormalWorkApplyDetailQuery = new AbnormalWorkApplyDetailQuery();
        abnormalWorkApplyDetailQuery.setApplyId(vo.getId());
        List<AbnormalWorkApplyDetailVO> abnormalWorkApplyDetailVOS = abnormalWorkApplyDetailService.queryListDynamic(abnormalWorkApplyDetailQuery);
        vo.setAbnormalWorkApplyDetailVOList(abnormalWorkApplyDetailVOS);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AbnormalWorkApplyVO insertOrUpdate(AbnormalWorkApplyPayload payload) {
        String procInstId = null;
        if (payload.getId() != null) {
            AbnormalWorkApplyDO entity = abnormalWorkApplyRepo.findById(payload.getId()).orElseGet(AbnormalWorkApplyDO::new);
            if (entity.getId() == null) {
                throw TwException.error("", "变更数据不存在");
            }
            procInstId = entity.getProcInstId();
        } else {
            payload.setApplyDate(LocalDate.now());
        }
        AbnormalWorkApplyDO entityDo = AbnormalWorkApplyConvert.INSTANCE.toDo(payload);
        AbnormalWorkApplyDO save = abnormalWorkApplyRepo.save(entityDo);
        payload.setId(save.getId());
        payload.setProcInstId(procInstId);

        // 处理明细数据
        dealDetailData(payload);
        if (payload.getSubmitFlag()) {
            if(!StringUtils.hasText(procInstId)){
                //发起流程
                startProcess(payload);
            }else{
                // 重新给流程参数赋值
                HashMap<String, Object> variables = new HashMap<>();
                dealVariables(payload,variables);
                workflowUtil.setVariables(SetVariablesPayload.of(payload.getProcInstId(), variables));
            }
        }

        return AbnormalWorkApplyConvert.INSTANCE.toVo(save);
    }

    private void dealDetailData(AbnormalWorkApplyPayload payload) {
        // 先更新要删除的数据
        if(!CollectionUtils.isEmpty(payload.getDeleteDetailKeys())){
            abnormalWorkApplyDetailService.deleteSoft(payload.getDeleteDetailKeys());
        }
        // 处理新增和更新的数据
        if(!CollectionUtils.isEmpty(payload.getAbnormalWorkApplyDetailPayloadList())){
            payload.getAbnormalWorkApplyDetailPayloadList().stream().forEach(p->{
                if(p.getId()!=null){
                    abnormalWorkApplyDetailService.update(p);
                }else{
                    p.setApplyId(payload.getId());
                    abnormalWorkApplyDetailService.insert(p);
                }
            });
        }
    }

    /**
     * 提交流程
     *
     * @param payload
     */
    void startProcess(AbnormalWorkApplyPayload payload) {
        HashMap<String, Object> variables = new HashMap<>();
        // 处理对应的审批参数
        dealVariables(payload,variables);

        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = cacheUtil.getUserDefaultOrg(payload.getApplyUserId());

        String procInstName = "A37." + ProcDefKey.ABNORMAL_WORK.getDesc() + "-" + prdOrgEmployeeRefVO.getEmployeeName() + "-" + payload.getApplyDate();
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.ABNORMAL_WORK.name(),
                procInstName,
                payload.getId() + "",
                variables)
        );
        AbnormalWorkApplyPayload payload0 = new AbnormalWorkApplyPayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus().name());
        payload0.setParentUserId(prdOrgEmployeeRefVO.getParentId());
        transactionUtilService.executeWithRunnable(() -> {
            abnormalWorkApplyDAO.updateByKeyDynamic(payload0);
        });
    }

    // 获取审批人数据
    public TsApprovalRoleResVO getApprovePersonData(String reasonType,Long reasonId,Long applyUserId){
        TsApprovalRoleResVO roleResVO = new TsApprovalRoleResVO();
        //获取组织角色人员
        PrdOrgEmployeeRefVO userDefaultOrg = cacheUtil.getUserDefaultOrg(applyUserId);

        // 直属上级
        roleResVO.setApprovalResId13(userDefaultOrg.getParentId());
        // BU负责人
        Long orgId = cacheUtil.getDefaultOrgIdByUserId(applyUserId);
        PrdOrgOrganizationVO buOrg = cacheUtil.getOrg(orgId);
        if(buOrg == null || buOrg.getManageId() == null){
            throw TwException.error("","申请人的BU负责人未维护，请联系管理员");
        }
        roleResVO.setApprovalResId14(buOrg.getManageId());
        // 事业部负责人
        PrdOrgOrganizationRefVO buLevel1ByOrgId = cacheUtil.getBULevel1ByOrgId(orgId);
        if(buLevel1ByOrgId == null || buLevel1ByOrgId.getManageId() == null){
            throw TwException.error("","申请人的事业部负责人未维护，请联系管理员");
        }
        roleResVO.setApprovalResId15(buLevel1ByOrgId.getManageId());

        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            //合同项目任务包
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(reasonId);
            if (pmsProjectVO == null) {
                throw TwException.error("", "所选项目不存在");
            }
            //初始化数据
            roleResVO.setApprovalResId1(pmsProjectVO.getPmResId());//项目经理
            roleResVO.setApprovalResId2(pmsProjectVO.getDeliUserId());//交付负责人
            PrdOrgOrganizationVO org = cacheUtil.getOrg(pmsProjectVO.getDeliBuId());//交付BU
            roleResVO.setApprovalResId3(org.getManageId());//交付BU Leader
            PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(pmsProjectVO.getDeliBuId());
            if (buLevel1 != null) {
                roleResVO.setApprovalResId4(buLevel1.getManageId());//交付BU 事业部Leader
            }
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery crmOpportunityQuery = new CrmOpportunityQuery();
            crmOpportunityQuery.setProjectId(reasonId);
            List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(crmOpportunityQuery);
            if (ObjectUtils.isEmpty(crmOpportunityListVOS)) {
                throw TwException.error("", "项目不存在，请核验！");
            }
            CrmOpportunityListVO crmOpportunityListVO = crmOpportunityListVOS.get(0);

            //初始化数据
            roleResVO.setApprovalResId2(crmOpportunityListVO.getDeliUserId());//交付负责人
            roleResVO.setApprovalResId7(crmOpportunityListVO.getManageUserId());//签单负责人
            roleResVO.setApprovalResId8(crmOpportunityListVO.getPreSaleUserId());//售前负责人

            PrdOrgOrganizationVO org0 = cacheUtil.getOrg(crmOpportunityListVO.getOrgId());//签单BU
            if (org0 != null) {
                roleResVO.setApprovalResId9(org0.getManageId());//签单BU Leader
                PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getOrgId());
                if (buLevel1 != null) {
                    roleResVO.setApprovalResId11(buLevel1.getManageId());//签单BU 事业部Leader
                }
            }
            PrdOrgOrganizationVO org1 = cacheUtil.getOrg(crmOpportunityListVO.getDeliOrgId());//交付BU
            if (org1 != null) {
                roleResVO.setApprovalResId3(org1.getManageId());//交付BU Leader
                PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getDeliOrgId());
                if (buLevel1 != null) {
                    roleResVO.setApprovalResId4(buLevel1.getManageId());//交付BU 事业部Leader
                }
            }
            PrdOrgOrganizationVO org2 = cacheUtil.getOrg(crmOpportunityListVO.getPreSaleOrgId());//售前BU
            if (org2 != null) {
                roleResVO.setApprovalResId10(org2.getManageId());//售前BU Leader
                PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getPreSaleOrgId());
                if (buLevel1 != null) {
                    roleResVO.setApprovalResId12(buLevel1.getManageId());//售前BU 事业部Leader
                }
            }

        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = buProjectService.queryByKey(reasonId);
            if (ObjectUtils.isEmpty(buProjectVO)) {
                throw TwException.error("", "所选BU项目不存在");
            }
            roleResVO.setApprovalResId1(buProjectVO.getPmResId());//项目经理
            roleResVO.setApprovalResId2(buProjectVO.getDeliUserId());//交付负责人
            PrdOrgOrganizationVO org = cacheUtil.getOrg(buProjectVO.getDeliBuId());//
            roleResVO.setApprovalResId3(org.getManageId());//交付BU Leader
            PrdOrgOrganizationRefVO buLevel1 = cacheUtil.getBULevel1ByOrgId(buProjectVO.getDeliBuId());
            if (buLevel1 != null) {
                roleResVO.setApprovalResId4(buLevel1.getManageId());//交付BU 事业部Leader
            }
        }

        return roleResVO;
    }

    // 获取审批配置
    private AbnormalWorkApplyConfigVO getAbnormalWorkApplyConfig(AbnormalWorkApplyPayload payload){
        AbnormalWorkApplyConfigQuery query = new AbnormalWorkApplyConfigQuery();
        query.setReasonType(payload.getReasonType());
        List<AbnormalWorkApplyConfigVO> abnormalWorkApplyConfigVOS = abnormalWorkApplyConfigService.queryListDynamic(query);
        if(CollectionUtils.isEmpty(abnormalWorkApplyConfigVOS)){
            throw TwException.error("", "事由类型为"+payload.getReasonType()+"审批配置不能为空");
        }
        for(AbnormalWorkApplyConfigVO abnormalWorkApplyConfigVO:abnormalWorkApplyConfigVOS){
            // 如果当前是大于并且当前天数大于条件天数
            if(TriggerConditionEnum.gt.getCode().equals(abnormalWorkApplyConfigVO.getTriggerCondition()) && payload.getDays().compareTo(abnormalWorkApplyConfigVO.getConditionDays())>0){
                return abnormalWorkApplyConfigVO;
            }
            if(TriggerConditionEnum.ltoe.getCode().equals(abnormalWorkApplyConfigVO.getTriggerCondition()) && payload.getDays().compareTo(abnormalWorkApplyConfigVO.getConditionDays())<=0){
                return abnormalWorkApplyConfigVO;
            }
        }
        return null;
    }

    // 处理审批参数
    private void dealVariables(AbnormalWorkApplyPayload payload,HashMap<String, Object> variables){

        // 获取审批人数据
        TsApprovalRoleResVO tsApprovalRoleResVO = getApprovePersonData(payload.getReasonType(), payload.getReasonId(), payload.getApplyUserId());
        // 获取对应的配置
        AbnormalWorkApplyConfigVO abnormalWorkApplyConfig = getAbnormalWorkApplyConfig(payload);
        if(abnormalWorkApplyConfig==null){
            throw TwException.error("", "事由类型为"+payload.getReasonType()+"审批配置不能为空");
        }
        // 审批人1
        Long approalRes1 = initApproalRes(tsApprovalRoleResVO,abnormalWorkApplyConfig.getFirstApprovePerson());
        variables.put("Activity_0azqyzb",approalRes1);
        // 审批人2
        Long approalRes2 = initApproalRes(tsApprovalRoleResVO,abnormalWorkApplyConfig.getTwiceApprovePerson());
        variables.put("Activity_0qqprdg",approalRes2);
        // 审批人3
        Long approalRes3 =  initApproalRes(tsApprovalRoleResVO,abnormalWorkApplyConfig.getThirdApprovePerson());
        variables.put("Activity_05v4uu0",approalRes3);
        // 审批人4
        Long approalRes4 = initApproalRes(tsApprovalRoleResVO, abnormalWorkApplyConfig.getFourthApprovePerson());
        variables.put("Activity_0gcfltl",approalRes4);
    }

    /**
     * 根据角色获取审批人
     *
     * @param roleResVO
     * @param approvalSource
     */

//   n
    Long initApproalRes(TsApprovalRoleResVO roleResVO, String approvalSource) {
        TsEnum.TsBussinessRole tsBussinessRole = TsEnum.TsBussinessRole.valueOf(approvalSource);
        Long approvalResId = null;
        switch (tsBussinessRole) {
            case business_role1:
                approvalResId = roleResVO.getApprovalResId1();
                break;
            case business_role2:
                approvalResId = roleResVO.getApprovalResId2();
                break;
            case business_role3:
                approvalResId = roleResVO.getApprovalResId3();
                break;
            case business_role4:
                approvalResId = roleResVO.getApprovalResId4();
                break;
            case business_role5:
                approvalResId = roleResVO.getApprovalResId5();
                break;
            case business_role6:
                approvalResId = roleResVO.getApprovalResId6();
                break;
            case business_role7:
                approvalResId = roleResVO.getApprovalResId7();
                break;
            case business_role8:
                approvalResId = roleResVO.getApprovalResId8();
                break;
            case business_role9:
                approvalResId = roleResVO.getApprovalResId9();
                break;
            case business_role10:
                approvalResId = roleResVO.getApprovalResId10();
                break;
            case business_role11:
                approvalResId = roleResVO.getApprovalResId11();
                break;
            case business_role12:
                approvalResId = roleResVO.getApprovalResId12();
                break;
            case business_role13:
                approvalResId = roleResVO.getApprovalResId13();
                break;
            case business_role14:
                approvalResId = roleResVO.getApprovalResId14();
                break;
            case business_role15:
                approvalResId = roleResVO.getApprovalResId15();
                break;
        }
        return approvalResId;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AbnormalWorkApplyVO update(AbnormalWorkApplyPayload payload) {
        AbnormalWorkApplyDO entity = abnormalWorkApplyRepo.findById(payload.getId()).orElseGet(AbnormalWorkApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AbnormalWorkApplyDO entityDo = AbnormalWorkApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AbnormalWorkApplyConvert.INSTANCE.toVo(abnormalWorkApplyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AbnormalWorkApplyPayload payload) {
        AbnormalWorkApplyDO entity = abnormalWorkApplyRepo.findById(payload.getId()).orElseGet(AbnormalWorkApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = abnormalWorkApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            abnormalWorkApplyDAO.deleteSoft(keys);
        }
    }

    @Override
    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        Long applyId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        AbnormalWorkApplyPayload payload0 = new AbnormalWorkApplyPayload();
        payload0.setId(applyId);
        payload0.setProcInstStatus(procInstStatus.name());
        //以下代码可注释掉
//        switch (procInstStatus) {
//            case NOTSUBMIT://创建人提交节点
//                payload0.setProcInstStatus(procInstStatus.NOTSUBMIT.name());
//                break;
//            case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
//                payload0.setProcInstStatus(procInstStatus.INTERRUPT.name());
//                break;
//            case INVALID://仅删除流程
//                payload0.setProcInstStatus(procInstStatus.INVALID.name());
//                break;
//            case REJECTED://审批人拒绝，回到第一个节点
//                payload0.setProcInstStatus(procInstStatus.NOTSUBMIT.name());
//                break;
//            case APPROVED:
//                payload0.setProcInstStatus(procInstStatus.APPROVED.name());
//
//                break;
//            case APPROVING:
//                payload0.setProcInstStatus(procInstStatus.APPROVING.name());
//                break;
//        }
        abnormalWorkApplyDAO.updateByKeyDynamic(payload0);
    }

}
