package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanTempListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanTempPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetPlanTempService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetPlanTempVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.TwAssert;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetPlanTempConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetPlanTempDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanTempRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * 工作计划模板
 *
 * @author duwh
 * @date 2022-12-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsTimesheetPlanTempServiceImpl implements PmsTimesheetPlanTempService {

    private final TimesheetPlanTempRepo timesheetPlanTempRepo;
    private final PmsProjectService pmsProjectService;
    private final TaskPackageService taskPackageService;
    private final TaskInfoService taskInfoService;
    private final PmsProjectActivityService pmsProjectActivityService;


    @Override
    public PagingVO<TimesheetPlanTempVO> paging(TimesheetPlanTempQuery query) {
        Page<TimesheetPlanTempDO> page = timesheetPlanTempRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetPlanTempConvert.INSTANCE::toVo));
    }

    @Override
    public List<TimesheetPlanTempVO> queryList(TimesheetPlanTempQuery query) {
        return TimesheetPlanTempConvert.INSTANCE.toVoList(timesheetPlanTempRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public long count(TimesheetPlanTempQuery query) {
        return timesheetPlanTempRepo.count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    @Override
    public TimesheetPlanTempVO queryByKey(Long key) {
        TimesheetPlanTempDO entity = timesheetPlanTempRepo.findById(key).orElseGet(TimesheetPlanTempDO::new);
        TwAssert.notNull(entity.getId(), "不存在");
        TimesheetPlanTempVO vo = TimesheetPlanTempConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetPlanTempVO insert(TimesheetPlanTempPayload payload) {
        // 参数校验
        check(payload);
        // 冗余数据处理
        initData(payload);

        TimesheetPlanTempDO entityDo = TimesheetPlanTempConvert.INSTANCE.toDo(payload);
        return TimesheetPlanTempConvert.INSTANCE.toVo(timesheetPlanTempRepo.save(entityDo));
    }

    private void check(TimesheetPlanTempPayload payload) {
        // final Long loginUserId = GlobalUtil.getLoginUserId();
        // if (null == payload.getProjId()) {
        //     throw TwException.error("", "参数异常：projId");
        // }
        // if (null == payload.getTaskId()) {
        //     throw TwException.error("", "参数异常：taskId");
        // }
        if (!StringUtils.hasText(payload.getType())) {
            throw TwException.error("", "参数异常：type");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<TimesheetPlanTempVO> batchInsert(TimesheetPlanTempListPayload payload) {
        final List<TimesheetPlanTempPayload> timesheetPlanTempList = payload.getTimesheetPlanTempList();
        List<TimesheetPlanTempVO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(timesheetPlanTempList)) {
            timesheetPlanTempList.forEach(timesheetPlanTempPayload -> {
                list.add(insert(timesheetPlanTempPayload));
            });
        }
        return list;
    }

    private void initData(TimesheetPlanTempPayload payload) {
        if (null != payload.getProjId()) {
            final PmsProjectVO projectVO = pmsProjectService.queryByKeySimple(payload.getProjId());
            if (!StringUtils.hasText(payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText(payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        // 任务包冗余
        if (payload.getTaskPackageId() != null) {
            final TaskPackageVO taskPackageVO = taskPackageService.queryByKey(payload.getTaskPackageId(), false);
            if (!StringUtils.hasText(payload.getTaskPackageNo())) {
                payload.setTaskPackageNo(null != taskPackageVO ? taskPackageVO.getTaskPackageNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskPackageName())) {
                payload.setTaskPackageName(null != taskPackageVO ? taskPackageVO.getTaskPackageName() : "");
            }
            if (ObjectUtils.isEmpty(payload.getReasonId())) {
                payload.setReasonId(null != taskPackageVO ? taskPackageVO.getReasonId() : null);
            }
            if (!StringUtils.hasText(payload.getReasonType())) {
                payload.setReasonType(null != taskPackageVO ? taskPackageVO.getReasonType() : "");
            }
            if (!StringUtils.hasText(payload.getReasonName())) {
                payload.setReasonName(null != taskPackageVO ? taskPackageVO.getReasonName() : "");
            }
        }

        if (null != payload.getTaskId()) {
            final TaskInfoVO taskVO = taskInfoService.queryByKey(payload.getTaskId(), false);
            if (!StringUtils.hasText(payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqvaQty()) {
                payload.setEqvaQty(null != taskVO ? taskVO.getValidEqva() : null);
            }
        }
        // if (null != payload.getActId()) {
        //     final PmsProjectActivityVO resActivityVO = pmsProjectActivityService.queryByKey(payload.getActId());
        //     if (!StringUtils.hasText(payload.getActNo())) {
        //         payload.setActNo(null != resActivityVO ? resActivityVO.getActNo() : "");
        //     }
        //     if (!StringUtils.hasText(payload.getActName())) {
        //         payload.setActName(null != resActivityVO ? resActivityVO.getActName() : "");
        //     }
        // }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetPlanTempVO update(TimesheetPlanTempPayload payload) {
        TimesheetPlanTempDO entity = timesheetPlanTempRepo.findById(payload.getId()).orElseGet(TimesheetPlanTempDO::new);
        TwAssert.notNull(entity.getId(), "不存在");
        initData(payload);
        TimesheetPlanTempDO entityDo = TimesheetPlanTempConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetPlanTempConvert.INSTANCE.toVo(timesheetPlanTempRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            timesheetPlanTempRepo.deleteSoft(keys);
        }
    }

    @Override
    public void download(List<TimesheetPlanTempVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (TimesheetPlanTempVO timesheetPlanTemp : all) {
            Map<String, Object> map = new LinkedHashMap<>();
            map.put("任务id", timesheetPlanTemp.getTaskId());
            map.put("工作计划主键", timesheetPlanTemp.getPlanId());
            map.put("状态", timesheetPlanTemp.getStatus());
            map.put("拓展1", timesheetPlanTemp.getExt1());
            map.put("拓展2", timesheetPlanTemp.getExt2());
            map.put("拓展3", timesheetPlanTemp.getExt3());
            map.put("拓展4", timesheetPlanTemp.getExt4());
            map.put("拓展5", timesheetPlanTemp.getExt5());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }
}
