package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanPayload;
import com.elitesland.tw.tw5.api.prd.my.query.*;
import com.elitesland.tw.tw5.api.prd.my.service.*;
import com.elitesland.tw.tw5.api.prd.my.vo.*;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.repo.TransferUtilRepo;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.ProjectEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetPlanConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetPlanDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetPlanDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工时-工作计划
 *
 * @author duwh
 * @date 2022-12-09
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TimesheetPlanServiceImpl implements TimesheetPlanService {

    private final TimesheetPlanRepo timesheetPlanRepo;
    private final ProjectService projectService;
    private final TaskService taskService;
    private final ResActivityService resActivityService;
    private final JPAQueryFactory jpaQueryFactory;
    private final CacheUtil cacheUtil;
    private final TimesheetBiweeklyRepo timesheetBiweeklyRepo;
    private final ProjShService projShService;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;
    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final TransferUtilRepo transferUtilRepo;

//    @Value("${tw4.url}")
//    private String tw4_url;
//
//    @Value("${tw4.workPlan.url:api/openReport/v1/resWorkPlan/syncWorkPlanFrom5To4}")
//    private String workPlanUrl;

    @Override
    public PagingVO<TimesheetPlanVO> paging(TimesheetPlanQuery query) {
        Page<TimesheetPlanDO> page = timesheetPlanRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetPlanConvert.INSTANCE::toVo));
    }

    @Override
    public List<TimesheetPlanVO> queryList(TimesheetPlanQuery query) {
        return TimesheetPlanConvert.INSTANCE.toVoList(timesheetPlanRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    private List<TimesheetPlanDO> queryDoList(TimesheetPlanQuery query) {
        return timesheetPlanRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    @Override
    public TimesheetPlanVO queryByKey(Long key) {
        TimesheetPlanDO entity = timesheetPlanRepo.findById(key).orElseGet(TimesheetPlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TimesheetPlanVO vo = TimesheetPlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetPlanVO insert(TimesheetPlanPayload payload) {
        // 设置填写人为当前登录人
        payload.setTsUserId(GlobalUtil.getLoginUserId());
        // 参数校验
        check(payload);
        // 数据处理
        dataProcess(payload);
        // 更新本周及上周周报读取状态
        LocalDate workDate = payload.getWorkDate();
        int yearWeek = Integer.parseInt(DateUtil.getYearWeek(workDate));
        int lastYearWeek = Integer.parseInt(DateUtil.getYearWeek(workDate.minusWeeks(1)));
        biweeklyReadFlagRepo.updateReadFlag(payload.getTsUserId(),0);
//        biweeklyReadFlagRepo.updateReadFlag(lastYearWeek,payload.getTsUserId(),0);
        TimesheetPlanDO entityDo = TimesheetPlanConvert.INSTANCE.toDo(payload);
        return TimesheetPlanConvert.INSTANCE.toVo(timesheetPlanRepo.save(entityDo));
    }

    /**
     * 参数校验
     *
     * @param payload 有效载荷
     */
    private void check(TimesheetPlanPayload payload) {
//        final int yearWeek = Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate()));
//        final int lastyearWeek = Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate().minusWeeks(1)));
//        // 校验已提交周报的 不允许再编辑新增
//        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
//        timesheetBiweeklyQuery.setYearWeekIn(Arrays.asList(yearWeek,lastyearWeek));
//        timesheetBiweeklyQuery.setTsUserId(GlobalUtil.getLoginUserId());
//        final Long count = timesheetBiweeklyRepo
//                .count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
//        if (count > 0) {
//            throw TwException.error("", "审批中的数据不可以操作");
//        }
        // 前一天的计划不允许提交
        LocalDate workDate = payload.getWorkDate();
        if(workDate.isBefore(LocalDate.now()) && !workDate.isEqual(LocalDate.now()) && (payload.getExt5()==null || !payload.getExt5().equals("EMPTY"))){
            throw TwException.error("", "只允许提交今天及以后的计划！");
        }
        if (null == payload.getProjId()) {
            throw TwException.error("", "参数异常：projId");
        }
        if (null == payload.getTaskId()) {
            throw TwException.error("", "参数异常：taskId");
        }
    }

    /**
     * 数据处理
     *
     * @param payload 有效载荷
     */
    private void dataProcess(TimesheetPlanPayload payload) {
        if (payload.getWorkDate() != null) {
            // 设置当前年周
            payload.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate())));
            payload.setWeekStartDate(DateUtil.getStartWeekDay(payload.getWorkDate()));
        }
        //if (null == payload.getEqva()) {
        //    payload.setEqva(BigDecimal.ZERO);
        //}
        if (null != payload.getProjId()) {
            final ProjectVO projectVO = projectService.queryByProjIdV4(payload.getProjId());
            if (!StringUtils.hasText(payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText(payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }

        if (null != payload.getTaskId()) {
            final TaskVO taskVO = taskService.queryByTaskIdV4(payload.getTaskId());
            if (!StringUtils.hasText(payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getEqvaQty() : BigDecimal.ZERO);
            }
        }
        if (null != payload.getActId()) {
            final ResActivityVO resActivityVO = resActivityService.queryByActivityIdV4(payload.getActId());
            if (!StringUtils.hasText(payload.getActNo())) {
                payload.setActNo(null != resActivityVO ? resActivityVO.getActNo() : "");
            }
            if (!StringUtils.hasText(payload.getActName())) {
                payload.setActName(null != resActivityVO ? resActivityVO.getActName() : "");
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetPlanVO update(TimesheetPlanPayload payload) {
        TimesheetPlanDO entity = timesheetPlanRepo.findById(payload.getId()).orElseGet(TimesheetPlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 数据处理
        dataProcess(payload);
        TimesheetPlanDO entityDo = TimesheetPlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetPlanConvert.INSTANCE.toVo(timesheetPlanRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetPlanDO> optional = timesheetPlanRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetPlanDO entity = optional.get();
                    //#6849 审批中（任务包状态为派发中）不可以删除数据，必须要在4.0中【我提交的流程中】进行撤回，删除以后才可以在5.0中删除
                    //退回后（任务包状态为新建）可以删除
                    //审批通过（任务包状态为激活）可以删除
                    final String taskApplyStatus = entity.getTaskApplyStatus();
                    if (StringUtils.hasText(taskApplyStatus) && taskApplyStatus.equals(TaskStatusEnum.DISPATCH.getCode())) {
                        throw TwException.error("", "审批中不可以删除数据，必须要在4.0中【我提交的流程中】进行撤回，删除以后才可以在5.0中删除");
                    }

                    // 校验已提交周报的 不允许再编辑新增
                    TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
                    timesheetBiweeklyQuery.setYearWeek(entity.getYearWeek());
                    timesheetBiweeklyQuery.setTsUserId(entity.getTsUserId());
                    final Long count = timesheetBiweeklyRepo
                            .count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
                    if (count > 0) {
                        throw TwException.error("", "审批中的数据不可以删除");
                    }
                }
            });
            timesheetPlanRepo.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByYearWeek(Integer yeerWeek, Long loginUserId) {
        if (null != yeerWeek) {
            LocalDateTime now = LocalDateTime.now();
            QTimesheetPlanDO qTimesheetPlanDO = QTimesheetPlanDO.timesheetPlanDO;
            JPAUpdateClause update = jpaQueryFactory.update(qTimesheetPlanDO)
                    .set(qTimesheetPlanDO.deleteFlag, 1)
                    .set(qTimesheetPlanDO.updater, GlobalUtil.getLoginUserName())
                    .set(qTimesheetPlanDO.modifyTime, now)
                    .where(qTimesheetPlanDO.yearWeek.eq(yeerWeek))
                    .where(qTimesheetPlanDO.tsUserId.eq(loginUserId));
            update.execute();
        }
    }

    /**
     * 项目和任务列表
     *
     * @param keyword 关键字
     * @param type
     * @param test
     * @return {@link List}<{@link ProjectAndTaskVO}>
     */
    @Override
    public List<ProjectAndTaskVO> listProjAndTask(String keyword, String type, boolean test) {
        List<ProjectAndTaskVO> list = new ArrayList<>();
        ProjectQuery projectQuery = new ProjectQuery();
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setEffectiveEqva(new BigDecimal("0.05"));
        ProjectQuery projectOperQuery = new ProjectQuery();
        if (StringUtils.hasText(keyword)) {
            projectQuery.setKeyword(keyword);
            taskQuery.setKeyword(keyword);
            projectOperQuery.setKeyword(keyword);
        }

        // 任务包数据
        // 任务包筛选条件
        //taskQuery.setTaskStatus(TaskStatusEnum.ACTIVE.getCode());
        List<String> taskStatusList = new ArrayList<>();
        taskStatusList.add(TaskStatusEnum.ACTIVE.getCode());
        taskStatusList.add(TaskStatusEnum.DISPATCH.getCode());
        taskQuery.setTaskStatusList(taskStatusList);
        final Long loginUserId = GlobalUtil.getLoginUserId();
        if (!test) {
            //  只查询接包人是自己的，待数据同步好
            taskQuery.setReceiverUserId(loginUserId);
        }
        if (!StringUtils.hasText(type) || (StringUtils.hasText(type) && type.equals("TASK"))) {
            final List<ProjectAndTaskVO> taskList = taskService.queryListForSelect(taskQuery);
            if (!CollectionUtils.isEmpty(taskList)) {
                ResActivityQuery resActivityQuery = new ResActivityQuery();
                // 查出来所有的活动
                final List<ResActivityVO> activityVOList = resActivityService.queryList(resActivityQuery);
                taskList.forEach(projectAndTaskVO -> {
                    final List<ResActivityVO> resActivityVOList = activityVOList.stream()
                            .filter(resActivityVO -> resActivityVO.getTaskId().equals(projectAndTaskVO.getTaskIdV4()))
                            .collect(Collectors.toList());
                    //ResActivityQuery resActivityQuery = new ResActivityQuery();
                    //resActivityQuery.setTaskId(projectAndTaskVO.getTaskIdV4());
                    //final List<ResActivityVO> resActivityVOS = resActivityService.queryList(resActivityQuery);
                    projectAndTaskVO.setActivityList(resActivityVOList);
                });
            }
            list.addAll(taskList);
        }

        // 经营类项目  ext1 OPER   ext2为交付BU 组织id ：数据权限
        // 查当前登录人的组织id
        final Long defaultOrgIdByUserId = cacheUtil.getDefaultOrgIdByUserId(loginUserId);

        projectOperQuery.setExt2(defaultOrgIdByUserId + "");
        projectOperQuery.setExt1(ProjectEnum.OPER.getCode());
        final List<ProjectAndTaskVO> projectOperList = projectService.queryListForSelect(projectOperQuery);
        list.addAll(projectOperList);

        // 项目数据
        // 项目筛选条件
        // 产品（大陆、郭莹）需求 可以拉取所有项目数据
        projectQuery.setProjStatus("ACTIVE");
        projectQuery.setProjIdV4NotEqual(0L);
        //projectQuery.setExt1NotEqual(ProjectEnum.OPER.getCode());
        if (!StringUtils.hasText(type) || (StringUtils.hasText(type) && type.equals("PROJ"))) {
            // 考虑项目成员
            // 查询非经营类、非无项目 所有项目
            final List<ProjectAndTaskVO> projectList = projectService.queryListForSelect(projectQuery);
            if (!CollectionUtils.isEmpty(projectList)) {
                ProjShQuery projShQuery = new ProjShQuery();
                projShQuery.setUserId(loginUserId);
                final List<ProjShVO> projShVOS = projShService.queryList(projShQuery);
                if (!CollectionUtils.isEmpty(projShVOS)) {
                    Set<Long> projIdList = projShVOS.stream()
                            .map(projShVO -> projShVO.getProjId())
                            .collect(Collectors.toSet());
                    final List<ProjectAndTaskVO> projectNoOperList = projectList.stream()
                            .filter(projectAndTaskVO ->
                                    {
                                        final boolean flag = !(StringUtils.hasText(projectAndTaskVO.getExt1()) && projectAndTaskVO.getExt1().equals("OPER"));
                                        if (flag) {
                                            if (projIdList.contains(projectAndTaskVO.getProjIdV4())) {
                                                projectAndTaskVO.setMyProject(true);
                                            }
                                        }
                                        return flag;
                                    }
                            )
                            .collect(Collectors.toList());
                    list.addAll(projectNoOperList);
                } else {
                    final List<ProjectAndTaskVO> projectNoOperList = projectList.stream().filter(projectAndTaskVO -> !(StringUtils.hasText(projectAndTaskVO.getExt1()) && projectAndTaskVO.getExt1().equals("OPER")))
                            .collect(Collectors.toList());
                    list.addAll(projectNoOperList);
                }
            }
        }
        return list;
    }

    @Override
    public List<TimesheetPlanVO> batchInsert(TimesheetPlanListPayload payload) {
        List<TimesheetPlanVO> list = new ArrayList<>();
        final List<TimesheetPlanPayload> timesheetPlanList = payload.getTimesheetPlanList();
        if (!CollectionUtils.isEmpty(timesheetPlanList)) {
            timesheetPlanList.forEach(timesheetPlanPayload ->
                    list.add(insert(timesheetPlanPayload)));
        }
        return list;
    }

    /**
     * 复制上周计划
     *
     * @param date 日期
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<TimesheetPlanVO> copyLastWeek(String date) {
        LocalDate localDate = LocalDate.now();
        if (StringUtils.hasText(date)) {
            localDate = LocalDate.parse(date);
        }
        // 上周日期
        final LocalDate lastWeekDate = localDate.plusDays(-7);
        final int yearWeek = Integer.parseInt(DateUtil.getYearWeek(localDate));
        // 上周周数
        final String lastYearWeek = DateUtil.getYearWeek(lastWeekDate);
        // 查出上周的数据 遍历插入本周
        TimesheetPlanQuery timesheetPlanQuery = new TimesheetPlanQuery();
        timesheetPlanQuery.setYearWeek(Integer.parseInt(lastYearWeek));
        final Long loginUserId = GlobalUtil.getLoginUserId();
        timesheetPlanQuery.setTsUserId(loginUserId);
        final List<TimesheetPlanDO> timesheetPlanDOS = queryDoList(timesheetPlanQuery);

        // 清空之前 校验是否提交周报
        // 校验已提交周报的 不允许再编辑新增
        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
        timesheetBiweeklyQuery.setYearWeek(yearWeek);
        timesheetBiweeklyQuery.setTsUserId(loginUserId);
        final Long count = timesheetBiweeklyRepo
                .count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
        if (count > 0) {
            throw TwException.error("", "工作计划提交后不可修改");
        }
        // 先清空本周
        deleteSoftByYearWeek(yearWeek, loginUserId);
        List<TimesheetPlanVO> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(timesheetPlanDOS)) {
            timesheetPlanDOS.forEach(timesheetPlanDO -> {
                TimesheetPlanDO entity = new TimesheetPlanDO();
                BeanUtil.copyProperties(timesheetPlanDO, entity);
                entity.setId(null);
                entity.setCreateTime(LocalDateTime.now());
                entity.setCreator(GlobalUtil.getLoginUserName());
                entity.setCreateUserId(loginUserId);
                entity.setModifyTime(LocalDateTime.now());
                entity.setModifyUserId(loginUserId);
                entity.setUpdater(GlobalUtil.getLoginUserName());
                final LocalDate workDate = timesheetPlanDO.getWorkDate();
                if (null != workDate) {
                    final LocalDate nextWeekWorkDate = workDate.plusDays(7);
                    entity.setWorkDate(nextWeekWorkDate);
                    // 设置当前年周
                    entity.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(nextWeekWorkDate)));
                    entity.setWeekStartDate(DateUtil.getStartWeekDay(nextWeekWorkDate));
                    entity.setExt1("复制上周");
                }
                final TimesheetPlanDO save = timesheetPlanRepo.save(entity);
                result.add(TimesheetPlanConvert.INSTANCE.toVo(save));
            });
        }
        return result;
    }

    @Override
    public void syncWorkPlanTo4(String param) {
        LocalDateTime syncTime = LocalDateTime.now();

        XxlJobLogger.log("工作计划同步到4.0开始...");
        XxlJobLogger.log("syncWorkPlanTo4 localDateTime：" + syncTime);

        LocalDate today = LocalDate.now();
        List<TimesheetPlanDO> timesheetPlanDOS = timesheetPlanRepo.queryWorkPlanList(today);

        LocalDateTime syncNow = LocalDateTime.now();
        List<TimesheetPlanDO> workPlanList = new ArrayList<>();
        for (TimesheetPlanDO timesheetPlanDO: timesheetPlanDOS) {
            TimesheetPlanDO workPlanDo = new TimesheetPlanDO();
            workPlanDo.setId(timesheetPlanDO.getId());
            workPlanDo.setProjId(timesheetPlanDO.getProjId());
            workPlanDo.setTaskId(timesheetPlanDO.getTaskId());
            workPlanDo.setWorkDesc(timesheetPlanDO.getWorkDesc());
            workPlanDo.setWorkDate(timesheetPlanDO.getWorkDate());
            workPlanDo.setActId(timesheetPlanDO.getActId());
            workPlanDo.setLabel(timesheetPlanDO.getLabel());
            List<Long> longs = transferUtilRepo.queryEmployeeTw4Ids(Arrays.asList(timesheetPlanDO.getTsUserId()));
            if(!CollectionUtils.isEmpty(longs)){
                workPlanDo.setTsUserId(longs.get(0));
            }

            workPlanList.add(workPlanDo);
        }

        String syncData = "";
        if(!CollectionUtils.isEmpty(workPlanList)){
            // 将同步数据推送到4.0
            syncData = pushWorkPlanTo4(workPlanList);
        }else{
            syncData = "工作计划数据未变化!";
        }
        String syncType = "work_plan_to4";
        // 记录同步日志
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
        XxlJobLogger.log("同步工作计划结束..." + logDO);
    }

    /**
     * @description:  工作计划同步数据到4.0
     * @author: dragonHuang
     * @date: 2023/7/26 10:03
     * @param: workPlanList 需要同步的数据
     * @return: String 同步的日志
     **/
    private String pushWorkPlanTo4(List<TimesheetPlanDO> workPlanList){
        int failCount = 0;
        for(TimesheetPlanDO workPlanDo : workPlanList){
            LocalDateTime syncStartTime = LocalDateTime.now();
            try {
                Map<String, Object> map = com.elitesland.tw.tw5.server.common.util.BeanUtil.beanToMap(workPlanDo);
//                String resultMain = httpUtil.sendPost(tw4_url + workPlanUrl, map);
//                Map<String, Object> data = (Map) JSON.parse(resultMain);
                Map<String, Object> data = new HashMap<>();
                if (!(data.get("ok") + "").equals("true")) {
                    LocalDateTime syncEndTime = LocalDateTime.now();
                    String syncData = "工作计划id=" + workPlanDo.getId() + "同步失败，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "响应结果：" + data;
                    String syncType = "work_plan_to4";
                    XxlJobLogger.log(syncData);

                    this.saveSyncLog(syncType + "_exception", syncData, null);
                    failCount++;
                }
            } catch (Exception e) {
                XxlJobLogger.log("工作计划同步id为" + workPlanDo.getId() + ", 工作计划同步异常......" + e);
                LocalDateTime syncEndTime = LocalDateTime.now();
                String syncType = "work_plan_to4";
                String syncData = "工作计划id=" + workPlanDo.getId() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + e;
                this.saveSyncLog(syncType + "_exception", syncData, null);
                failCount++;
            }
        }
        String syncDatalog = "更新了" + (workPlanList.size() - failCount) + "数据,有" + failCount + "条数据更新失败！";
        return syncDatalog;
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime){
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        return logDO;
    }

}
