package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 员工当量系数
 *
 * @author 王顶
 * @date 2022/11/03
 */
@Entity
@Table(name = "prd_org_employee_eqva_ratio", indexes = {@Index(name = "org_index", columnList = "org_id"),
        @Index(name = "eqvaRatioIdV4_index", columnList = "eqva_ratio_id_v4"),
        @Index(name = "user_index", columnList = "user_id")
})
@org.hibernate.annotations.Table(appliesTo = "prd_org_employee_eqva_ratio", comment = "员工当量系数表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgEmployeeEqvaRatioDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Comment("4.0的当前当量系数记录id")
    @Column(name = "eqva_ratio_id_v4")
    private Long eqvaRatioIdV4;

    @Comment("组织id")
    @Column(name = "org_id")
    private Long orgId;


    @Comment("用户id")
    @Column(name = "user_id")
    private Long userId;


    @Comment("开始日期")
    @Column()
    private LocalDate startDate;


    @Comment("结束日期")
    @Column()
    private LocalDate endDate;


    @Comment("当量系数")
    @Column()
    private BigDecimal eqvaRatio;

}
