package com.elitesland.tw.tw5.server.prd.partner.common.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 业务伙伴管理-业务伙伴同步JDE
 *
 * @author wly
 * @date 2023-12-07
 */
@Entity
@Table(name = "com_sync_business_partner", indexes = {
        @Index(name = "object_id_index", columnList = "object_id"),
})
@org.hibernate.annotations.Table(appliesTo = "com_sync_business_partner", comment = "业务伙伴同步JDE")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ComSyncBusinessPartnerDO extends BaseModel implements Serializable {
    /**
     * 合同id
     */
    @Comment("合同id")
    @Column()
    private Long contractId;
    /**
     * 业务伙伴id
     */
    @Comment("业务伙伴id")
    @Column()
    private Long partnerId;

    /**
     * 客户/供应商id
     */
    @Comment("客户/供应商id")
    @Column(name = "object_id")
    private Long objectId;
    /**
     * 客户/供应商编号
     */
    @Comment("客户/供应商编号")
    @Column(name = "an8")
    private String AN8;
    /**
     * 地址簿名称
     */
    @Comment("地址簿名称")
    @Column(name = "alph")
    private String ALPH;
    /**
     * 客户/供应商名称
     */
    @Comment("客户/供应商名称")
    @Column(name = "alky")
    private String ALKY;

    /**
     * 相关主档 C是客户 V是供应商
     */
    @Comment("相关主档 C是客户 V是供应商")
    @Column(name = "at1")
    private String AT1;

    /**
     * 签约公司
     */
    @Comment("签约公司")
    @Column(name = "mcu")
    private String MCU;
    /**
     * 合同税率
     */
    @Comment("合同税率")
    @Column(name = "txa1")
    private String TXA1;
    /**
     * 货币码1
     */
    @Comment("货币码1")
    @Column(name = "crcd")
    private String CRCD;
    /**
     * 货币码2
     */
    @Comment("货币码2")
    @Column(name = "crca")
    private String CRCA;
    /**
     * 总账冲销
     */
    @Comment("总账冲销")
    @Column(name = "arc")
    private String ARC;
    /**
     * 税说明码
     */
    @Comment("税说明码")
    @Column(name = "extr1")
    private String EXTR1;
    /**
     * 批处理方式
     */
    @Comment("批处理方式")
    @Column(name = "edpm")
    private String EDPM;
    /**
     * 状态 0失败 1成功
     */
    @Comment("状态 0失败 1成功 ")
    @Column()
    private String status;
    /**
     * 执行次数
     */
    @Comment("执行次数")
    @Column()
    private Integer count;

    /**
     * 类型
     */
    @Comment("类型 销售合同 采购合同 采购协议 商机")
    @Column()
    private String docType;

    public void copy(ComSyncBusinessPartnerDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
