package com.elitesland.tw.tw5.server.prd.partner.identity.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCollaboratePartnerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCollaboratePartnerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCollaboratePartnerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowRoleCodeEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamTypeEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.convert.BusinessCollaboratePartnerInfoConvert;
import com.elitesland.tw.tw5.server.prd.partner.identity.dao.BusinessCollaboratePartnerInfoDAO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessCollaboratePartnerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCollaboratePartnerInfoRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

/**
 * 业务伙伴-合作伙伴
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessCollaboratePartnerInfoServiceImpl extends BaseServiceImpl implements BusinessCollaboratePartnerInfoService {

    private final BusinessCollaboratePartnerInfoRepo businessCollaboratePartnerInfoRepo;
    private final BusinessCollaboratePartnerInfoDAO businessCollaboratePartnerInfoDAO;
    private final FileUtil fileUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdOrgEmployeeDAO employeeDAO;
    @Value("${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final TransactionUtilService transactionUtilService;
    private final BusinessTeamMemberService businessTeamMemberService;
    @Override
    public PagingVO<BusinessCollaboratePartnerInfoVO> queryPaging(BusinessCollaboratePartnerInfoQuery query){
        PagingVO<BusinessCollaboratePartnerInfoVO> businessCollaboratePartnerInfoVOPagingVO = businessCollaboratePartnerInfoDAO.queryPaging(query);
        if(!CollectionUtils.isEmpty(businessCollaboratePartnerInfoVOPagingVO.getRecords())){
            businessCollaboratePartnerInfoVOPagingVO.stream().forEach(p->translate(p));
        }
        return businessCollaboratePartnerInfoVOPagingVO;
    }

    @Override
    public List<BusinessCollaboratePartnerInfoVO> queryListDynamic(BusinessCollaboratePartnerInfoQuery query){
        List<BusinessCollaboratePartnerInfoVO> businessCollaboratePartnerInfoVOS = businessCollaboratePartnerInfoDAO.queryListDynamic(query);
        businessCollaboratePartnerInfoVOS.stream().forEach(vo->{
            translate(vo);
        });
        return businessCollaboratePartnerInfoVOS;
    }

    @Override
    public BusinessCollaboratePartnerInfoVO queryByKey(Long key) {
        BusinessCollaboratePartnerInfoDO entity = businessCollaboratePartnerInfoRepo.findById(key).orElseGet(BusinessCollaboratePartnerInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessCollaboratePartnerInfoVO vo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo(entity);
        translate(vo);
        return vo;
    }

    @Override
    public BusinessCollaboratePartnerInfoVO queryByPartnerId(Long partnerId) {
        BusinessCollaboratePartnerInfoDO entity = businessCollaboratePartnerInfoRepo.findByPartnerId(partnerId);
        if(entity == null){
            throw TwException.error("","合作伙伴对象不存在");
        }
        BusinessCollaboratePartnerInfoVO vo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo(entity);
        translate(vo);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessCollaboratePartnerInfoVO insert(BusinessCollaboratePartnerInfoPayload payload) {
        BusinessCollaboratePartnerInfoDO entityDo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toDo(payload);
        return BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo(businessCollaboratePartnerInfoRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessCollaboratePartnerInfoVO update(BusinessCollaboratePartnerInfoPayload payload) {
        BusinessCollaboratePartnerInfoDO entity = businessCollaboratePartnerInfoRepo.findById(payload.getId()).orElseGet(BusinessCollaboratePartnerInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");
        //如果渠道负责人改变了 更新渠道负责人
        updateCollaborateTeamMember(payload);
        // 变更日志用
        BusinessCollaboratePartnerInfoDO entityLog = new BusinessCollaboratePartnerInfoDO();
        BeanUtils.copyProperties(entity, entityLog);
        BusinessCollaboratePartnerInfoDO entityDo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        //操作记录
        if (null != payload.getPartnerId()) {
            // 修改NULL值特殊处理
            final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
            //获取变更日志
            fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (org.springframework.util.StringUtils.hasText(fieldsUpdateLog)) {
                logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
            //  logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "更改账户信息");
        }

        return BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo(businessCollaboratePartnerInfoRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessCollaboratePartnerInfoDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public void activeCollaboratePartnerWithWorkFlow(Long partnerId,String partnerName) {
        BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = queryByPartnerId(partnerId);
        ProcessInfo processInfo = new ProcessInfo();
        if (workflow_enabled) {
            //获取申请人
            HashMap variables = dealActiveWorkFlowVariables(businessCollaboratePartnerInfoVO);
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.COLLABORATE_ACTIVE.name(),
                    partnerName+"-合作伙伴激活流程",
                    businessCollaboratePartnerInfoVO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        BusinessCollaboratePartnerInfoPayload payload = new BusinessCollaboratePartnerInfoPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(businessCollaboratePartnerInfoVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setCollaborateStatus(BusinessPartnerStatusEnum.APPROVING.getCode());
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            businessCollaboratePartnerInfoDAO.updateByKeyDynamic(payload);
        });
    }

    @Override
    @Transactional
    public void activeCollaboratePartner(Long partnerId,String partnerName) {
        BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = queryByPartnerId(partnerId);
        BusinessCollaboratePartnerInfoPayload payload = new BusinessCollaboratePartnerInfoPayload();
        payload.setId(businessCollaboratePartnerInfoVO.getId());
        payload.setCollaborateStatus(BusinessPartnerStatusEnum.ACTIVE.getCode());
        businessCollaboratePartnerInfoDAO.updateByKeyDynamic(payload);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateCollaborateTeamMember(BusinessCollaboratePartnerInfoPayload payload) {
        List<BusinessTeamMemberVO> businessTeamMemberVOS = businessTeamMemberService.queryByObjectIdAndRole(payload.getPartnerId(),BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode());

        //渠道负责人
        if (payload.getChannelUserId() != null) {
            Long orgId = cacheUtil.getDefaultOrgIdByUserId(payload.getChannelUserId());
            if (!CollectionUtils.isEmpty(businessTeamMemberVOS)) {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setId(businessTeamMemberVOS.get(0).getId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getChannelUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getChannelUserId());
                businessTeamMemberService.update(businessTeamMemberPayload);
            } else {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getChannelUserId());
                businessTeamMemberPayload.setMemberName(cacheUtil.getUserName(payload.getChannelUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.CHANNEL_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(payload.getId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.CHANNEL_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberService.save(businessTeamMemberPayload);
            }
        }
    }

    //翻译某些字段
    public void translate(BusinessCollaboratePartnerInfoVO vo){
        //todo 附件要上传到易稻壳
        vo.setFileDatas1(fileUtil.getFileDatas(vo.getFileCodes1()));
        vo.setFileDatas2(fileUtil.getFileDatas(vo.getFileCodes2()));
        vo.setFileDatas3(fileUtil.getFileDatas(vo.getFileCodes3()));

        //翻译合作伙伴标签
        if(StringUtils.hasText(vo.getCollaborateTag())){
            String[] identityArray = vo.getCollaborateTag().split(",");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < identityArray.length; i++) {
                String selection = cacheUtil.transferSystemSelection(FunctionSelectionEnum.COOP_TAG.getCode(), identityArray[i]);
                if (i == identityArray.length - 1) {
                    stringBuilder.append(selection);
                } else {
                    stringBuilder.append(selection + ",");
                }
            }
            vo.setCollaborateTagDesc(stringBuilder.toString());
        }
    }

    //处理合作伙伴激活流程参数
    public HashMap dealActiveWorkFlowVariables(BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO){
        HashMap<String, Object> variables = new HashMap<>();
        //渠道部经营部负责人 todo
        PrdOrgRoleVO channelOperation = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.CUST_CHANNER_OPERATION.getCode() );
        if (ObjectUtils.isEmpty(channelOperation)) {
            throw TwException.error("",WorkFlowRoleCodeEnum.CUST_CHANNER_OPERATION.getDesc()+"不存在！");
        }
        String[] splitChannelOperation = channelOperation.getRoleEmployees().split(",");
        variables.put("Activity_16gj46w", Arrays.asList(splitChannelOperation));

        //(傅总)
        PrdOrgRoleVO custOfficer = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.CUST_OFFICER.getCode() );
        if (ObjectUtils.isEmpty(custOfficer)) {
            throw TwException.error("",WorkFlowRoleCodeEnum.CUST_OFFICER.getDesc()+"不存在！");
        }
        String[] splitByCustOfficer = custOfficer.getRoleEmployees().split(",");
        variables.put("Activity_1opzy6c", Arrays.asList(splitByCustOfficer));

        return variables;
    }
}
