package com.elitesland.tw.tw5.server.prd.pay.service;

import com.elitesland.tw.tw5.api.prd.pay.service.BKGetVerificationCodeService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 银企直连-银行流水获取验证码
 *
 * @author wangly
 * @date 2023-12-12
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BKGetVerificationCodeServiceImpl implements BKGetVerificationCodeService {

    private final static String key = "TWBANK_VERIFICATION:";
    @Autowired
    private RedisUtils redisUtils;
    private final CacheUtil cacheUtil;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;
    @Override
    public void getVerificationCode() {

        //获取当前登录人 平台总体业务负责人、平台总体负责人，平台财务出纳、管理员
        Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_FIN_CASHIER.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        if(!rolePermission){
            throw TwException.error("","您没有权限查看此页面");
        }
        //获取六位数的验证码
        String sixDigitCode = generateSixDigitCode();
        redisUtils.set(key+loginUserId,sixDigitCode,3, TimeUnit.MINUTES);
        //发送邮件
        try {
            // 发送邮件到当前登录人 如果是管理员发送给平台财务出纳
            String noticeSource = loginUserId.toString();
            if(cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()))){
                List<Long> finUserId = roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_CASHIER.getCode());
                if(CollectionUtils.isEmpty(finUserId)){
                    throw TwException.error("","平台财务出纳不存在");
                }
                noticeSource =finUserId.get(0).toString();
            }
            Map<String, Object> data = new HashMap<>();
            data.put("sixDigitCode", sixDigitCode);
            PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20240510000001");
            messageConfigService.sendMessageConfig(configVO, data, "appoint_people", noticeSource);
            log.info("邮件发送成功");
        } catch (Exception e) {
            log.info("邮件发送出现异常");
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public void confirmVerificationCode(String verificationCode) {
        if(!StringUtils.hasText(verificationCode)){
            throw TwException.error("","验证码不能为空");
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        if(!redisUtils.hasKey(key+loginUserId)){
            throw TwException.error("","验证码错误");
        }else if(redisUtils.get(key+loginUserId)==null){
            throw TwException.error("","验证码已过期");
        }else if(!verificationCode.equals(redisUtils.get(key+loginUserId).toString())){
            throw TwException.error("","验证码错误");
        }
    }

    // 生成指定长度的数字验证码方法
    private static String generateSixDigitCode() {
        // 创建Random对象
        Random random = new Random();
        // 初始化StringBuilder
        StringBuilder codeBuilder = new StringBuilder();

        // 循环生成六位数字
        for (int i = 0; i < 6; i++) {
            // 生成0-9之间的随机数并添加到StringBuilder中
            codeBuilder.append(random.nextInt(10));
        }

        // 返回生成的验证码字符串
        return codeBuilder.toString();
    }
}
