package com.elitesland.tw.tw5.server.prd.personplan.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsProjectRoleAssignmentPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleAssignmentService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleAssignmentVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * 项目角色分配
 *
 * @author xxb
 * @date 2023-07-07
 */
@Api(tags = "项目角色分配")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectRoleAssignment")
@Slf4j
public class PmsProjectRoleAssignmentController {

    private final PmsProjectRoleAssignmentService pmsProjectRoleAssignmentService;

    /**
     * 项目角色分配-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目角色分配-新增")
    public TwOutputUtil<PmsProjectRoleAssignmentVO> insert(@RequestBody PmsProjectRoleAssignmentPayload payload) {
        pmsProjectRoleAssignmentService.insert(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 项目角色分配-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("项目角色分配-分页")
    public TwOutputUtil<PagingVO<PmsProjectRoleAssignmentVO>> paging(PmsProjectRoleAssignmentQuery query) {
        return TwOutputUtil.ok(pmsProjectRoleAssignmentService.queryPaging(query));
    }

    /**
     * 项目角色分配
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("项目角色分配")
    public TwOutputUtil<PagingVO<PmsProjectRoleAssignmentVO>> queryList(PmsProjectRoleAssignmentQuery query) {
        return TwOutputUtil.ok(pmsProjectRoleAssignmentService.queryListDynamic(query));
    }

}
