package com.elitesland.tw.tw5.server.prd.personplan.dao;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QPersonPlanDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsInnerProjectApplyDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConExecConditionDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划RepoProc
 */
@Component
public class PersonPlanDao extends BaseRepoProc<PersonPlanDO> {

    private static final QPersonPlanDO qPersonPlanDO = QPersonPlanDO.personPlanDO;
    private static final QPmsProjectDO qPmsProjectDO = QPmsProjectDO.pmsProjectDO;
    private static final QPmsInnerProjectApplyDO qPmsInnerProjectApplyDO = QPmsInnerProjectApplyDO.pmsInnerProjectApplyDO;
    private static final QCrmOpportunityDO qCrmOpportunityDO = QCrmOpportunityDO.crmOpportunityDO;
    private static final QSaleConContractDO qSaleConContractDO = QSaleConContractDO.saleConContractDO;
    private static final QSaleConExecConditionDO qSaleConExecConditionDO = QSaleConExecConditionDO.saleConExecConditionDO;
    private static final QPrjProjectDO qdoProj = QPrjProjectDO.prjProjectDO;

    protected PersonPlanDao() {

        super(qPersonPlanDO);

    }


    public PagingVO<PersonPlanVO> page(PersonPlanQuery personPlanQuery) {

        JPAQuery<PersonPlanVO> query =
                select(PersonPlanVO.class)
                        .where(bulidPredicate(personPlanQuery));
        personPlanQuery.setPaging(query);
        personPlanQuery.fillOrders(query, qPersonPlanDO);
        return PagingVO.<PersonPlanVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPersonPlanDO)
                .set(qPersonPlanDO.deleteFlag, 1)
                .where(qPersonPlanDO.id.in(ids))
                .execute();

        return res;

    }


    public PersonPlanVO get(Long id) {

        PersonPlanVO personPlanVO = select(PersonPlanVO.class)
                .where(qPersonPlanDO.id.eq(id))
                .fetchOne();

        return personPlanVO;

    }


    public List<PersonPlanVO> getList(PersonPlanQuery personPlanQuery) {

        List<PersonPlanVO> res =
                select(PersonPlanVO.class)
                        .where(bulidPredicate(personPlanQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPersonPlanDO.objId,
                        qPersonPlanDO.objName,
                        qPersonPlanDO.planType,
                        qPersonPlanDO.fileCodes,
                        qPersonPlanDO.state,
                        qPersonPlanDO.startDate,
                        qPersonPlanDO.endDate,
                        qPersonPlanDO.duration,
                        qPersonPlanDO.uom,
                        qPersonPlanDO.version,
                        qPersonPlanDO.id,
                        qPersonPlanDO.createTime,
                        qPersonPlanDO.createUserId,
                        qPersonPlanDO.remark,
                        qPersonPlanDO.proId
                )).from(qPersonPlanDO);

    }


    private Predicate bulidPredicate(PersonPlanQuery personPlanQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(!ObjectUtils.isEmpty(personPlanQuery.getObjId()), qPersonPlanDO.objId, personPlanQuery.getObjId())
                .andEq(!ObjectUtils.isEmpty(personPlanQuery.getObjName()), qPersonPlanDO.objName, personPlanQuery.getObjName())
                .andEq(!ObjectUtils.isEmpty(personPlanQuery.getPlanType()), qPersonPlanDO.planType, personPlanQuery.getPlanType())
                .andEq(!ObjectUtils.isEmpty(personPlanQuery.getState()), qPersonPlanDO.state, personPlanQuery.getState())
                .andEq(!ObjectUtils.isEmpty(personPlanQuery.getStartDate()), qPersonPlanDO.startDate, personPlanQuery.getStartDate())
                .andEq(!ObjectUtils.isEmpty(personPlanQuery.getEndDate()), qPersonPlanDO.endDate, personPlanQuery.getEndDate())
                .andEq(null !=personPlanQuery.getDuration(), qPersonPlanDO.duration, personPlanQuery.getDuration())
                .andEq(StringUtils.isNotBlank(personPlanQuery.getUom()), qPersonPlanDO.uom, personPlanQuery.getUom())
                .andEq(StringUtils.isNotBlank(personPlanQuery.getVersion()), qPersonPlanDO.version, personPlanQuery.getVersion())
                .andIn(!ObjectUtils.isEmpty(personPlanQuery.getIds()), qPersonPlanDO.id, personPlanQuery.getIds())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(PersonPlanQuery personPlanQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 关联对象id
        if (null != personPlanQuery.getObjId()) {
            predicates.add(qPersonPlanDO.objId.eq(personPlanQuery.getObjId()));
        }
        // 关联对象
        if (null != personPlanQuery.getObjName()) {
            predicates.add(qPersonPlanDO.objName.eq(personPlanQuery.getObjName()));
        }
        // 规划类型
        if (null != personPlanQuery.getPlanType()) {
            predicates.add(qPersonPlanDO.planType.eq(personPlanQuery.getPlanType()));
        }
        // 状态
        if (null != personPlanQuery.getState()) {
            predicates.add(qPersonPlanDO.state.eq(personPlanQuery.getState()));
        }
        // 开始日期
        if (null != personPlanQuery.getStartDate()) {
            predicates.add(qPersonPlanDO.startDate.eq(personPlanQuery.getStartDate()));
        }
        // 结束日期
        if (null != personPlanQuery.getEndDate()) {
            predicates.add(qPersonPlanDO.endDate.eq(personPlanQuery.getEndDate()));
        }
        // 持续时长
        if (null !=personPlanQuery.getDuration()) {
            predicates.add(qPersonPlanDO.duration.eq(personPlanQuery.getDuration()));
        }
        // 周期单位
        if (StringUtils.isNotEmpty(personPlanQuery.getUom())) {
            predicates.add(qPersonPlanDO.uom.eq(personPlanQuery.getUom()));
        }
        // 当前版本
        if (StringUtils.isNotEmpty(personPlanQuery.getVersion())) {
            predicates.add(qPersonPlanDO.version.eq(personPlanQuery.getVersion()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(PersonPlanQuery personPlanQuery) {

        long res = select(PersonPlanVO.class)
                .where(bulidPredicates(personPlanQuery))
                .fetchCount();

        return res;


    }

    public Long update(PersonPlanPayload personPlanPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPersonPlanDO);

        // 项目id
        if (null != personPlanPayload.getObjId()) {
            update.set(qPersonPlanDO.objId, personPlanPayload.getObjId());
        }
        // 关联对象
        if (null != personPlanPayload.getObjName()) {
            update.set(qPersonPlanDO.objName, personPlanPayload.getObjName());
        }
        // 规划类型
        if (null != personPlanPayload.getPlanType()) {
            update.set(qPersonPlanDO.planType, personPlanPayload.getPlanType());
        }
        // 附件
        if (null != personPlanPayload.getFileCodes()) {
            update.set(qPersonPlanDO.fileCodes, personPlanPayload.getFileCodes());
        }

        // 状态
        if (null != personPlanPayload.getState()) {
            update.set(qPersonPlanDO.state, personPlanPayload.getState());
        }
        // 开始日期
        if (null != personPlanPayload.getStartDate()) {
            update.set(qPersonPlanDO.startDate, personPlanPayload.getStartDate());
        }
        // 结束日期
        if (null != personPlanPayload.getEndDate()) {
            update.set(qPersonPlanDO.endDate, personPlanPayload.getEndDate());
        }
        // 持续时长
        if (null !=personPlanPayload.getDuration()) {
            update.set(qPersonPlanDO.duration, personPlanPayload.getDuration());
        }
        // 周期单位
        if (StringUtils.isNotEmpty(personPlanPayload.getUom())) {
            update.set(qPersonPlanDO.uom, personPlanPayload.getUom());
        }
        // 当前版本
        if (StringUtils.isNotEmpty(personPlanPayload.getVersion())) {
            update.set(qPersonPlanDO.version, personPlanPayload.getVersion());
        }
        long res = update.where(qPersonPlanDO.id.eq(personPlanPayload.getId()))
                .execute();
        return res;

    }

    // 商机资源规划
    public PersonPlanVO queryOppo(Long objId, List<String> planTypeList) {

        PersonPlanVO personPlanVO = jpaQueryFactory.select(Projections.bean(PersonPlanVO.class,
                        qPersonPlanDO.objId,
                        qdoProj.projectName.as("objName"),
                        qPersonPlanDO.planType,
                        qPersonPlanDO.fileCodes,
                        qPersonPlanDO.state,
                        qPersonPlanDO.startDate,
                        qPersonPlanDO.endDate,
                        qPersonPlanDO.duration,
                        qPersonPlanDO.uom,
                        qPersonPlanDO.version,
                        qPersonPlanDO.id,
                        qPersonPlanDO.createTime,
                        qPersonPlanDO.createUserId,
                        qPersonPlanDO.remark,
                        qPersonPlanDO.modifyTime
                )).from(qPersonPlanDO).leftJoin(qCrmOpportunityDO).on(qPersonPlanDO.objId.eq(qCrmOpportunityDO.id))
                .leftJoin(qdoProj).on(qdoProj.id.eq(qCrmOpportunityDO.projectId))
                .where(qPersonPlanDO.objId.eq(objId))
                .where(qPersonPlanDO.planType.in(planTypeList))
                .fetchFirst();
        return personPlanVO;
    }

    // 合同预算资源规划
    public PersonPlanVO queryBudget(Long objId, List<String> planTypeList) {

        PersonPlanVO personPlanVO = jpaQueryFactory.select(Projections.bean(PersonPlanVO.class,
                        qPersonPlanDO.objId,
                        qSaleConContractDO.name.as("objName"),
                        qPersonPlanDO.planType,
                        qPersonPlanDO.fileCodes,
                        qPersonPlanDO.state,
                        qPersonPlanDO.startDate,
                        qPersonPlanDO.endDate,
                        qPersonPlanDO.duration,
                        qPersonPlanDO.uom,
                        qPersonPlanDO.version,
                        qPersonPlanDO.id,
                        qPersonPlanDO.createTime,
                        qPersonPlanDO.createUserId,
                        qPersonPlanDO.remark,
                        qPersonPlanDO.modifyTime
                )).from(qPersonPlanDO).leftJoin(qSaleConExecConditionDO).on(qPersonPlanDO.objId.eq(qSaleConExecConditionDO.id))
                .leftJoin(qSaleConContractDO).on(qSaleConExecConditionDO.contractId.eq(qSaleConContractDO.id))
                .where(qPersonPlanDO.objId.eq(objId))
                .where(qPersonPlanDO.planType.in(planTypeList))
                .fetchFirst();
        return personPlanVO;
    }

    // 项目资源规划
    public PersonPlanVO queryProject(Long objId, List<String> planTypeList) {

        PersonPlanVO personPlanVO = jpaQueryFactory.select(Projections.bean(PersonPlanVO.class,
                        qPersonPlanDO.objId,
                        qPmsProjectDO.projName.as("objName"),
                        qPersonPlanDO.planType,
                        qPersonPlanDO.fileCodes,
                        qPersonPlanDO.state,
                        qPersonPlanDO.startDate,
                        qPersonPlanDO.endDate,
                        qPersonPlanDO.duration,
                        qPersonPlanDO.uom,
                        qPersonPlanDO.version,
                        qPersonPlanDO.id,
                        qPersonPlanDO.createTime,
                        qPersonPlanDO.createUserId,
                        qPersonPlanDO.remark,
                        qPersonPlanDO.modifyTime
                )).from(qPersonPlanDO).leftJoin(qPmsProjectDO).on(qPersonPlanDO.objId.eq(qPmsProjectDO.id))
                .where(qPersonPlanDO.objId.eq(objId))
                .where(qPersonPlanDO.planType.in(planTypeList))
                .fetchFirst();
        return personPlanVO;
    }

    // 内部项目资源规划
    public PersonPlanVO queryInnerProject(Long objId, List<String> planTypeList) {
        PersonPlanVO personPlanVO = jpaQueryFactory.select(Projections.bean(PersonPlanVO.class,
                        qPersonPlanDO.objId,
                        qPmsInnerProjectApplyDO.projName.as("objName"),
                        qPersonPlanDO.planType,
                        qPersonPlanDO.fileCodes,
                        qPersonPlanDO.state,
                        qPersonPlanDO.startDate,
                        qPersonPlanDO.endDate,
                        qPersonPlanDO.duration,
                        qPersonPlanDO.uom,
                        qPersonPlanDO.version,
                        qPersonPlanDO.id,
                        qPersonPlanDO.createTime,
                        qPersonPlanDO.createUserId,
                        qPersonPlanDO.remark,
                        qPersonPlanDO.modifyTime
                )).from(qPersonPlanDO).leftJoin(qPmsInnerProjectApplyDO).on(qPersonPlanDO.objId.eq(qPmsInnerProjectApplyDO.id))
                .where(qPersonPlanDO.objId.eq(objId))
                .where(qPersonPlanDO.planType.in(planTypeList))
                .fetchFirst();
        return personPlanVO;
    }

    public PersonPlanVO getByProId(Long proId) {

        PersonPlanVO res = select(PersonPlanVO.class)
                .where(qPersonPlanDO.proId.eq(proId))
                .fetchFirst();
        return res;
    }
}