package com.elitesland.tw.tw5.server.prd.personplan.dao;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanDtlPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanDtlQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlAndProjectVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProjectPersonPlanVO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanDtlDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QPersonPlanDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QPersonPlanDtlDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划明细RepoProc
 */
@Component
public class PersonPlanDtlDao extends BaseRepoProc<PersonPlanDtlDO> {

    private static final QPersonPlanDtlDO qPersonPlanDtlDO = QPersonPlanDtlDO.personPlanDtlDO;

    private static final QPersonPlanDO qPersonPlanDO = QPersonPlanDO.personPlanDO;
    private static final QPmsProjectDO qPmsProjectDO = QPmsProjectDO.pmsProjectDO;

    protected PersonPlanDtlDao() {

        super(qPersonPlanDtlDO);

    }


    public PagingVO<PersonPlanDtlVO> page(PersonPlanDtlQuery personPlanDtlQuery) {

        JPAQuery<PersonPlanDtlVO> query =
                select(PersonPlanDtlVO.class)
                        .where(bulidPredicate(personPlanDtlQuery));
        personPlanDtlQuery.setPaging(query);
        personPlanDtlQuery.fillOrders(query, qPersonPlanDtlDO);
        return PagingVO.<PersonPlanDtlVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPersonPlanDtlDO)
                .set(qPersonPlanDtlDO.deleteFlag, 1)
                .where(qPersonPlanDtlDO.id.in(ids))
                .execute();

        return res;

    }


    public PersonPlanDtlVO get(Long id) {

        PersonPlanDtlVO personPlanDtlVO = select(PersonPlanDtlVO.class)
                .where(qPersonPlanDtlDO.id.eq(id))
                .fetchOne();

        return personPlanDtlVO;

    }


    public List<PersonPlanDtlVO> getList(PersonPlanDtlQuery personPlanDtlQuery) {

        List<PersonPlanDtlVO> res =
                select(PersonPlanDtlVO.class)
                        .where(bulidPredicate(personPlanDtlQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPersonPlanDtlDO.planId,
                        qPersonPlanDtlDO.resId,
                        qPersonPlanDtlDO.roleCode,
                        qPersonPlanDtlDO.roleName,
                        qPersonPlanDtlDO.capasetLevelId,
                        qPersonPlanDtlDO.distributeRate,
                        qPersonPlanDtlDO.totalEqva,
                        qPersonPlanDtlDO.hiddenFlag,
                        qPersonPlanDtlDO.input,
                        qPersonPlanDtlDO.price,
                        qPersonPlanDtlDO.days,
                        qPersonPlanDtlDO.amt,
                        qPersonPlanDtlDO.daysJson,
                        qPersonPlanDtlDO.id,
                        qPersonPlanDtlDO.createTime,
                        qPersonPlanDtlDO.createUserId,
                        qPersonPlanDtlDO.remark,
                        qPersonPlanDtlDO.roleId,
                        qPersonPlanDtlDO.relatePartiesId

                )).from(qPersonPlanDtlDO);

    }


    private Predicate bulidPredicate(PersonPlanDtlQuery personPlanDtlQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getPlanId()), qPersonPlanDtlDO.planId, personPlanDtlQuery.getPlanId())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getResId()), qPersonPlanDtlDO.resId, personPlanDtlQuery.getResId())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getRoleCode()), qPersonPlanDtlDO.roleCode, personPlanDtlQuery.getRoleCode())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getCapasetLevelId()), qPersonPlanDtlDO.capasetLevelId, personPlanDtlQuery.getCapasetLevelId())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getDistributeRate()), qPersonPlanDtlDO.distributeRate, personPlanDtlQuery.getDistributeRate())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getTotalEqva()), qPersonPlanDtlDO.totalEqva, personPlanDtlQuery.getTotalEqva())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getHiddenFlag()), qPersonPlanDtlDO.hiddenFlag, personPlanDtlQuery.getHiddenFlag())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getInput()), qPersonPlanDtlDO.input, personPlanDtlQuery.getInput())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getPrice()), qPersonPlanDtlDO.price, personPlanDtlQuery.getPrice())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getDays()), qPersonPlanDtlDO.days, personPlanDtlQuery.getDays())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getAmt()), qPersonPlanDtlDO.amt, personPlanDtlQuery.getAmt())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getDaysJson()), qPersonPlanDtlDO.daysJson, personPlanDtlQuery.getDaysJson())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getRoleId()), qPersonPlanDtlDO.roleId, personPlanDtlQuery.getRoleId())
                .andEq(!ObjectUtils.isEmpty(personPlanDtlQuery.getRelatePartiesId()), qPersonPlanDtlDO.relatePartiesId, personPlanDtlQuery.getRelatePartiesId())
                .andIn(!ObjectUtils.isEmpty(personPlanDtlQuery.getResIdList()), qPersonPlanDtlDO.resId, personPlanDtlQuery.getResIdList())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(PersonPlanDtlQuery personPlanDtlQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 人员规划id
        if (null != personPlanDtlQuery.getPlanId()) {
            predicates.add(qPersonPlanDtlDO.planId.eq(personPlanDtlQuery.getPlanId()));
        }
        // 资源id
        if (null != personPlanDtlQuery.getResId()) {
            predicates.add(qPersonPlanDtlDO.resId.eq(personPlanDtlQuery.getResId()));
        }
        // 相关方
        if (null != personPlanDtlQuery.getRelatePartiesId()) {
            predicates.add(qPersonPlanDtlDO.relatePartiesId.eq(personPlanDtlQuery.getRelatePartiesId()));
        }
        // 角色
        if (null != personPlanDtlQuery.getRoleId()) {
            predicates.add(qPersonPlanDtlDO.roleId.eq(personPlanDtlQuery.getRoleId()));
        }
        // 角色
        if (null != personPlanDtlQuery.getRoleCode()) {
            predicates.add(qPersonPlanDtlDO.roleCode.eq(personPlanDtlQuery.getRoleCode()));
        }
        // 复合能力级别ID
        if (null != personPlanDtlQuery.getCapasetLevelId()) {
            predicates.add(qPersonPlanDtlDO.capasetLevelId.eq(personPlanDtlQuery.getCapasetLevelId()));
        }
        // 派发系数
        if (null != personPlanDtlQuery.getDistributeRate()) {
            predicates.add(qPersonPlanDtlDO.distributeRate.eq(personPlanDtlQuery.getDistributeRate()));
        }
        // 汇总当量
        if (null != personPlanDtlQuery.getTotalEqva()) {
            predicates.add(qPersonPlanDtlDO.totalEqva.eq(personPlanDtlQuery.getTotalEqva()));
        }
        // 隐藏标志
        if (null != personPlanDtlQuery.getHiddenFlag()) {
            predicates.add(qPersonPlanDtlDO.hiddenFlag.eq(personPlanDtlQuery.getHiddenFlag()));
        }
        // 投入精力
        if (null != personPlanDtlQuery.getInput()) {
            predicates.add(qPersonPlanDtlDO.input.eq(personPlanDtlQuery.getInput()));
        }
        // 人天单价
        if (null != personPlanDtlQuery.getPrice()) {
            predicates.add(qPersonPlanDtlDO.price.eq(personPlanDtlQuery.getPrice()));
        }
        // 人天合计
        if (null != personPlanDtlQuery.getDays()) {
            predicates.add(qPersonPlanDtlDO.days.eq(personPlanDtlQuery.getDays()));
        }
        // 金额合计
        if (null != personPlanDtlQuery.getAmt()) {
            predicates.add(qPersonPlanDtlDO.amt.eq(personPlanDtlQuery.getAmt()));
        }
        // 天数明细
        if (null != personPlanDtlQuery.getDaysJson()) {
            predicates.add(qPersonPlanDtlDO.daysJson.eq(personPlanDtlQuery.getDaysJson()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(PersonPlanDtlQuery personPlanDtlQuery) {

        long res = select(PersonPlanDtlVO.class)
                .where(bulidPredicates(personPlanDtlQuery))
                .fetchCount();

        return res;


    }

    public Long update(PersonPlanDtlPayload personPlanDtlPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPersonPlanDtlDO);

        // 人员规划id
        if (null != personPlanDtlPayload.getPlanId()) {
            update.set(qPersonPlanDtlDO.planId, personPlanDtlPayload.getPlanId());
        }

        // 资源
        if (null != personPlanDtlPayload.getResId()) {
            update.set(qPersonPlanDtlDO.resId, personPlanDtlPayload.getResId());
        }
        // 相关方
        if (null != personPlanDtlPayload.getRelatePartiesId()) {
            update.set(qPersonPlanDtlDO.relatePartiesId, personPlanDtlPayload.getRelatePartiesId());
        }
        // 角色
        if (null != personPlanDtlPayload.getRoleCode()) {
            update.set(qPersonPlanDtlDO.roleCode, personPlanDtlPayload.getRoleCode());
        }
        // 角色
        if (null != personPlanDtlPayload.getRoleId()) {
            update.set(qPersonPlanDtlDO.roleId, personPlanDtlPayload.getRoleId());
        }
        // 复合能力级别ID
        if (null != personPlanDtlPayload.getCapasetLevelId()) {
            update.set(qPersonPlanDtlDO.capasetLevelId, personPlanDtlPayload.getCapasetLevelId());
        }
        // 派发系数
        if (null != personPlanDtlPayload.getDistributeRate()) {
            update.set(qPersonPlanDtlDO.distributeRate, personPlanDtlPayload.getDistributeRate());
        }
        // 汇总当量
        if (null != personPlanDtlPayload.getTotalEqva()) {
            update.set(qPersonPlanDtlDO.totalEqva, personPlanDtlPayload.getTotalEqva());
        }
        // 隐藏标志
        if (null != personPlanDtlPayload.getHiddenFlag()) {
            update.set(qPersonPlanDtlDO.hiddenFlag, personPlanDtlPayload.getHiddenFlag());
        }
        // 投入精力
        if (null != personPlanDtlPayload.getInput()) {
            update.set(qPersonPlanDtlDO.input, personPlanDtlPayload.getInput());
        }
        // 人天单价
        if (null != personPlanDtlPayload.getPrice()) {
            update.set(qPersonPlanDtlDO.price, personPlanDtlPayload.getPrice());
        }
        // 人天合计
        if (null != personPlanDtlPayload.getDays()) {
            update.set(qPersonPlanDtlDO.days, personPlanDtlPayload.getDays());
        }
        // 金额合计
        if (null != personPlanDtlPayload.getAmt()) {
            update.set(qPersonPlanDtlDO.amt, personPlanDtlPayload.getAmt());
        }
        // 天数明细
        if (null != personPlanDtlPayload.getDaysJson()) {
            update.set(qPersonPlanDtlDO.daysJson, personPlanDtlPayload.getDaysJson());
        }
        long res = update.where(qPersonPlanDtlDO.id.eq(personPlanDtlPayload.getId()))
                .execute();
        return res;

    }

    public void deleteByPlanIds(List<Long> planIds) {
        jpaQueryFactory.update(qPersonPlanDtlDO).set(qPersonPlanDtlDO.deleteFlag, 1).where(qPersonPlanDtlDO.planId.in(planIds)).execute();
    }

    public void delByNotInIdList(List<Long> idNotInList) {
        jpaQueryFactory.update(qPersonPlanDtlDO).set(qPersonPlanDtlDO.deleteFlag, 1).where(qPersonPlanDtlDO.id.notIn(idNotInList)).execute();
    }

    public List<ProjectPersonPlanVO> queryPlanDtlList(LocalDateTime time) {
        JPAQuery<ProjectPersonPlanVO> jpaQuery = jpaQueryFactory.select(Projections.bean(ProjectPersonPlanVO.class,
                        qPersonPlanDtlDO.id.as("planDtlId"),
                        qPersonPlanDtlDO.planId,
                        qPersonPlanDtlDO.daysJson,
                        qPersonPlanDtlDO.days,
                        qPersonPlanDO.objId.as("projectId"),
                        qPersonPlanDO.startDate,
                        qPersonPlanDO.endDate,
                        qPersonPlanDtlDO.resId
                ))
                .from(qPersonPlanDtlDO)
                .leftJoin(qPersonPlanDO).on(qPersonPlanDO.id.eq(qPersonPlanDtlDO.planId))
                .where(qPersonPlanDO.planType.eq("BUDGET"));
        if (!ObjectUtils.isEmpty(time)) {
            jpaQuery.where(qPersonPlanDtlDO.modifyTime.gt(time));
        }
        return jpaQuery.fetch();
    }


    public List<PersonPlanDtlAndProjectVO> queryPlanDtlListByRelatePartiesId( List<Long> relatePartiesIdList){

        JPAQuery<PersonPlanDtlAndProjectVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PersonPlanDtlAndProjectVO.class,
                        qPersonPlanDtlDO.planId,
                        qPersonPlanDtlDO.resId,
                        qPersonPlanDtlDO.days,
                        qPersonPlanDtlDO.daysJson,
                        qPersonPlanDtlDO.id,
                        qPersonPlanDtlDO.relatePartiesId,
                        qPersonPlanDO.proId,
                        qPmsProjectDO.projName,
                        qPersonPlanDO.startDate,
                        qPersonPlanDO.endDate

                ))
                .from(qPersonPlanDtlDO)
                .leftJoin(qPersonPlanDO).on(qPersonPlanDtlDO.planId.eq(qPersonPlanDO.id))
                .leftJoin(qPmsProjectDO).on(qPmsProjectDO.id.eq(qPersonPlanDO.proId));

        jpaQuery.where(qPersonPlanDO.deleteFlag.eq(0));
        jpaQuery.where(qPersonPlanDtlDO.deleteFlag.eq(0));
        jpaQuery.where(qPmsProjectDO.deleteFlag.eq(0));
        jpaQuery.where(qPersonPlanDtlDO.relatePartiesId.in(relatePartiesIdList));
        return jpaQuery.fetch();
    }
}
