package com.elitesland.tw.tw5.server.prd.personplan.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsCommunicatePlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsCommunicatePlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsCommunicatePlanVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.personplan.convert.PmsCommunicatePlanConvert;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PmsCommunicatePlanDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QPmsCommunicatePlanDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PmsCommunicatePlanRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.List;


/**
 * 项目沟通计划dao
 * @author wangxl
 * @date 2024/4/1
 */
@RequiredArgsConstructor
@Repository
public class PmsCommunicatePlanDao {

    private final QPmsCommunicatePlanDO qdo = QPmsCommunicatePlanDO.pmsCommunicatePlanDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsCommunicatePlanRepo repo;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsCommunicatePlanVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsCommunicatePlanVO.class,
                qdo.id,
                qdo.tenantId,
                qdo.belongOrgId,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.tenantOrgId,
                qdo.remark,
                qdo.deleteFlag,
                qdo.title,
                qdo.wbsId,
                qdo.wbsName,
                qdo.communicateTime,
                qdo.processingUser,
                qdo.status,
                qdo.processingTime,
                qdo.beforeRemindTime,
                qdo.content,
                qdo.proId,
                qdo.beforeRemindTimeName,
                qdo.remindMode
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<Long> getJpaQuerySelectCount() {
        return jpaQueryFactory.select(qdo.id.count()).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     */
    private void jpaQueryWhere(JPAQuery<?> jpaQuery, PmsCommunicatePlanQuery query) {
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.eq(query.getRemark()));
        }
        if (!ObjectUtils.isEmpty(query.getTitle())) {
            jpaQuery.where(qdo.title.like("%" + query.getTitle() + "%"));
        }
        if (!ObjectUtils.isEmpty(query.getWbsId())) {
            jpaQuery.where(qdo.wbsId.eq(query.getWbsId()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsName())) {
            jpaQuery.where(qdo.wbsName.eq(query.getWbsName()));
        }
        if (!ObjectUtils.isEmpty(query.getCommunicateTime())) {
            jpaQuery.where(qdo.communicateTime.eq(query.getCommunicateTime()));
        }
        if (!ObjectUtils.isEmpty(query.getProcessingUser())) {
            jpaQuery.where(qdo.processingUser.like("%" + query.getProcessingUser() + "%"));
        }
        if (!ObjectUtils.isEmpty(query.getStatus())) {
            jpaQuery.where(qdo.status.eq(query.getStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getProcessingTime())) {
            jpaQuery.where(qdo.processingTime.eq(query.getProcessingTime()));
        }
        if (!ObjectUtils.isEmpty(query.getBeforeRemindTime())) {
            jpaQuery.where(qdo.beforeRemindTime.eq(query.getBeforeRemindTime()));
        }
        if (!ObjectUtils.isEmpty(query.getRemindMode())) {
            jpaQuery.where(qdo.remindMode.eq(query.getRemindMode()));
        }
        if (!ObjectUtils.isEmpty(query.getProId())) {
            jpaQuery.where(qdo.proId.eq(query.getProId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
    }

    /**
     * 分页查询
     * @param query 查询参数
     * @return result
     */
    public PagingVO<PmsCommunicatePlanVO> queryPage(PmsCommunicatePlanQuery query) {
        // 查询总行数total
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long nullAbleCount = jpaQuerySelectCount.fetchOne();
        long count = nullAbleCount == null ? 0 : nullAbleCount;
        // 如果总行数为0则直接返回
        if(count == 0){
            return PagingVO.<PmsCommunicatePlanVO>builder()
                    .total(count)
                    .records(Collections.emptyList())
                    .build();
        }
        JPAQuery<PmsCommunicatePlanVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        // 分页
        SqlUtil.handlePage(jpaQuerySelect, query);
        return PagingVO.<PmsCommunicatePlanVO>builder()
                .total(count)
                .records(jpaQuerySelect.fetch())
                .build();
    }

    /**
     * 查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsCommunicatePlanVO> queryList(PmsCommunicatePlanQuery query) {
        JPAQuery<PmsCommunicatePlanVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询count
     *
     * @param query 查询参数
     * @return count
     */
    public long queryCount(PmsCommunicatePlanQuery query) {
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long count = jpaQuerySelectCount.fetchOne();
        return count==null?0:count;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsCommunicatePlanVO queryByKey(Long id) {
        JPAQuery<PmsCommunicatePlanVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 调用jpa的保存
     *
     * @param payload payload
     * @return 保存后的对象
     */
    public PmsCommunicatePlanVO save(PmsCommunicatePlanPayload payload) {
        PmsCommunicatePlanDO ado = PmsCommunicatePlanConvert.INSTANCE.toEntity(payload);
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(ado);
        repo.save(ado);
        return PmsCommunicatePlanConvert.INSTANCE.toVO(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsCommunicatePlanDO> saveAll(List<PmsCommunicatePlanDO> dos) {
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(dos);
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PmsCommunicatePlanPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getTitle() != null) {
            update.set(qdo.title, payload.getTitle());
        }
        if (payload.getWbsId() != null) {
            update.set(qdo.wbsId, payload.getWbsId());
        }
        if (payload.getWbsName() != null) {
            update.set(qdo.wbsName, payload.getWbsName());
        }
        if (payload.getCommunicateTime() != null) {
            update.set(qdo.communicateTime, payload.getCommunicateTime());
        }
        if (payload.getProcessingUser() != null) {
            update.set(qdo.processingUser, payload.getProcessingUser());
        }
        if (payload.getStatus() != null) {
            update.set(qdo.status, payload.getStatus());
        }
        if (payload.getProcessingTime() != null) {
            update.set(qdo.processingTime, payload.getProcessingTime());
        }
        if (payload.getBeforeRemindTime() != null) {
            update.set(qdo.beforeRemindTime, payload.getBeforeRemindTime());
        }
        if (payload.getBeforeRemindTimeName() != null) {
            update.set(qdo.beforeRemindTimeName, payload.getBeforeRemindTimeName());
        }
        if (payload.getRemindMode() != null) {
            update.set(qdo.remindMode, payload.getRemindMode());
        }
        if (payload.getContent() != null) {
            update.set(qdo.content, payload.getContent());
        }
        if (payload.getProId() != null) {
            update.set(qdo.proId, payload.getProId());
        }
        // 处理要设置成空的字段(nullField处理)
        SqlUtil.handleNullFieldsUpdate(payload,qdo,update);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

}