package com.elitesland.tw.tw5.server.prd.personplan.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 项目角色
 *
 * @author xxb
 * @date 2023-07-07
 */
@Entity
@Table(name = "pms_project_role", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_role", comment = "项目角色")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectRoleDO extends BaseModel implements Serializable  {
    /** 角色名称 */
    @Comment("角色名称")
    @Column()
    private String roleName;
    /** 角色编号 */
    @Comment("角色编号")
    @Column()
    private String roleCode;
    /** 平均单价 */
    @Comment("平均单价")
    @Column()
    private BigDecimal unitPrice;

    public void copy(PmsProjectRoleDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
