package com.elitesland.tw.tw5.server.prd.personplan.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsRelatedHistoryPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsRelatedHistoryQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsRelatedHistoryVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PmsRelatedHistoryDao;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.PmsRelatedHistoryService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;


/**
 * 相关方变化历史记录service impl
 * @author wangxl
 * @date 2024/3/18
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsRelatedHistoryServiceImpl implements PmsRelatedHistoryService {

    private final PmsRelatedHistoryDao dao;

    @Override
    public TwOutputUtil<PagingVO<PmsRelatedHistoryVO>> queryPage(PmsRelatedHistoryQuery query) {
        PagingVO<PmsRelatedHistoryVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<PmsRelatedHistoryVO>> queryList(PmsRelatedHistoryQuery query) {
        List<PmsRelatedHistoryVO> listVO = dao.queryList(query);
        translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(PmsRelatedHistoryQuery query) {
        return TwOutputUtil.ok(dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PmsRelatedHistoryVO> queryByKey(Long id) {
        if (null == id) {return null;}
        PmsRelatedHistoryVO vo = dao.queryByKey(id);
        Assert.notNull(vo,"查询的数据不存在");
        translate(List.of(vo));
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsRelatedHistoryVO> insert(PmsRelatedHistoryPayload payload) {
        // 检查数据
        checkData(payload);
        // 保存数据
        PmsRelatedHistoryVO save = dao.save(payload);
        // todo 开启工作流
        // startWorkFlow(ado);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsRelatedHistoryVO> update(PmsRelatedHistoryPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsRelatedHistoryVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsRelatedHistoryVO> updateDynamic(PmsRelatedHistoryPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        return TwOutputUtil.ok(dao.deleteSoft(ids));
    }


    /**
     * 发起工作流
     * @param payload payload
     * @return result
     */
    private TwOutputUtil<Long> startWorkFlow(PmsRelatedHistoryPayload payload) {
        // 发起工作流程
        HashMap<String, Object> varMaps = new HashMap<>();
//        Assert.notNull(payload.getUserId(), "userId不能为空");
//        // 变更资源审批
//        varMaps.put("Activity_111kevq", payload.getUserId());
        //发起流程审批
//        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
//                HrBaseEnum.BASE_BU_CHANGE.getCode(),
//                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
//                res.getId().toString(), varMaps));
//        String procInstId = processInfo.getProcInstId();
//        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        String procInstId = "";
        // 回写单据的工作流信息
//        payload.setProcInstId(procInstId);
//        payload.setProcInstStatus("");
        Long update = dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsRelatedHistoryPayload payload) {
    }

    /**
     * todo
     * @param vos vos
     */
    private void translate(List<PmsRelatedHistoryVO> vos){
        vos.forEach(vo -> {
            // todo 翻译vo对象
//            vo.setUserIdDesc("");
        });
    }

}