package com.elitesland.tw.tw5.server.prd.personplan.service.inter;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ResourceCostStrategyPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.ResourceCostStrategyQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ResourceCostStrategyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import java.util.List;


/**
 * 资源成本策略service
 * @author wangxl
 * @date 2024/4/2
 */
public interface ResourceCostStrategyService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<PagingVO<ResourceCostStrategyVO>> queryPage(ResourceCostStrategyQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<List<ResourceCostStrategyVO>> queryList(ResourceCostStrategyQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<Long> queryCount(ResourceCostStrategyQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    TwOutputUtil<ResourceCostStrategyVO> queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<ResourceCostStrategyVO> insert(ResourceCostStrategyPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<ResourceCostStrategyVO> update(ResourceCostStrategyPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<ResourceCostStrategyVO> updateDynamic(ResourceCostStrategyPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    TwOutputUtil<Long> deleteSoft(List<Long> ids);

}