package com.elitesland.tw.tw5.server.prd.pms.budget.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetReleasePayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetReleaseQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetReleaseService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetReleaseVO;
import com.elitesland.tw.tw5.server.common.Consts;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 项目/预算/预算释放表
 * @author duwh
 * @date 2024/3/7
*/
@RestController
@RequestMapping(Consts.URI_PREFIX + "/wbsBudgetRelease")
@RequiredArgsConstructor
@Slf4j
@Api(value = "预算释放表", tags = {"预算释放表"})
public class PmsWbsBudgetReleaseController {

    private final PmsWbsBudgetReleaseService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsWbsBudgetReleaseVO>> page(PmsWbsBudgetReleaseQuery query) {
        PagingVO<PmsWbsBudgetReleaseVO> pagingVO = service.queryPage(query);
        return TwOutputUtil.ok(pagingVO);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsWbsBudgetReleaseVO>> list(PmsWbsBudgetReleaseQuery query) {
        List<PmsWbsBudgetReleaseVO> voList = service.queryList(query);
        return TwOutputUtil.ok(voList);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsWbsBudgetReleaseVO> queryByKey(Long id) {
        PmsWbsBudgetReleaseVO vo = service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsWbsBudgetReleaseVO> insert(@RequestBody PmsWbsBudgetReleasePayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetReleaseController.insert】入参："+payload.toString());
        PmsWbsBudgetReleaseVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PmsWbsBudgetReleaseVO> update(@RequestBody PmsWbsBudgetReleasePayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetReleaseController.update】入参："+payload.toString());
        PmsWbsBudgetReleaseVO vo = service.update(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("局部修改-计算值")
    @PostMapping("/updatePro")
    public TwOutputUtil<PmsWbsBudgetReleaseVO> updatePro(@RequestBody PmsWbsBudgetReleasePayload payload) {
        PmsWbsBudgetReleaseVO vo = service.updatePro(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsWbsBudgetReleaseVO> updateDynamic(@RequestBody PmsWbsBudgetReleasePayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetReleaseController.updateDynamic】入参："+payload.toString());
        PmsWbsBudgetReleaseVO vo = service.updateDynamic(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsWbsBudgetReleaseController.deleteSoft】入参："+ids);
        Long res = service.deleteSoft(ids);
        return TwOutputUtil.ok(res);
    }
}
