package com.elitesland.tw.tw5.server.prd.pms.budget.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetVersionQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetVersionService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVersionVO;
import com.elitesland.tw.tw5.server.common.Consts;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 项目/预算/预算版本表
 *
 * @author duwh
 * @date 2024/3/7
 */
@RestController
@RequestMapping(Consts.URI_PREFIX + "/wbsBudgetVersion")
@RequiredArgsConstructor
@Slf4j
@Api(value = "预算版本表", tags = {"预算版本表"})
public class PmsWbsBudgetVersionController {

    private final PmsWbsBudgetVersionService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsWbsBudgetVersionVO>> page(PmsWbsBudgetVersionQuery query) {
        PagingVO<PmsWbsBudgetVersionVO> pagingVO = service.queryPage(query);
        return TwOutputUtil.ok(pagingVO);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsWbsBudgetVersionVO>> list(PmsWbsBudgetVersionQuery query) {
        List<PmsWbsBudgetVersionVO> voList = service.queryList(query);
        return TwOutputUtil.ok(voList);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsWbsBudgetVersionVO> queryByKey(Long id) {
        PmsWbsBudgetVersionVO vo = service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("获取预算版本")
    @GetMapping("/getVersion")
    public TwOutputUtil<PmsWbsBudgetVersionVO> getVersion(Long proId) {
        PmsWbsBudgetVersionVO vo = service.getVersion(proId, null);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsWbsBudgetVersionVO> insert(@RequestBody PmsWbsBudgetVersionPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetVersionController.insert】入参：" + payload.toString());
        PmsWbsBudgetVersionVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PmsWbsBudgetVersionVO> update(@RequestBody PmsWbsBudgetVersionPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetVersionController.update】入参：" + payload.toString());
        PmsWbsBudgetVersionVO vo = service.update(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsWbsBudgetVersionVO> updateDynamic(@RequestBody PmsWbsBudgetVersionPayload payload) {
        // 关键日志打印
        log.debug("【PmsWbsBudgetVersionController.updateDynamic】入参：" + payload.toString());
        PmsWbsBudgetVersionVO vo = service.updateDynamic(payload);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsWbsBudgetVersionController.deleteSoft】入参：" + ids);
        Long res = service.deleteSoft(ids);
        return TwOutputUtil.ok(res);
    }
}
