package com.elitesland.tw.tw5.server.prd.pms.budget.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetReleasePayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetReleaseQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetReleaseVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.budget.convert.PmsWbsBudgetReleaseConvert;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.repo.PmsWbsBudgetReleaseRepo;
import com.elitesland.tw.tw5.server.prd.pms.budget.model.entity.PmsWbsBudgetReleaseDO;
import com.elitesland.tw.tw5.server.prd.pms.budget.model.entity.QPmsWbsBudgetReleaseDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.List;


/**
 * 预算释放表dao
 *
 * @author duwh
 * @date 2024/3/7
 */
@RequiredArgsConstructor
@Component
public class PmsWbsBudgetReleaseDao {

    private static final QPmsWbsBudgetReleaseDO qdo = QPmsWbsBudgetReleaseDO.pmsWbsBudgetReleaseDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsWbsBudgetReleaseRepo repo;
    private final QPmsProjectWbsDO qPmsProjectWbsDO = QPmsProjectWbsDO.pmsProjectWbsDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsWbsBudgetReleaseVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsWbsBudgetReleaseVO.class,

                qPmsProjectWbsDO.wbsName,
                qPmsProjectWbsDO.wbsCode,

                qdo.id,
                qdo.tenantId,
                qdo.belongOrgId,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.tenantOrgId,
                qdo.remark,
                qdo.deleteFlag,
                qdo.wbsId,
                qdo.versionId,
                qdo.effRelateId,
                qdo.allocatedResAmtBefore,
                qdo.settledResAmtBefore,
                qdo.occupiedResAmtBefore,
                qdo.remainingResAmtBefore,
                qdo.allocatedResAmtAfter,
                qdo.settledResAmtAfter,
                qdo.occupiedResAmtAfter,
                qdo.remainingResAmtAfter,
                qdo.changeResAmt,
                qdo.confirmSettledRes,
                qdo.proId
            )).from(qdo)
            .leftJoin(qPmsProjectWbsDO).on(qdo.wbsId.eq(qPmsProjectWbsDO.id))
            ;
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<Long> getJpaQuerySelectCount() {
        return jpaQueryFactory.select(qdo.id.count()).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     */
    private void jpaQueryWhere(JPAQuery<?> jpaQuery, PmsWbsBudgetReleaseQuery query) {
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.eq(query.getRemark()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsId())) {
            jpaQuery.where(qdo.wbsId.eq(query.getWbsId()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionId())) {
            jpaQuery.where(qdo.versionId.eq(query.getVersionId()));
        }
        if (!ObjectUtils.isEmpty(query.getEffRelateId())) {
            jpaQuery.where(qdo.effRelateId.eq(query.getEffRelateId()));
        }
        if (!ObjectUtils.isEmpty(query.getAllocatedResAmtBefore())) {
            jpaQuery.where(qdo.allocatedResAmtBefore.eq(query.getAllocatedResAmtBefore()));
        }
        if (!ObjectUtils.isEmpty(query.getSettledResAmtBefore())) {
            jpaQuery.where(qdo.settledResAmtBefore.eq(query.getSettledResAmtBefore()));
        }
        if (!ObjectUtils.isEmpty(query.getOccupiedResAmtBefore())) {
            jpaQuery.where(qdo.occupiedResAmtBefore.eq(query.getOccupiedResAmtBefore()));
        }
        if (!ObjectUtils.isEmpty(query.getRemainingResAmtBefore())) {
            jpaQuery.where(qdo.remainingResAmtBefore.eq(query.getRemainingResAmtBefore()));
        }
        if (!ObjectUtils.isEmpty(query.getAllocatedResAmtAfter())) {
            jpaQuery.where(qdo.allocatedResAmtAfter.eq(query.getAllocatedResAmtAfter()));
        }
        if (!ObjectUtils.isEmpty(query.getSettledResAmtAfter())) {
            jpaQuery.where(qdo.settledResAmtAfter.eq(query.getSettledResAmtAfter()));
        }
        if (!ObjectUtils.isEmpty(query.getOccupiedResAmtAfter())) {
            jpaQuery.where(qdo.occupiedResAmtAfter.eq(query.getOccupiedResAmtAfter()));
        }
        if (!ObjectUtils.isEmpty(query.getRemainingResAmtAfter())) {
            jpaQuery.where(qdo.remainingResAmtAfter.eq(query.getRemainingResAmtAfter()));
        }
        if (!ObjectUtils.isEmpty(query.getChangeResAmt())) {
            jpaQuery.where(qdo.changeResAmt.eq(query.getChangeResAmt()));
        }
        if (!ObjectUtils.isEmpty(query.getConfirmSettledRes())) {
            jpaQuery.where(qdo.confirmSettledRes.eq(query.getConfirmSettledRes()));
        }
        if (!ObjectUtils.isEmpty(query.getProId())) {
            jpaQuery.where(qdo.proId.eq(query.getProId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return result
     */
    public PagingVO<PmsWbsBudgetReleaseVO> queryPage(PmsWbsBudgetReleaseQuery query) {
        // 查询总行数total
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long nullAbleCount = jpaQuerySelectCount.fetchOne();
        long count = nullAbleCount == null ? 0 : nullAbleCount;
        // 如果总行数为0则直接返回
        if (count == 0) {
            return PagingVO.<PmsWbsBudgetReleaseVO>builder()
                .total(count)
                .records(Collections.emptyList())
                .build();
        }
        JPAQuery<PmsWbsBudgetReleaseVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        SqlUtil.handlePage(jpaQuerySelect, query);
        jpaQuerySelect.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize());
        return PagingVO.<PmsWbsBudgetReleaseVO>builder()
            .total(count)
            .records(jpaQuerySelect.fetch())
            .build();
    }

    /**
     * 查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsWbsBudgetReleaseVO> queryList(PmsWbsBudgetReleaseQuery query) {
        JPAQuery<PmsWbsBudgetReleaseVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询count
     *
     * @param query 查询参数
     * @return count
     */
    public long queryCount(PmsWbsBudgetReleaseQuery query) {
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long count = jpaQuerySelectCount.fetchOne();
        return count == null ? 0 : count;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsWbsBudgetReleaseVO queryByKey(Long id) {
        JPAQuery<PmsWbsBudgetReleaseVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 调用jpa的保存
     *
     * @param payload payload
     * @return 保存后的对象
     */
    public PmsWbsBudgetReleaseVO save(PmsWbsBudgetReleasePayload payload) {
        PmsWbsBudgetReleaseDO ado = PmsWbsBudgetReleaseConvert.INSTANCE.toEntity(payload);
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(ado);
        repo.save(ado);
        return PmsWbsBudgetReleaseConvert.INSTANCE.toVO(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsWbsBudgetReleaseDO> saveAll(List<PmsWbsBudgetReleaseDO> dos) {
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(dos);
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PmsWbsBudgetReleasePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .where(qdo.id.eq(payload.getId()));
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getWbsId() != null) {
            update.set(qdo.wbsId, payload.getWbsId());
        }
        if (payload.getVersionId() != null) {
            update.set(qdo.versionId, payload.getVersionId());
        }
        if (payload.getEffRelateId() != null) {
            update.set(qdo.effRelateId, payload.getEffRelateId());
        }
        if (payload.getAllocatedResAmtBefore() != null) {
            update.set(qdo.allocatedResAmtBefore, payload.getAllocatedResAmtBefore());
        }
        if (payload.getSettledResAmtBefore() != null) {
            update.set(qdo.settledResAmtBefore, payload.getSettledResAmtBefore());
        }
        if (payload.getOccupiedResAmtBefore() != null) {
            update.set(qdo.occupiedResAmtBefore, payload.getOccupiedResAmtBefore());
        }
        if (payload.getRemainingResAmtBefore() != null) {
            update.set(qdo.remainingResAmtBefore, payload.getRemainingResAmtBefore());
        }
        if (payload.getAllocatedResAmtAfter() != null) {
            update.set(qdo.allocatedResAmtAfter, payload.getAllocatedResAmtAfter());
        }
        if (payload.getSettledResAmtAfter() != null) {
            update.set(qdo.settledResAmtAfter, payload.getSettledResAmtAfter());
        }
        if (payload.getOccupiedResAmtAfter() != null) {
            update.set(qdo.occupiedResAmtAfter, payload.getOccupiedResAmtAfter());
        }
        if (payload.getRemainingResAmtAfter() != null) {
            update.set(qdo.remainingResAmtAfter, payload.getRemainingResAmtAfter());
        }
        if (payload.getChangeResAmt() != null) {
            update.set(qdo.changeResAmt, payload.getChangeResAmt());
        }
        if (payload.getConfirmSettledRes() != null) {
            update.set(qdo.confirmSettledRes, payload.getConfirmSettledRes());
        }
        if (payload.getProId() != null) {
            update.set(qdo.proId, payload.getProId());
        }
        // 处理要设置成空的字段(nullField处理)
        SqlUtil.handleNullFieldsUpdate(payload, qdo, update);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        return update.execute();
    }

}
