package com.elitesland.tw.tw5.server.prd.pms.budget.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 预算主表DO
 * @author duwh
 * @date 2024-1-18
*/
@Entity
@Table(name = "pms_wbs_budget")
@org.hibernate.annotations.Table(appliesTo = "pms_wbs_budget", comment = "预算主表")
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PmsWbsBudgetDO extends BaseModel {

    @Comment("项目id")
    @Column
    private Long proId;

    @Comment("预算名称")
    @Column
    private String objectName;

    @Comment("预算编号")
    @Column
    private String objectNo;

    @Comment("单据状态 新建CREATE 审批中 APPROVING 激活 ACTIVE")
    @Column
    private String objectStatus;

    @Comment("版本 id")
    @Column
    private Long versionId;

    @Comment("版本号")
    @Column
    private Integer versionNo;

    @Comment("资源总预算")
    @Column
    private BigDecimal totalResAmt;

    @Comment("已结算资源预算")
    @Column
    private BigDecimal totalSettledResAmt;

    @Comment("已占用资源预算")
    @Column
    private BigDecimal totalOccupiedResAmt;

    @Comment("剩余资源预算（含待分配）")
    @Column
    private BigDecimal totalRemainingResAmt;

    @Comment("费用总预算")
    @Column
    private BigDecimal totalFeeAmt;

    @Comment("已结算费用预算")
    @Column
    private BigDecimal totalSettledFeeAmt;

    @Comment("已占用费用预算")
    @Column
    private BigDecimal totalOccupiedFeeAmt;

    @Comment("剩余费用预算（含待分配）")
    @Column
    private BigDecimal totalRemainingFeeAmt;

    @Comment("有效关联id")
    @Column
    private Long effRelateId;

    @Comment("流程实例ID")
    @Column
    private String procInstId;

    @Comment("流程审批状态")
    @Column
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column
    private LocalDateTime approvedTime;

    @Comment("拓展字段1")
    @Column
    private String extString1;

    @Comment("拓展字段2")
    @Column
    private String extString2;

    @Comment("拓展字段3")
    @Column
    private String extString3;

    @Comment("拓展字段4")
    @Column
    private String extString4;

    @Comment("拓展字段5")
    @Column
    private String extString5;

}
