package com.elitesland.tw.tw5.server.prd.pms.budget.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetVersionQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetVersionService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVersionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.budget.constants.BudgetVersionStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.PmsWbsBudgetVersionDao;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;


/**
 * 预算版本表service impl
 *
 * @author duwh
 * @date 2024/3/7
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class PmsWbsBudgetVersionServiceImpl implements PmsWbsBudgetVersionService {

    private final PmsWbsBudgetVersionDao dao;

    @Override
    public PmsWbsBudgetVersionVO getVersion(Long proId, String objStatus) {
        // 查询新建状态-> 激活状态的最新一条
        PmsWbsBudgetVersionVO pmsWbsVersionVO = dao.getVersion(proId, objStatus);
        if (null != pmsWbsVersionVO) {
            return pmsWbsVersionVO;
        } else {
            if (StringUtils.hasText(objStatus)) {
                return null;
            }
            // 没有则新建一条V0版本
            PmsWbsBudgetVersionPayload payload = new PmsWbsBudgetVersionPayload();
            payload.setProId(proId);
            payload.setObjectStatus(BudgetVersionStatusEnum.CREATE.getCode());
            payload.setStepNum(3);
            payload.setVersionNo(0);
            PmsWbsBudgetVersionVO save = dao.save(payload);
            return save;
        }
    }

    @Override
    public PagingVO<PmsWbsBudgetVersionVO> queryPage(PmsWbsBudgetVersionQuery query) {
        PagingVO<PmsWbsBudgetVersionVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return pageVO;
    }

    @Override
    public List<PmsWbsBudgetVersionVO> queryList(PmsWbsBudgetVersionQuery query) {
        List<PmsWbsBudgetVersionVO> listVO = dao.queryList(query);
        translate(listVO);
        return listVO;
    }

    @Override
    public long queryCount(PmsWbsBudgetVersionQuery query) {
        return dao.queryCount(query);
    }

    @Override
    public PmsWbsBudgetVersionVO queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsWbsBudgetVersionVO vo = dao.queryByKey(id);
        Assert.notNull(vo, "查询的版本数据不存在");
        translate(List.of(vo));
        return vo;
    }

    @Override
    public PmsWbsBudgetVersionVO queryByProjectIdAndVersionNo(Long projectId, int versionNo) {
        PmsWbsBudgetVersionVO pmsWbsBudgetVersionVO = dao.queryByProjectIdAndVersionNo(projectId, versionNo);
        Assert.notNull(pmsWbsBudgetVersionVO, "查询的版本数据不存在");
        return pmsWbsBudgetVersionVO;
    }

    @Override
    @Transactional
    public PmsWbsBudgetVersionVO insert(PmsWbsBudgetVersionPayload payload) {
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsWbsBudgetVersionVO save = dao.save(payload);
        // todo 开启工作流
        // startWorkFlow(ado);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public PmsWbsBudgetVersionVO update(PmsWbsBudgetVersionPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PmsWbsBudgetVersionVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public PmsWbsBudgetVersionVO updateDynamic(PmsWbsBudgetVersionPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public Long deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        return dao.deleteSoft(ids);
    }

    @Override
    public PmsWbsBudgetVersionVO getProIdAndVersionNo(Long proId, int lastVersionNo) {
        Assert.notNull(proId, "proId不能为空");
        Assert.notNull(lastVersionNo, "versionNo不能为空");

        PmsWbsBudgetVersionVO vo = dao.getProIdAndVersionNo(proId, lastVersionNo);
        Assert.notNull(vo, "查询的版本数据不存在");
        translate(List.of(vo));
        return vo;
    }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PmsWbsBudgetVersionPayload payload) {
    }

    /**
     * todo
     *
     * @param vos vos
     */
    private void translate(List<PmsWbsBudgetVersionVO> vos) {
        vos.forEach(vo -> {
            // todo 翻译vo对象
//            vo.setUserIdDesc("");
        });
    }

}
