package com.elitesland.tw.tw5.server.prd.pms.common.functionEnum;

import lombok.Getter;

/**
 * 拨付状态  wbs新 PMS:ACTIVITY:ALLOCATESTATUS
 * READY
 * ING
 * OK
 * NO
 *
 * @author duwh
 * @date 2021/12/23
 */
public enum ProjWbsAllocateStateEnum {

    READY("READY", "待拨付"),
    ING("ING", "拨付审批中"),
    OK("OK", "拨付审批通过"),
    NO("NO", "拨付审批拒绝");

    @Getter
    private String code;

    @Getter
    private String desc;

    ProjWbsAllocateStateEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDesc(String type) {
        ProjWbsAllocateStateEnum[] twRelatedDocTypeEnum = values();
        for (ProjWbsAllocateStateEnum docType : twRelatedDocTypeEnum) {
            if (docType.getCode().equalsIgnoreCase(type)) {
                return docType.getDesc();
            }
        }
        return null;
    }
}
