package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSetDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSetQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectSetService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 项目集管理
 *
 * @author carl
 * @date 2023-07-03
 */
@Api(tags = "项目集管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectSet")
@Slf4j
public class PmsProjectSetController {

    private final PmsProjectSetService pmsProjectSetService;

    /**
     * 项目集管理-新增或编辑
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目集管理-新增或编辑")
    public TwOutputUtil<PmsProjectSetVO> insertOrUpdate(@RequestBody PmsProjectSetDataPayload payload) {
        return TwOutputUtil.ok(pmsProjectSetService.insertOrUpdate(payload));
    }


    /**
     * 项目集管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("项目集管理-查询列表")
    public TwOutputUtil<List<PmsProjectSetVO>> queryList(PmsProjectSetQuery query) {
        return TwOutputUtil.ok(pmsProjectSetService.queryListDynamic(query));
    }

    /**
     * 项目集关联项目-分页查询
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryRelationProject")
    @ApiOperation("分页查询项目集关联项目")
    public TwOutputUtil queryRelationProject(PmsProjectSetQuery query) {
        return TwOutputUtil.ok(pmsProjectSetService.queryRelationProjectPaging(query));
    }

    /**
     * 项目集关联项目--列表不分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryRelationProjectList")
    @ApiOperation("查询项目集关联项目")
    public TwOutputUtil queryRelationProjectList(PmsProjectSetQuery query) {
        return TwOutputUtil.ok(pmsProjectSetService.queryRelationProjectList(query));
    }

    /**
     * 提供选择项查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/querySelectList")
    // @UdcNameClass
    @ApiOperation("提供选择项列表查询")
    public TwOutputUtil<List<PmsProjectSetVO>> querySelectList(PmsProjectSetQuery query) {
        return TwOutputUtil.ok(pmsProjectSetService.querySelectList(query));
    }

    /**
     * 项目维度查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryListToProject")
    // @UdcNameClass
    @ApiOperation("项目维度列表查询")
    public TwOutputUtil<List<PmsProjectSetVO>> queryListToProject(PmsProjectQuery query) {
        return TwOutputUtil.ok(pmsProjectSetService.queryListToProject(query));
    }


    /**
     * 项目集管理-  更改项目集信息码
     * @param id
     * @param setCode
     * @return
     */
    @GetMapping("/udateSetCode")
    @ApiOperation("项目集管理-更改项目集信息码")
    public TwOutputUtil udateSetCode(Long id,String setCode) {
        pmsProjectSetService.udateSetCode(id,setCode);
        return TwOutputUtil.ok();
    }

//
//    /**
//     * 项目集管理-删除
//     *
//     * @param keys 主键id
//     * @return result
//     */
//    @DeleteMapping("/deleteSoft")
//    @ApiOperation("项目集管理-删除")
//    public TwOutputUtil deleteSoft(Long[] keys) {
//        pmsProjectSetService.deleteSoft(Arrays.asList(keys));
//        return TwOutputUtil.ok();
//    }
//
//    /**
//     * 项目集管理-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("项目集管理-更新")
//    public TwOutputUtil<PmsProjectSetVO> update(@RequestBody PmsProjectSetPayload payload) {
//        return TwOutputUtil.ok(pmsProjectSetService.update(payload));
//    }
//
//    /**
//     * 项目集管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("项目集管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsProjectSetPayload payload) {
//        return TwOutputUtil.ok(pmsProjectSetService.updateByKeyDynamic(payload));
//    }
//
//
//    /**
//     * 项目集管理-主键查询
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("项目集管理-主键查询")
//    public TwOutputUtil<PmsProjectSetVO> queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(pmsProjectSetService.queryByKey(key));
//    }


}
