package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.pms.payload.*;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsLogQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsSnapshotQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsSnapshotVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 项目wbs表
 *
 * @author carl
 * @date 2023-04-06
 */
@Api(tags = "项目wbs表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/pmsProjectWbs")
@Slf4j
public class PmsProjectWbsController {

    private final PmsProjectWbsService pmsProjectWbsService;

    private final ProRelatedPartiesService proRelatedPartiesService;

    private final PmsDeliverItemService pmsDeliverItemService;

    /**
     * 批量新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("批量新增或修改")
    public TwOutputUtil batchInsertOrUpdate(@RequestBody PmsProjectWbsDataPayload payload) {
        return TwOutputUtil.ok(pmsProjectWbsService.batchInsertOrUpdate(payload));
    }


    @PostMapping("updateState")
    @ApiOperation("修改wbs状态")
    public TwOutputUtil updateState(@RequestBody PmsProjectWbsPayload payload) {
        return TwOutputUtil.ok(pmsProjectWbsService.updateState(payload));
    }


    @PostMapping("submit")
    @ApiOperation("提交")
    public TwOutputUtil submit(@RequestBody List<Long> wbsId) {

        List<PmsProjectWbsVO> pmsProjectWbsVOList = pmsProjectWbsService.submitVer(wbsId);

        // 生成下一版本数据（异步）
//        if (CollUtil.isNotEmpty(pmsProjectWbsVOList)) {
//            pmsProjectWbsService.createNextVersion(pmsProjectWbsVOList);
//        }

        return TwOutputUtil.ok(pmsProjectWbsVOList);
    }

    @PostMapping("submitPro")
    @ApiOperation("提交")
    public TwOutputUtil<PmsProjectWbsVO> submitPro(@RequestBody PmsProjectWbsSubmitDataPayload payload) {

        List<PmsProjectWbsVO> pmsProjectWbsVOList = pmsProjectWbsService.submitVerPro(payload);

        // 生成下一版本数据（异步）
//        if (CollUtil.isNotEmpty(pmsProjectWbsVOList)) {
//            pmsProjectWbsService.createNextVersion(pmsProjectWbsVOList);
//        }

        return TwOutputUtil.ok(pmsProjectWbsVOList);
    }

    @PostMapping("savePro")
    @ApiOperation("保存")
    public TwOutputUtil savePro(@RequestBody PmsProjectWbsSubmitDataPayload payload) {
        pmsProjectWbsService.savePro(payload);
        return TwOutputUtil.ok();
    }


    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil<PmsProjectWbsVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsProjectWbsService.queryByKey(key));
    }


    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil<PmsProjectWbsVO> queryList(PmsProjectWbsQuery query) {
        return TwOutputUtil.ok(pmsProjectWbsService.queryList(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectWbsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 查询日志列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryLogList")
    @ApiOperation("查询日志列表")
    public TwOutputUtil<ComLogVO> queryLogList(PmsProjectWbsLogQuery query) {
        return TwOutputUtil.ok(pmsProjectWbsService.queryLogList(query));
    }

    /**
     * 新增快照
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/insertSnapshot")
    @ApiOperation("新增快照")
    public TwOutputUtil<PmsProjectWbsSnapshotVO> insertSnapshot(@RequestBody PmsProjectWbsSnapshotPayload payload) {
        return TwOutputUtil.ok(pmsProjectWbsService.insertSnapshot(payload));
    }

    /**
     * 查询快照列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/querySnapshotList")
    @ApiOperation("查询快照列表")
    public TwOutputUtil<List<PmsProjectWbsSnapshotVO>> querySnapshotList(PmsProjectWbsSnapshotQuery query) {
        return TwOutputUtil.ok(pmsProjectWbsService.querySnapshotList(query));
    }

    /**
     * 删除快照
     *
     * @param snapshotKeys 快照主键id
     * @return result
     */
    @DeleteMapping("/deleteSoftSnapshot")
    @ApiOperation("删除快照")
    public TwOutputUtil deleteSoftSnapshot(Long[] snapshotKeys) {
        pmsProjectWbsService.deleteSoftSnapshot(Arrays.asList(snapshotKeys));
        return TwOutputUtil.ok();
    }

    /**
     * 自动排期
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/autoScheduling")
    @ApiOperation("自动排期")
    public TwOutputUtil autoScheduling(@RequestBody PmsProjectWbsSchedulingPayload payload) {
        pmsProjectWbsService.autoScheduling(payload);
        return TwOutputUtil.ok();
    }


    /**
     * 获取项目进度
     */
    @GetMapping("/getProjectProgress")
    @ApiOperation("获取项目进度")
    public TwOutputUtil getProjectProgress(Long projectId) {
        return TwOutputUtil.ok(pmsProjectWbsService.getProjectProgress(projectId));
    }

    @GetMapping("checkDate")
    @ApiOperation("必要项检查1相关方数据2交付清单数据 true为通过")
    public TwOutputUtil checkDate(Long proId) {
        Map<String, Boolean> res = new HashMap<>();

        ProRelatedPartiesQuery partiesQuery = new ProRelatedPartiesQuery();
        partiesQuery.setProId(proId);
        Long count1 = proRelatedPartiesService.count(partiesQuery);

        res.put("1", count1 > 0);
        // 交付清单
        PmsDeliverItemQuery pmsDeliverItemQuery = new PmsDeliverItemQuery();
        pmsDeliverItemQuery.setProjectId(proId);
        pmsDeliverItemQuery.setShowFlag(true);
        Long count2 = pmsDeliverItemService.count(pmsDeliverItemQuery);
        res.put("2", count2 > 0);
        return TwOutputUtil.ok(res);

    }

    /**
     * 查询里程碑列表
     */
    @GetMapping("/listMilestone")
    @ApiOperation("项目里程碑列表")
    public TwOutputUtil<List<PmsProjectWbsVO>> listMilestone(PmsProjectWbsQuery query) {
        List<PmsProjectWbsVO> list = pmsProjectWbsService.listMilestone(query);
        return TwOutputUtil.ok(list);
    }

    /**
     * wbs阶段列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}<{@link List}<{@link PmsProjectWbsVO}>>
     */
    @GetMapping("/listStage")
    @ApiOperation("Wbs阶段列表")
    public TwOutputUtil<List<PmsProjectWbsVO>> listStage(PmsProjectWbsQuery query) {
        List<PmsProjectWbsVO> list = pmsProjectWbsService.listStage(query);
        return TwOutputUtil.ok(list);
    }


    @GetMapping("/checkStep2")
    @ApiOperation("Wbs校验第二步列表")
    public TwOutputUtil checkStep2(PmsProjectWbsQuery query) {

        pmsProjectWbsService.checkStep2(query);
        return TwOutputUtil.ok(true);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/batchImport/{projectId}", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImport(MultipartFile file, @PathVariable Long projectId) {
        return TwOutputUtil.ok(pmsProjectWbsService.importElecPlanTask(file, projectId));
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @PostMapping("/batchExport")
    public void batchExport(HttpServletResponse response, @RequestBody PmsProjectWbsQuery query) {
        pmsProjectWbsService.exportElecPlanTask(response, query);
    }
}
