package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsRelyQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsRelyService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsRelyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 项目/计划/依赖关系
 *
 * @author carl
 * @date 2023-07-19
 */
@Api(tags = "项目/计划/依赖关系")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/pmsProjectWbsRely")
@Slf4j
public class PmsProjectWbsRelyController {

    private final PmsProjectWbsRelyService pmsProjectWbsRelyService;

    /**
     * 项目wbs前置依赖关系-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目wbs前置依赖关系-新增")
    public TwOutputUtil<PmsProjectWbsRelyVO> insert(@RequestBody PmsProjectWbsRelyDataPayload payload) {
        pmsProjectWbsRelyService.batchInsert(payload);
        return TwOutputUtil.ok();
    }


    /**
     * 项目wbs前置依赖关系-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("项目wbs前置依赖关系-查询列表")
    public TwOutputUtil<List<PmsProjectWbsRelyVO>> queryList(PmsProjectWbsRelyQuery query) {
        return TwOutputUtil.ok(pmsProjectWbsRelyService.queryListDynamic(query));
    }

    @GetMapping("/listPro")
    @ApiOperation("项目wbs前置依赖关系-查询列表")
    public TwOutputUtil<List<PmsProjectWbsRelyVO>> listPro(PmsProjectWbsRelyQuery query) {
        return TwOutputUtil.ok(pmsProjectWbsRelyService.listLeftJoinWbs(query));
    }

    /**
     * 项目wbs前置依赖关系-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("项目wbs前置依赖关系-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectWbsRelyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
