package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsResourcePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsResourceQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsResourceService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsResourceVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-26
 * @desc : 项目wbs资源分配
 */
@RestController
@RequestMapping("/api/pmsProjectWbsResource")
@RequiredArgsConstructor
@Api(value = "项目wbs资源分配", tags = {"项目wbs资源分配"})
public class PmsProjectWbsResourceController {

    private final PmsProjectWbsResourceService pmsProjectWbsResourceService;


    @PostMapping
    @ApiOperation("新增-项目wbs资源分配")
    public TwOutputUtil<Boolean> save(@RequestBody List<PmsProjectWbsResourcePayload> pmsProjectWbsResourcePayload) {

        Boolean res = pmsProjectWbsResourceService.saveAll(pmsProjectWbsResourcePayload);
        return TwOutputUtil.ok(res);

    }


    @PutMapping
    @ApiOperation("修改-项目wbs资源分配")
    public TwOutputUtil<Long> update(@RequestBody PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {

        Long res = pmsProjectWbsResourceService.update(pmsProjectWbsResourcePayload);
        return TwOutputUtil.ok(res);

    }


    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除-项目wbs资源分配")
    public TwOutputUtil<Long> del(Long[] keys) {

        Long res = pmsProjectWbsResourceService.del(Arrays.asList(keys));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页查询-项目wbs资源分配")
    public TwOutputUtil<PagingVO<PmsProjectWbsResourceVO>> page(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {

        PagingVO<PmsProjectWbsResourceVO> res = pmsProjectWbsResourceService.page(pmsProjectWbsResourceQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/{key}")
    @ApiOperation("详情-项目wbs资源分配")
    public TwOutputUtil<PmsProjectWbsResourceVO> get(@PathVariable Long id) {

        PmsProjectWbsResourceVO res = pmsProjectWbsResourceService.get(id);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("/list")
    @ApiOperation("列表查询-项目wbs资源分配")
    public TwOutputUtil<List<PmsProjectWbsResourceVO>> getList(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {

        List<PmsProjectWbsResourceVO> res = pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
        return TwOutputUtil.ok(res);

    }


}

