package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsTemplateNodePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsWbsTemplateNodeQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsWbsTemplateNodeService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * wbs模板节点
 *
 * @author Echo
 * @date 2023-03-29
 */
@Api(tags = "wbs模板节点")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsWbsTemplateNode")
@Slf4j
public class PmsWbsTemplateNodeController {

    private final PmsWbsTemplateNodeService pmsWbsTemplateNodeService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody PmsWbsTemplateNodePayload payload){
        return TwOutputUtil.ok(pmsWbsTemplateNodeService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody PmsWbsTemplateNodePayload payload){
        return TwOutputUtil.ok(pmsWbsTemplateNodeService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsWbsTemplateNodeService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(PmsWbsTemplateNodeQuery query) {
        return TwOutputUtil.ok(pmsWbsTemplateNodeService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(PmsWbsTemplateNodeQuery query) {
        return TwOutputUtil.ok(pmsWbsTemplateNodeService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsWbsTemplateNodeService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
