package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSetPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSetQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetRelationVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectSetDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectSetDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectSetRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目集管理
 *
 * @author carl
 * @date 2023-07-03
 */
@Repository
@RequiredArgsConstructor
public class PmsProjectSetDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectSetRepo repo;
    private final QPmsProjectSetDO qdo = QPmsProjectSetDO.pmsProjectSetDO;
    private final QPmsProjectDO qdoProject = QPmsProjectDO.pmsProjectDO;
    // private final QPmsProjectWbsDO qdoProjectWbs = QPmsProjectWbsDO.pmsProjectWbsDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectSetVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectSetVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 项目数量
                qdoProject.id.count().as("projectCount"),
                qdo.parentId,
                // 项目集名称
                qdo.setName,
                // 项目集信息码
                qdo.setCode,
                // 项目集信息父节点码
                qdo.parentSetCode,
                // node码
                qdo.nodeCode,
                // 负责人id
                qdo.managerUserId
        )).from(qdo).leftJoin(qdoProject).on(qdo.id.eq(qdoProject.projectSetId).and(qdoProject.deleteFlag.eq(0)));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectSetVO> getJpaQueryWhere(PmsProjectSetQuery query) {
        JPAQuery<PmsProjectSetVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序 按照setCode排序
        List<OrderItem> orders = new ArrayList<>();
        OrderItem item = new OrderItem();
        item.setColumn("setCode");
        orders.add(item);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orders));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery;
    }


    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsProjectSetQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 父主键 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            list.add(qdo.parentId.eq(query.getParentId()));
        }
        /** 项目集名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getSetName())) {
            list.add(qdo.setName.like(SqlUtil.toSqlLikeString(query.getSetName())));
        }
        /** 项目集名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getSetSearch())) {
            list.add(qdo.setName.like(SqlUtil.toSqlLikeString(query.getSetSearch())).or(qdo.nodeCode.like(SqlUtil.toSqlLikeString(query.getSetSearch()))));
        }
        /** 项目集信息码 模糊 */
        if (!ObjectUtils.isEmpty(query.getSetCode())) {
            list.add(qdo.setCode.like(SqlUtil.toSqlLikeString(query.getSetCode())));
        }
        /** 项目集信息父节点码 模糊 */
        if (!ObjectUtils.isEmpty(query.getParentSetCode())) {
            list.add(qdo.parentSetCode.like(SqlUtil.toSqlLikeString(query.getParentSetCode())));
        }
        /** node码 模糊 */
        if (!ObjectUtils.isEmpty(query.getNodeCode())) {
            list.add(qdo.nodeCode.like(SqlUtil.toSqlLikeString(query.getNodeCode())));
        }
        /** 负责人id 精确 */
        if (!ObjectUtils.isEmpty(query.getManagerUserId())) {
            list.add(qdo.managerUserId.eq(query.getManagerUserId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsProjectSetVO queryByKey(Long id) {
        JPAQuery<PmsProjectSetVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectSetVO> queryListDynamic(PmsProjectSetQuery query) {
        JPAQuery<PmsProjectSetVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectSetVO> queryListToProject(PmsProjectQuery query) {
        Predicate predicate = whereToProject(query);
        JPAQuery<PmsProjectSetVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PmsProjectSetVO.class,
                        qdo.id,
                        qdo.parentId,
                        // 项目集名称
                        qdo.setName,
                        // 项目集信息码
                        qdo.setCode,
                        // 项目集信息父节点码
                        qdo.parentSetCode,
                        // node码
                        qdo.nodeCode,
                        // 负责人id
                        qdo.managerUserId,
                        // 项目数量
                        qdoProject.id.count().as("projectCount")
                )).from(qdo)
                .leftJoin(qdoProject).on(predicate);
        //.leftJoin(qdoProjectWbs).on(qdoProject.id.eq(qdoProjectWbs.projectId).and(qdoProject.deleteFlag.eq(0)));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);

//        if (query.getBySetManagerUserFlag()) {
//            List<Predicate> list = new ArrayList<>();
//            //只要是项目负责人 就可以看到 绑定了项目集的权限
//            list.add(qdo.managerUserId.eq(query.getLoginUserId()));
//            jpaQuery.where(ExpressionUtils.allOf(list));
//        }

        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery.fetch();
    }

//    /**
//     * 拼装查询字段
//     *
//     * @return jpaQuery对象
//     */
//    private JPAQuery<PmsProjectSetVO> getJpaQuerySelectToProject() {
//        return jpaQueryFactory.select(Projections.bean(PmsProjectSetVO.class,
//                        qdo.id,
//                        //qdo.remark,
//                        //qdo.createUserId,
//                        //qdo.creator,
//                        //qdo.createTime,
//                        //qdo.modifyUserId,
//                        //qdo.updater,
//                        //qdo.modifyTime,
//                        // 项目数量
//                        qdo.id.count().as("projectCount"),
//                        qdo.parentId,
//                        // 项目集名称
//                        qdo.setName,
//                        // 项目集信息码
//                        qdo.setCode,
//                        // 项目集信息父节点码
//                        qdo.parentSetCode,
//                        // node码
//                        qdo.nodeCode,
//                        // 负责人id
//                        qdo.managerUserId
//                )).from(qdo).leftJoin(qdoProject).on(qdo.id.eq(qdoProject.projectSetId).and(qdoProject.deleteFlag.eq(0)))
//                .leftJoin(qdoProjectWbs).on(qdoProject.id.eq(qdoProjectWbs.projectId).and(qdoProject.deleteFlag.eq(0)));
//    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate whereToProject(PmsProjectQuery query) {
        List<Predicate> list = new ArrayList<>();

        list.add(qdo.id.eq(qdoProject.projectSetId));
        list.add(qdoProject.deleteFlag.eq(0));

        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdoProject.id.eq(query.getId()));
        }
        /** 项目名称或编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getProjectNameOrCode())) {
            String s = SqlUtil.toSqlLikeString(query.getProjectNameOrCode());
            list.add(qdoProject.projName.like(s).or(qdoProject.projNo.like(s)));
        }
        /** 项目名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getProjName())) {
            list.add(qdoProject.projName.like(SqlUtil.toSqlLikeString(query.getProjName())));
        }
        /** 项目编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getProjNo())) {
            list.add(qdoProject.projNo.like(SqlUtil.toSqlLikeString(query.getProjNo())));
        }
        /** 客户id 精确 */
//        if (!ObjectUtils.isEmpty(query.getCustId())) {
//            list.add(qdoProject.custId.eq(query.getCustId()));
//        }
        /** 客户行业 精确 */
        if (!ObjectUtils.isEmpty(query.getCustIndustry())) {
            list.add(qdoProject.custIdst.eq(query.getCustIndustry()));
        }
        /** 客户区域 精确 */
        if (!ObjectUtils.isEmpty(query.getCustArea())) {
            list.add(qdoProject.custRegion.eq(query.getCustArea()));
        }
        /** 交付地点 精确 */
//        if (!ObjectUtils.isEmpty(query.getPaySite())) {
//            list.add(qdoProject.paySite.eq(query.getPaySite()));
//        }
//        /** 项目类型 精确 */
//        if (!ObjectUtils.isEmpty(query.getProjectType())) {
//            list.add(qdoProject.projectType.eq(query.getProjectType()));
//        }
//        /** 项目模板id 精确 */
//        if (!ObjectUtils.isEmpty(query.getTemplateId())) {
//            list.add(qdoProject.templateId.eq(query.getTemplateId()));
//        }
//        /** 项目难度 精确 */
//        if (!ObjectUtils.isEmpty(query.getProjectDifficulty())) {
//            list.add(qdoProject.projectDifficulty.eq(query.getProjectDifficulty()));
//        }
        /** 项目重要度 精确 */
        if (!ObjectUtils.isEmpty(query.getProjectImportance())) {
            list.add(qdoProject.projectImportance.eq(query.getProjectImportance()));
        }
//        /** 是否签订合同 精确 */
//        if (!ObjectUtils.isEmpty(query.getHaveContract())) {
//            list.add(qdoProject.haveContract.eq(query.getHaveContract()));
//        }
//        /** 合同附件 精确 */
//        if (!ObjectUtils.isEmpty(query.getContractFiles())) {
//            list.add(qdoProject.contractFiles.eq(query.getContractFiles()));
//        }
        BooleanExpression jpaQueryOr0 = null;

//        if (!ObjectUtils.isEmpty(query.getStartTime()) && !ObjectUtils.isEmpty(query.getEndTime())) {
//            jpaQueryOr0 = qdoProject.startTime.loe(query.getStartTime()).and(qdoProject.endTime.goe(query.getStartTime()));
//            //list.add(qdoProject.startTime.goe(query.getStartTime()));
//        }
//        if (!ObjectUtils.isEmpty(query.getEndTime())) {
//            if (jpaQueryOr0 != null) {
//                jpaQueryOr0 = jpaQueryOr0.or(qdoProject.startTime.loe(query.getEndTime()).and(qdoProject.endTime.goe(query.getEndTime())));
//            } else {
//                jpaQueryOr0 = qdoProject.startTime.loe(query.getEndTime()).and(qdoProject.endTime.goe(query.getEndTime()));
//            }
//            //list.add(qdoProject.endTime.loe(query.getEndTime()));
//        }
        if (jpaQueryOr0 != null) {
            list.add(jpaQueryOr0);
        }
        /** sow节选 精确 */
        if (!ObjectUtils.isEmpty(query.getSowFiles())) {
            list.add(qdoProject.sowFiles.eq(query.getSowFiles()));
        }
        /** 项目状态 精确 */
//        if (!ObjectUtils.isEmpty(query.getProjectStatus())) {
//            if (!ObjectUtils.isEmpty(query.getProjectStatusType()) && "1".equals(query.getProjectStatusType())) {
//                list.add(qdoProject.projectStatus.ne(query.getProjectStatus()));
//            } else {
//                list.add(qdoProject.projectStatus.eq(query.getProjectStatus()));
//            }
//        }
//        /** 项目经理 精确 */
//        if (!ObjectUtils.isEmpty(query.getManagerUserId())) {
//            list.add(qdoProject.managerUserId.eq(query.getManagerUserId()));
//        }
//        /** pmo负责人 精确 */
//        if (!ObjectUtils.isEmpty(query.getPmoManagerUserId())) {
//            list.add(qdoProject.pmoManagerUserId.eq(query.getPmoManagerUserId()));
//        }
//        /** 交付负责人 精确 */
//        if (!ObjectUtils.isEmpty(query.getPayManagerUserId())) {
//            list.add(qdoProject.payManagerUserId.eq(query.getPayManagerUserId()));
//        }
//        /** 销售负责人 精确 */
//        if (!ObjectUtils.isEmpty(query.getSaleManagerUserId())) {
//            list.add(qdoProject.saleManagerUserId.eq(query.getSaleManagerUserId()));
//        }
        /** 预算总人天 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalDays())) {
            list.add(qdoProject.totalDays.eq(query.getTotalDays()));
        }
        /** 费用总预算 精确 */
//        if (!ObjectUtils.isEmpty(query.getTotalMoney())) {
//            list.add(qdoProject.totalMoney.eq(query.getTotalMoney()));
//        }
        /** 费用总成本 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalCost())) {
            list.add(qdoProject.totalCost.eq(query.getTotalCost()));
        }
        /** 预算附件 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetFiles())) {
            list.add(qdoProject.budgetFiles.eq(query.getBudgetFiles()));
        }
//        /** 客户承担差旅 精确 */
//        if (!ObjectUtils.isEmpty(query.getCustBear())) {
//            list.add(qdoProject.custBear.eq(query.getCustBear()));
//        }
//        /** 补贴限额 精确 */
//        if (!ObjectUtils.isEmpty(query.getSubsidyLimit())) {
//            list.add(qdoProject.subsidyLimit.eq(query.getSubsidyLimit()));
//        }
//        /** 允许转包 精确 */
//        if (!ObjectUtils.isEmpty(query.getPermitSubcontract())) {
//            list.add(qdoProject.permitSubcontract.eq(query.getPermitSubcontract()));
//        }
        /** 工时结算周期 精确 */
        if (!ObjectUtils.isEmpty(query.getTimesheetPeriod())) {
            list.add(qdoProject.timesheetPeriod.eq(query.getTimesheetPeriod()));
        }
//        /** 最低保证金 精确 */
//        if (!ObjectUtils.isEmpty(query.getDepositMin())) {
//            list.add(qdoProject.depositMin.eq(query.getDepositMin()));
//        }
//        /** 拓展字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getExtString1())) {
//            list.add(qdoProject.extString1.eq(query.getExtString1()));
//        }
//        /** 拓展字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getExtString2())) {
//            list.add(qdoProject.extString2.eq(query.getExtString2()));
//        }
//        /** 拓展字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getExtString3())) {
//            list.add(qdoProject.extString3.eq(query.getExtString3()));
//        }
//        /** 拓展字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getExtString4())) {
//            list.add(qdoProject.extString4.eq(query.getExtString4()));
//        }
//        /** 拓展字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getExtString5())) {
//            list.add(qdoProject.extString5.eq(query.getExtString5()));
//        }
//        /** 拓展字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getExtString6())) {
//            list.add(qdoProject.extString6.eq(query.getExtString6()));
//        }
//        /** 拓展字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getExtString7())) {
//            list.add(qdoProject.extString7.eq(query.getExtString7()));
//        }
//        /** 拓展字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getExtString8())) {
//            list.add(qdoProject.extString8.eq(query.getExtString8()));
//        }
//        /** 拓展字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getExtString9())) {
//            list.add(qdoProject.extString9.eq(query.getExtString9()));
//        }
//        /** 拓展字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getExtString10())) {
//            list.add(qdoProject.extString10.eq(query.getExtString10()));
//        }
//        /** 隐藏字段 精确 */
//        if (!ObjectUtils.isEmpty(query.getHideFields())) {
//            list.add(qdoProject.hideFields.eq(query.getHideFields()));
//        }
//        //项目集判断条件
//        if (!ObjectUtils.isEmpty(query.getProjectSetId())) {
//            if (query.getProjectSetId().equals(0L)) {
//                list.add(qdoProject.projectSetId.isNull());
//            } else {
//                list.add(qdoProject.projectSetId.eq(query.getProjectSetId()));
//            }
//        }
//        //需要权限
//        if (query.getPermissionFlag()) {
//            // 项目经理、交付、PMO、销售、财务、项目成员 可以查到自己关联的项目
//            BooleanExpression jpaQueryOr = qdoProject.createUserId.eq(query.getLoginUserId())
//                    .or(qdoProject.managerUserId.eq(query.getLoginUserId()))
//                    .or(qdoProject.payManagerUserId.eq(query.getLoginUserId()))
//                    .or(qdoProject.pmoManagerUserId.eq(query.getLoginUserId()))
//                    .or(qdoProject.saleManagerUserId.eq(query.getLoginUserId()))
//                    .or(qdoProject.financeUserId.eq(query.getLoginUserId()));
//            //  .or(qdoProjectWbs.managerUserId.eq(query.getLoginUserId()));
//            if (!ObjectUtils.isEmpty(query.getLowerUserIds())) {
//                //下级人员中有项目相关人员也要查出项目信息
//                jpaQueryOr = jpaQueryOr.or(qdoProject.createUserId.in(query.getLowerUserIds()))
//                        .or(qdoProject.managerUserId.in(query.getLowerUserIds()))
//                        .or(qdoProject.payManagerUserId.in(query.getLowerUserIds()))
//                        .or(qdoProject.pmoManagerUserId.in(query.getLowerUserIds()))
//                        .or(qdoProject.saleManagerUserId.in(query.getLowerUserIds()))
//                        .or(qdoProject.financeUserId.in(query.getLowerUserIds()));
//                //.or(qdoProjectWbs.managerUserId.in(query.getLowerUserIds()));
//            }
//            list.add(jpaQueryOr);
//        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectSetVO> getJpaQuerySelect0() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectSetVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 项目数量
                qdo.parentId,
                // 项目集名称
                qdo.setName,
                // 项目集信息码
                qdo.setCode,
                // 项目集信息父节点码
                qdo.parentSetCode,
                // node码
                qdo.nodeCode,
                // 负责人id
                qdo.managerUserId
        )).from(qdo);
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectSetVO> querySelectList(PmsProjectSetQuery query) {
        JPAQuery<PmsProjectSetVO> jpaQuery = getJpaQuerySelect0();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectSetRelationVO> getJpaQuerySelect1() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectSetRelationVO.class,
                qdoProject.remark,
                qdoProject.createUserId,
                qdoProject.creator,
                qdoProject.createTime,
                qdoProject.modifyUserId,
                qdoProject.updater,
                qdoProject.modifyTime,
                // 项目集id
                qdoProject.projectSetId,
                // 项目id
                qdoProject.id,
                // 项目编号
                qdoProject.projNo.as("projectCode"),
//                // 项目名称
                qdoProject.projName.as("projectName"),
//                // 项目状态
                qdoProject.projStatus.as("projectStatus"),
//                // 项目类型
                qdoProject.ext1.as("projectType"),
//                // 客户
//                qdoProject.custId,
//                //客户名称
//                qdoProject.custName,
//                // 项目经理
                qdoProject.pmResId.as("managerUserId")


        )).from(qdoProject);
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PmsProjectSetQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdoProject.count())
                .from(qdoProject);
        jpaQuery.where(qdoProject.projectSetId.eq(query.getId()));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));

        long total = jpaQuery.fetchOne();
        return total;
    }


    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsProjectSetRelationVO> queryRelationProjectPaging(PmsProjectSetQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectSetRelationVO> jpaQuery = getJpaQuerySelect1();
        jpaQuery.where(qdoProject.projectSetId.eq(query.getId()));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoProject, query.getOrders()));
        List<PmsProjectSetRelationVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PmsProjectSetRelationVO>builder().records(result).total(total).build();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public List<PmsProjectSetRelationVO> queryRelationProjectList(PmsProjectSetQuery query) {
        JPAQuery<PmsProjectSetRelationVO> jpaQuery = getJpaQuerySelect1();
        jpaQuery.where(qdoProject.projectSetId.eq(query.getId()));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoProject, query.getOrders()));
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsProjectSetDO save(PmsProjectSetDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsProjectSetDO> saveAll(List<PmsProjectSetDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsProjectSetPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 父主键
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        // 项目集名称
        if (payload.getSetName() != null) {
            update.set(qdo.setName, payload.getSetName());
        }
        // 项目集信息码
        if (payload.getSetCode() != null) {
            update.set(qdo.setCode, payload.getSetCode());
        }
        // 项目集信息父节点码
        if (payload.getParentSetCode() != null) {
            update.set(qdo.parentSetCode, payload.getParentSetCode());
        }
        // node码
        if (payload.getNodeCode() != null) {
            update.set(qdo.nodeCode, payload.getNodeCode());
        }
        // 负责人id
        if (payload.getManagerUserId() != null) {
            update.set(qdo.managerUserId, payload.getManagerUserId());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 父主键
            if (nullFields.contains("parentId")) {
                update.setNull(qdo.parentId);
            }
            // 项目集名称
            if (nullFields.contains("setName")) {
                update.setNull(qdo.setName);
            }
            // 项目集信息码
            if (nullFields.contains("setCode")) {
                update.setNull(qdo.setCode);
            }
            // 项目集信息父节点码
            if (nullFields.contains("parentSetCode")) {
                update.setNull(qdo.parentSetCode);
            }
            // node码
            if (nullFields.contains("nodeCode")) {
                update.setNull(qdo.nodeCode);
            }
            // 负责人id
            if (nullFields.contains("managerUserId")) {
                update.setNull(qdo.managerUserId);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }


}

