package com.elitesland.tw.tw5.server.prd.pms.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyTempPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsRelyTempQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsRelyTempVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsRelyTempConvert;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsRelyTempDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsRelyTempDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsRelyTempRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.List;


/**
 * 项目wbs前置依赖关系模板dao
 * @author wangxl
 * @date 2024/4/2
 */
@RequiredArgsConstructor
@Component
public class PmsProjectWbsRelyTempDao  {

    private static final QPmsProjectWbsRelyTempDO qdo = QPmsProjectWbsRelyTempDO.pmsProjectWbsRelyTempDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectWbsRelyTempRepo repo;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsProjectWbsRelyTempVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsProjectWbsRelyTempVO.class,
                qdo.id,
                qdo.projectId,
                qdo.wbsId,
                qdo.wbsName,
                qdo.wbsRelyId,
                qdo.wbsRelyName,
                qdo.relyType,
                qdo.relationType,
                qdo.versionId,
                qdo.versionNo,
                qdo.effRelateId,
                qdo.wbsCode,
                qdo.tenantId,
                qdo.belongOrgId,
                qdo.tenantOrgId,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.deleteFlag,
                qdo.auditDataVersion,
                qdo.secBuId,
                qdo.secUserId,
                qdo.secOuId
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<Long> getJpaQuerySelectCount() {
        return jpaQueryFactory.select(qdo.id.count()).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     */
    private void jpaQueryWhere(JPAQuery<?> jpaQuery, PmsProjectWbsRelyTempQuery query) {
        if (!ObjectUtils.isEmpty(query.getProjectId())) {
            jpaQuery.where(qdo.projectId.eq(query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsId())) {
            jpaQuery.where(qdo.wbsId.eq(query.getWbsId()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsName())) {
            jpaQuery.where(qdo.wbsName.eq(query.getWbsName()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsRelyId())) {
            jpaQuery.where(qdo.wbsRelyId.eq(query.getWbsRelyId()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsRelyName())) {
            jpaQuery.where(qdo.wbsRelyName.eq(query.getWbsRelyName()));
        }
        if (!ObjectUtils.isEmpty(query.getRelyType())) {
            jpaQuery.where(qdo.relyType.eq(query.getRelyType()));
        }
        if (!ObjectUtils.isEmpty(query.getRelationType())) {
            jpaQuery.where(qdo.relationType.eq(query.getRelationType()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionId())) {
            jpaQuery.where(qdo.versionId.eq(query.getVersionId()));
        }
        if (!ObjectUtils.isEmpty(query.getVersionNo())) {
            jpaQuery.where(qdo.versionNo.eq(query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty(query.getEffRelateId())) {
            jpaQuery.where(qdo.effRelateId.eq(query.getEffRelateId()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsCode())) {
            jpaQuery.where(qdo.wbsCode.eq(query.getWbsCode()));
        }
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.eq(query.getRemark()));
        }
        if (!ObjectUtils.isEmpty(query.getAuditDataVersion())) {
            jpaQuery.where(qdo.auditDataVersion.eq(query.getAuditDataVersion()));
        }
        if (!ObjectUtils.isEmpty(query.getSecBuId())) {
            jpaQuery.where(qdo.secBuId.eq(query.getSecBuId()));
        }
        if (!ObjectUtils.isEmpty(query.getSecUserId())) {
            jpaQuery.where(qdo.secUserId.eq(query.getSecUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getSecOuId())) {
            jpaQuery.where(qdo.secOuId.eq(query.getSecOuId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
    }

    /**
     * 分页查询
     * @param query 查询参数
     * @return result
     */
    public PagingVO<PmsProjectWbsRelyTempVO> queryPage(PmsProjectWbsRelyTempQuery query) {
        // 查询总行数total
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long nullAbleCount = jpaQuerySelectCount.fetchOne();
        long count = nullAbleCount == null ? 0 : nullAbleCount;
        // 如果总行数为0则直接返回
        if(count == 0){
            return PagingVO.<PmsProjectWbsRelyTempVO>builder()
                    .total(count)
                    .records(Collections.emptyList())
                    .build();
        }
        JPAQuery<PmsProjectWbsRelyTempVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        // 分页
        SqlUtil.handlePage(jpaQuerySelect, query);
        return PagingVO.<PmsProjectWbsRelyTempVO>builder()
                .total(count)
                .records(jpaQuerySelect.fetch())
                .build();
    }

    /**
     * 查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsProjectWbsRelyTempVO> queryList(PmsProjectWbsRelyTempQuery query) {
        JPAQuery<PmsProjectWbsRelyTempVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询count
     *
     * @param query 查询参数
     * @return count
     */
    public long queryCount(PmsProjectWbsRelyTempQuery query) {
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long count = jpaQuerySelectCount.fetchOne();
        return count==null?0:count;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsProjectWbsRelyTempVO queryByKey(Long id) {
        JPAQuery<PmsProjectWbsRelyTempVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 调用jpa的保存
     *
     * @param payload payload
     * @return 保存后的对象
     */
    public PmsProjectWbsRelyTempVO save(PmsProjectWbsRelyTempPayload payload) {
        PmsProjectWbsRelyTempDO ado = PmsProjectWbsRelyTempConvert.INSTANCE.toEntity(payload);
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(ado);
        repo.save(ado);
        return PmsProjectWbsRelyTempConvert.INSTANCE.toVO(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsProjectWbsRelyTempDO> saveAll(List<PmsProjectWbsRelyTempDO> dos) {
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(dos);
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PmsProjectWbsRelyTempPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getProjectId() != null) {
            update.set(qdo.projectId, payload.getProjectId());
        }
        if (payload.getWbsId() != null) {
            update.set(qdo.wbsId, payload.getWbsId());
        }
        if (payload.getWbsName() != null) {
            update.set(qdo.wbsName, payload.getWbsName());
        }
        if (payload.getWbsRelyId() != null) {
            update.set(qdo.wbsRelyId, payload.getWbsRelyId());
        }
        if (payload.getWbsRelyName() != null) {
            update.set(qdo.wbsRelyName, payload.getWbsRelyName());
        }
        if (payload.getRelyType() != null) {
            update.set(qdo.relyType, payload.getRelyType());
        }
        if (payload.getRelationType() != null) {
            update.set(qdo.relationType, payload.getRelationType());
        }
        if (payload.getVersionId() != null) {
            update.set(qdo.versionId, payload.getVersionId());
        }
        if (payload.getVersionNo() != null) {
            update.set(qdo.versionNo, payload.getVersionNo());
        }
        if (payload.getEffRelateId() != null) {
            update.set(qdo.effRelateId, payload.getEffRelateId());
        }
        if (payload.getWbsCode() != null) {
            update.set(qdo.wbsCode, payload.getWbsCode());
        }
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getAuditDataVersion() != null) {
            update.set(qdo.auditDataVersion, payload.getAuditDataVersion());
        }
        if (payload.getSecBuId() != null) {
            update.set(qdo.secBuId, payload.getSecBuId());
        }
        if (payload.getSecUserId() != null) {
            update.set(qdo.secUserId, payload.getSecUserId());
        }
        if (payload.getSecOuId() != null) {
            update.set(qdo.secOuId, payload.getSecOuId());
        }
        // 处理要设置成空的字段(nullField处理)
        SqlUtil.handleNullFieldsUpdate(payload,qdo,update);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

}