package com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo;

import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author : duwh
 * @date : 2024-2-27
 * @desc : 交付项
 */
@Data
@ApiModel(description = "交付项统计")
public class PmsDeliverItemStatisticsVO implements Serializable {

    private String code;

    private String name;

    private Long count;

    private Integer countInteger;

    private Long countSum;

    private BigDecimal proportion;

    public BigDecimal getProportion() {
        if (null != count && null != countSum) {
            if (countSum == 0) {
                return BigDecimal.ZERO;
            }
            return new BigDecimal(count).divide(new BigDecimal(countSum), 2, BigDecimal.ROUND_HALF_UP);
        }
        return BigDecimal.ZERO;
    }

    public Integer getCountInteger() {
        if (null != count) {
            return count.intValue();
        }
        return 0;
    }

    public PmsDeliverItemStatisticsVO(String code, String name, Long count) {
        this.code = code;
        this.name = name;
        this.count = count;
    }

    public PmsDeliverItemStatisticsVO(String code, String name, Long count, Long countSum) {
        this.code = code;
        this.name = name;
        this.count = count;
        this.countSum = countSum;
    }

    public PmsDeliverItemStatisticsVO(String name, Long count) {
        this.name = name;
        this.count = count;
    }

    public PmsDeliverItemStatisticsVO() {
    }
}

