package com.elitesland.tw.tw5.server.prd.pms.deliver.repo.dao;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QProRelatedPartiesDO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.entity.PmsDeliverItemDO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.entity.QPmsDeliverItemDO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemPayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemVO;

import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsAcceptDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author : duwh
 * @date : 2024-2-27
 * @desc : 交付项RepoProc
 */
@Component
public class PmsDeliverItemDao extends BaseRepoProc<PmsDeliverItemDO> {

    private static final QPmsDeliverItemDO qPmsDeliverItemDO = QPmsDeliverItemDO.pmsDeliverItemDO;
    private static final QPmsProjectWbsAcceptDO qPmsProjectWbsAcceptDO = QPmsProjectWbsAcceptDO.pmsProjectWbsAcceptDO;
    private final QProRelatedPartiesDO qProRelatedPartiesDO = QProRelatedPartiesDO.proRelatedPartiesDO;
    private final QPmsProjectWbsDO qPmsProjectWbsDO = QPmsProjectWbsDO.pmsProjectWbsDO;


    protected PmsDeliverItemDao() {
        super(qPmsDeliverItemDO);
    }


    public PagingVO<PmsDeliverItemVO> page(PmsDeliverItemQuery pmsDeliverItemQuery) {
        JPAQuery<PmsDeliverItemVO> query =
            select(PmsDeliverItemVO.class)
                .where(bulidPredicate(pmsDeliverItemQuery));
        pmsDeliverItemQuery.setPaging(query);
        pmsDeliverItemQuery.fillOrders(query, qPmsDeliverItemDO);
        return PagingVO.<PmsDeliverItemVO>builder()
            .total(query.fetchCount())
            .records(query.fetch())
            .build();
    }


    public Long del(List<Long> ids) {
        Long res = jpaQueryFactory.update(qPmsDeliverItemDO)
            .set(qPmsDeliverItemDO.deleteFlag, 1)
            .where(qPmsDeliverItemDO.id.in(ids))
            .execute();
        return res;
    }

    public PmsDeliverItemVO get(Long id) {
        PmsDeliverItemVO pmsDeliverItemVO = select(PmsDeliverItemVO.class)
            .where(qPmsDeliverItemDO.id.eq(id))
            .fetchOne();
        return pmsDeliverItemVO;
    }


    public List<PmsDeliverItemVO> getList(PmsDeliverItemQuery pmsDeliverItemQuery) {
        List<PmsDeliverItemVO> res =
            select(PmsDeliverItemVO.class)
                .where(bulidPredicate(pmsDeliverItemQuery))
                .fetch();
        return res;
    }

    public List<PmsDeliverItemVO> list(PmsDeliverItemQuery pmsDeliverItemQuery) {
        List<PmsDeliverItemVO> res =
            jpaQueryFactory.select(Projections.bean(PmsDeliverItemVO.class,
                    // 负责人名字
                    qProRelatedPartiesDO.name.as("directorRelatedPartiesName"),

                    // 里程碑的预计开始时间
                    qPmsProjectWbsDO.preStartDate,

                    qPmsDeliverItemDO.roleId,
                    qPmsDeliverItemDO.projectId,
                    qPmsDeliverItemDO.name,
                    qPmsDeliverItemDO.directorRelatedPartiesId,
                    qPmsDeliverItemDO.content,
                    qPmsDeliverItemDO.wbsId,
                    qPmsDeliverItemDO.wbsName,
                    qPmsDeliverItemDO.savePath,
                    qPmsDeliverItemDO.submitContent,
                    qPmsDeliverItemDO.status,
                    qPmsDeliverItemDO.showFlag,
                    qPmsDeliverItemDO.sortNo,
                    qPmsDeliverItemDO.itemId,
                    qPmsDeliverItemDO.libraryId,
                    qPmsDeliverItemDO.createRelatedPartiesId,
                    qPmsDeliverItemDO.createRelatedPartiesName,
                    qPmsDeliverItemDO.ext1,
                    qPmsDeliverItemDO.ext2,
                    qPmsDeliverItemDO.ext3,
                    qPmsDeliverItemDO.ext4,
                    qPmsDeliverItemDO.ext5,
                    qPmsDeliverItemDO.id,
                    qPmsDeliverItemDO.createTime,
                    qPmsDeliverItemDO.remark
                ))
                .from(qPmsProjectWbsDO)
                .leftJoin(qPmsDeliverItemDO).on(qPmsProjectWbsDO.id.eq(qPmsDeliverItemDO.wbsId))
                .leftJoin(qProRelatedPartiesDO).on(qPmsDeliverItemDO.directorRelatedPartiesId.eq(qProRelatedPartiesDO.id))
                .where(bulidPredicate(pmsDeliverItemQuery))
                .fetch();
        return res;
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return
            jpaQueryFactory.select(Projections.bean(cls,

                    // 负责人名字
                    qProRelatedPartiesDO.name.as("directorRelatedPartiesName"),

                    qPmsDeliverItemDO.roleId,
                    qPmsDeliverItemDO.projectId,
                    qPmsDeliverItemDO.name,
                    qPmsDeliverItemDO.directorRelatedPartiesId,
                    qPmsDeliverItemDO.content,
                    qPmsDeliverItemDO.wbsId,
                    qPmsDeliverItemDO.wbsName,
                    qPmsDeliverItemDO.savePath,
                    qPmsDeliverItemDO.submitContent,
                    qPmsDeliverItemDO.status,
                    qPmsDeliverItemDO.showFlag,
                    qPmsDeliverItemDO.sortNo,
                    qPmsDeliverItemDO.itemId,
                    qPmsDeliverItemDO.libraryId,
                    qPmsDeliverItemDO.createRelatedPartiesId,
                    qPmsDeliverItemDO.createRelatedPartiesName,
                    qPmsDeliverItemDO.ext1,
                    qPmsDeliverItemDO.ext2,
                    qPmsDeliverItemDO.ext3,
                    qPmsDeliverItemDO.ext4,
                    qPmsDeliverItemDO.ext5,
                    qPmsDeliverItemDO.id,
                    qPmsDeliverItemDO.createTime,
                    qPmsDeliverItemDO.remark
                )).from(qPmsDeliverItemDO)
                .leftJoin(qProRelatedPartiesDO).on(qPmsDeliverItemDO.directorRelatedPartiesId.eq(qProRelatedPartiesDO.id));

    }


    private Predicate bulidPredicate(PmsDeliverItemQuery pmsDeliverItemQuery) {

        Predicate predicate = PredicateBuilder.builder()
            .andEq(null != pmsDeliverItemQuery.getRoleId(), qPmsDeliverItemDO.roleId, pmsDeliverItemQuery.getRoleId())
            .andEq(null != pmsDeliverItemQuery.getProjectId(), qPmsDeliverItemDO.projectId, pmsDeliverItemQuery.getProjectId())
            .andLike(StringUtils.isNotBlank(pmsDeliverItemQuery.getName()), qPmsDeliverItemDO.name, SqlUtil.toSqlLikeString(pmsDeliverItemQuery.getName()))
            .andEq(null != pmsDeliverItemQuery.getDirectorRelatedPartiesId(), qPmsDeliverItemDO.directorRelatedPartiesId, pmsDeliverItemQuery.getDirectorRelatedPartiesId())
            .andLike(StringUtils.isNotBlank(pmsDeliverItemQuery.getContent()), qPmsDeliverItemDO.content, SqlUtil.toSqlLikeString(pmsDeliverItemQuery.getContent()))
            .andIn(ObjectUtils.isNotEmpty(pmsDeliverItemQuery.getIdCollection()), qPmsDeliverItemDO.id, pmsDeliverItemQuery.getIdCollection())
            // .andEq(null != pmsDeliverItemQuery.getWbsId(), qPmsDeliverItemDO.wbsId, pmsDeliverItemQuery.getWbsId())
            // .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getWbsName()), qPmsDeliverItemDO.wbsName, pmsDeliverItemQuery.getWbsName())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getSavePath()), qPmsDeliverItemDO.savePath, pmsDeliverItemQuery.getSavePath())
            // .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getSubmitContent()), qPmsDeliverItemDO.submitContent, pmsDeliverItemQuery.getSubmitContent())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getStatus()), qPmsDeliverItemDO.status, pmsDeliverItemQuery.getStatus())
            .andEq(null != pmsDeliverItemQuery.getShowFlag(), qPmsDeliverItemDO.showFlag, pmsDeliverItemQuery.getShowFlag())
            .andEq(null != pmsDeliverItemQuery.getSortNo(), qPmsDeliverItemDO.sortNo, pmsDeliverItemQuery.getSortNo())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getItemId()), qPmsDeliverItemDO.itemId, pmsDeliverItemQuery.getItemId())
            .andIn(ObjectUtils.isNotEmpty(pmsDeliverItemQuery.getItemIdSet()), qPmsDeliverItemDO.itemId, pmsDeliverItemQuery.getItemIdSet())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getLibraryId()), qPmsDeliverItemDO.libraryId, pmsDeliverItemQuery.getLibraryId())
            .andEq(null != pmsDeliverItemQuery.getCreateRelatedPartiesId(), qPmsDeliverItemDO.createRelatedPartiesId, pmsDeliverItemQuery.getCreateRelatedPartiesId())
            .andLike(StringUtils.isNotBlank(pmsDeliverItemQuery.getCreateRelatedPartiesName()), qPmsDeliverItemDO.createRelatedPartiesName, SqlUtil.toSqlLikeString(pmsDeliverItemQuery.getCreateRelatedPartiesName()))
            .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getExt1()), qPmsDeliverItemDO.ext1, pmsDeliverItemQuery.getExt1())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getExt2()), qPmsDeliverItemDO.ext2, pmsDeliverItemQuery.getExt2())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getExt3()), qPmsDeliverItemDO.ext3, pmsDeliverItemQuery.getExt3())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getExt4()), qPmsDeliverItemDO.ext4, pmsDeliverItemQuery.getExt4())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemQuery.getExt5()), qPmsDeliverItemDO.ext5, pmsDeliverItemQuery.getExt5())

            .andLike(StringUtils.isNotBlank(pmsDeliverItemQuery.getDirectorRelatedPartiesName()), qProRelatedPartiesDO.name, SqlUtil.toSqlLikeString(pmsDeliverItemQuery.getDirectorRelatedPartiesName()))
            .build();

        return predicate;

    }


    // private Predicate bulidPredicates(PmsDeliverItemQuery pmsDeliverItemQuery) {
    //
    //     List<Predicate> predicates = new ArrayList<>();
    //     // 规则主键
    //     if (null != pmsDeliverItemQuery.getRoleId()) {
    //         predicates.add(qPmsDeliverItemDO.roleId.eq(pmsDeliverItemQuery.getRoleId()));
    //     }
    //     // 项目主键
    //     if (null != pmsDeliverItemQuery.getProjectId()) {
    //         predicates.add(qPmsDeliverItemDO.projectId.eq(pmsDeliverItemQuery.getProjectId()));
    //     }
    //     // 交付项
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getName())) {
    //         predicates.add(qPmsDeliverItemDO.name.eq(pmsDeliverItemQuery.getName()));
    //     }
    //     // 负责人
    //     if (null != pmsDeliverItemQuery.getDirectorRelatedPartiesId()) {
    //         predicates.add(qPmsDeliverItemDO.directorRelatedPartiesId.eq(pmsDeliverItemQuery.getDirectorRelatedPartiesId()));
    //     }
    //     // 说明
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getContent())) {
    //         predicates.add(qPmsDeliverItemDO.content.eq(pmsDeliverItemQuery.getContent()));
    //     }
    //     // 里程碑主键 pms_project_wbs.id
    //     if (null != pmsDeliverItemQuery.getWbsId()) {
    //         predicates.add(qPmsDeliverItemDO.wbsId.eq(pmsDeliverItemQuery.getWbsId()));
    //     }
    //     // 里程碑名称（冗余）
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getWbsName())) {
    //         predicates.add(qPmsDeliverItemDO.wbsName.eq(pmsDeliverItemQuery.getWbsName()));
    //     }
    //     // 存储路径
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getSavePath())) {
    //         predicates.add(qPmsDeliverItemDO.savePath.eq(pmsDeliverItemQuery.getSavePath()));
    //     }
    //     // 提交内容
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getSubmitContent())) {
    //         predicates.add(qPmsDeliverItemDO.submitContent.eq(pmsDeliverItemQuery.getSubmitContent()));
    //     }
    //     // 完成状态 已完成 未完成 UDC[PMS:DELIVER_ITEM:STATUS]
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getStatus())) {
    //         predicates.add(qPmsDeliverItemDO.status.eq(pmsDeliverItemQuery.getStatus()));
    //     }
    //     // 是否展示 0不展示 1 展示
    //     if (null != pmsDeliverItemQuery.getShowFlag()) {
    //         predicates.add(qPmsDeliverItemDO.showFlag.eq(pmsDeliverItemQuery.getShowFlag()));
    //     }
    //     // 排序字段
    //     if (null != pmsDeliverItemQuery.getSortNo()) {
    //         predicates.add(qPmsDeliverItemDO.sortNo.eq(pmsDeliverItemQuery.getSortNo()));
    //     }
    //     // 文件夹主键
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getItemId())) {
    //         predicates.add(qPmsDeliverItemDO.itemId.eq(pmsDeliverItemQuery.getItemId()));
    //     }
    //     // 库主键
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getLibraryId())) {
    //         predicates.add(qPmsDeliverItemDO.libraryId.eq(pmsDeliverItemQuery.getLibraryId()));
    //     }
    //     // 创建人（相关方）主键
    //     if (null != pmsDeliverItemQuery.getCreateRelatedPartiesId()) {
    //         predicates.add(qPmsDeliverItemDO.createRelatedPartiesId.eq(pmsDeliverItemQuery.getCreateRelatedPartiesId()));
    //     }
    //     // 创建人（相关方）名称(冗余）
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getCreateRelatedPartiesName())) {
    //         predicates.add(qPmsDeliverItemDO.createRelatedPartiesName.eq(pmsDeliverItemQuery.getCreateRelatedPartiesName()));
    //     }
    //     // 扩展字段1
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getExt1())) {
    //         predicates.add(qPmsDeliverItemDO.ext1.eq(pmsDeliverItemQuery.getExt1()));
    //     }
    //     // 扩展字段2
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getExt2())) {
    //         predicates.add(qPmsDeliverItemDO.ext2.eq(pmsDeliverItemQuery.getExt2()));
    //     }
    //     // 扩展字段3
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getExt3())) {
    //         predicates.add(qPmsDeliverItemDO.ext3.eq(pmsDeliverItemQuery.getExt3()));
    //     }
    //     // 扩展字段4
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getExt4())) {
    //         predicates.add(qPmsDeliverItemDO.ext4.eq(pmsDeliverItemQuery.getExt4()));
    //     }
    //     // 扩展字段5
    //     if (StringUtils.isNotEmpty(pmsDeliverItemQuery.getExt5())) {
    //         predicates.add(qPmsDeliverItemDO.ext5.eq(pmsDeliverItemQuery.getExt5()));
    //     }
    //
    //     Predicate predicate = ExpressionUtils.allOf(predicates);
    //
    //     return predicate;
    // }


    public Long count(PmsDeliverItemQuery pmsDeliverItemQuery) {

        long res = select(PmsDeliverItemVO.class)
            .where(bulidPredicate(pmsDeliverItemQuery))
            .fetchCount();

        return res;


    }

    public Long update(PmsDeliverItemPayload pmsDeliverItemPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPmsDeliverItemDO);

        // 规则主键
        if (null != pmsDeliverItemPayload.getRoleId()) {
            update.set(qPmsDeliverItemDO.roleId, pmsDeliverItemPayload.getRoleId());
        }
        // 项目主键
        if (null != pmsDeliverItemPayload.getProjectId()) {
            update.set(qPmsDeliverItemDO.projectId, pmsDeliverItemPayload.getProjectId());
        }
        // 交付项
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getName())) {
            update.set(qPmsDeliverItemDO.name, pmsDeliverItemPayload.getName());
        }
        // 负责人
        if (null != pmsDeliverItemPayload.getDirectorRelatedPartiesId()) {
            update.set(qPmsDeliverItemDO.directorRelatedPartiesId, pmsDeliverItemPayload.getDirectorRelatedPartiesId());
        }
        // 说明
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getContent())) {
            update.set(qPmsDeliverItemDO.content, pmsDeliverItemPayload.getContent());
        }
        // 里程碑主键 pms_project_wbs.id
        if (null != pmsDeliverItemPayload.getWbsId()) {
            update.set(qPmsDeliverItemDO.wbsId, pmsDeliverItemPayload.getWbsId());
        }
        // 里程碑名称（冗余）
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getWbsName())) {
            update.set(qPmsDeliverItemDO.wbsName, pmsDeliverItemPayload.getWbsName());
        }
        // 存储路径
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getSavePath())) {
            update.set(qPmsDeliverItemDO.savePath, pmsDeliverItemPayload.getSavePath());
        }
        // 提交内容
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getSubmitContent())) {
            update.set(qPmsDeliverItemDO.submitContent, pmsDeliverItemPayload.getSubmitContent());
        }
        // 完成状态 已完成 未完成 UDC[PMS:DELIVER_ITEM:STATUS]
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getStatus())) {
            update.set(qPmsDeliverItemDO.status, pmsDeliverItemPayload.getStatus());
        }
        // 是否展示 0不展示 1 展示
        if (null != pmsDeliverItemPayload.getShowFlag()) {
            update.set(qPmsDeliverItemDO.showFlag, pmsDeliverItemPayload.getShowFlag());
        }
        // 排序字段
        if (null != pmsDeliverItemPayload.getSortNo()) {
            update.set(qPmsDeliverItemDO.sortNo, pmsDeliverItemPayload.getSortNo());
        }
        // 文件夹主键
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getItemId())) {
            update.set(qPmsDeliverItemDO.itemId, pmsDeliverItemPayload.getItemId());
        }
        // 库主键
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getLibraryId())) {
            update.set(qPmsDeliverItemDO.libraryId, pmsDeliverItemPayload.getLibraryId());
        }
        // 创建人（相关方）主键
        if (null != pmsDeliverItemPayload.getCreateRelatedPartiesId()) {
            update.set(qPmsDeliverItemDO.createRelatedPartiesId, pmsDeliverItemPayload.getCreateRelatedPartiesId());
        }
        // 创建人（相关方）名称(冗余）
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getCreateRelatedPartiesName())) {
            update.set(qPmsDeliverItemDO.createRelatedPartiesName, pmsDeliverItemPayload.getCreateRelatedPartiesName());
        }
        // 扩展字段1
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getExt1())) {
            update.set(qPmsDeliverItemDO.ext1, pmsDeliverItemPayload.getExt1());
        }
        // 扩展字段2
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getExt2())) {
            update.set(qPmsDeliverItemDO.ext2, pmsDeliverItemPayload.getExt2());
        }
        // 扩展字段3
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getExt3())) {
            update.set(qPmsDeliverItemDO.ext3, pmsDeliverItemPayload.getExt3());
        }
        // 扩展字段4
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getExt4())) {
            update.set(qPmsDeliverItemDO.ext4, pmsDeliverItemPayload.getExt4());
        }
        // 扩展字段5
        if (StringUtils.isNotEmpty(pmsDeliverItemPayload.getExt5())) {
            update.set(qPmsDeliverItemDO.ext5, pmsDeliverItemPayload.getExt5());
        }
        long res = update.where(qPmsDeliverItemDO.id.eq(pmsDeliverItemPayload.getId()))
            .execute();
        return res;

    }

    public long delByProjectId(Long projectId) {
        Long res = jpaQueryFactory.update(qPmsDeliverItemDO)
            .set(qPmsDeliverItemDO.deleteFlag, 1)
            .where(qPmsDeliverItemDO.projectId.eq(projectId))
            // .where(qPmsDeliverItemDO.itemId.isNull())
            .where(qPmsDeliverItemDO.id.notIn(
                    jpaQueryFactory.select(qPmsProjectWbsAcceptDO.content.castToNum(Long.class))
                        .from(qPmsProjectWbsAcceptDO)
                        .where(qPmsProjectWbsAcceptDO.projectId.eq(projectId))
                        .where(qPmsProjectWbsAcceptDO.type.eq(0))
                )
            )
            .execute();
        return res;
    }

    /**
     * 按交付清单规则id更新交付项显示标志
     *
     * @param roleId   交付规则主键
     * @param showFlag 显示标志
     * @return {@link Long}
     */
    public Long updateShowFlagByRoleId(Long roleId, boolean showFlag) {
        Long res = jpaQueryFactory.update(qPmsDeliverItemDO)
            .set(qPmsDeliverItemDO.showFlag, showFlag)
            .where(qPmsDeliverItemDO.roleId.eq(roleId))
            .execute();
        return res;
    }
}

