package com.elitesland.tw.tw5.server.prd.pms.deliver.repo.dao;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.entity.PmsDeliverItemRoleDO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.entity.QPmsDeliverItemRoleDO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemRolePayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemRoleQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemRoleVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-27
 * @desc : 交付项规则RepoProc
 */
@Component
public class PmsDeliverItemRoleDao extends BaseRepoProc<PmsDeliverItemRoleDO> {

    private static final QPmsDeliverItemRoleDO qPmsDeliverItemRoleDO = QPmsDeliverItemRoleDO.pmsDeliverItemRoleDO;


    protected PmsDeliverItemRoleDao() {

        super(qPmsDeliverItemRoleDO);

    }


    public PagingVO<PmsDeliverItemRoleVO> page(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        JPAQuery<PmsDeliverItemRoleVO> query =
            select(PmsDeliverItemRoleVO.class)
                .where(bulidPredicate(pmsDeliverItemRoleQuery));
        pmsDeliverItemRoleQuery.setPaging(query);
        pmsDeliverItemRoleQuery.fillOrders(query, qPmsDeliverItemRoleDO);
        return PagingVO.<PmsDeliverItemRoleVO>builder()
            .total(query.fetchCount())
            .records(query.fetch())
            .build();

    }


    public Long del(List<Long> ids) {
        Long res = jpaQueryFactory.update(qPmsDeliverItemRoleDO)
            .set(qPmsDeliverItemRoleDO.deleteFlag, 1)
            .where(qPmsDeliverItemRoleDO.id.in(ids))
            .execute();
        return res;

    }


    public PmsDeliverItemRoleVO get(Long id) {
        PmsDeliverItemRoleVO pmsDeliverItemRoleVO = select(PmsDeliverItemRoleVO.class)
            .where(qPmsDeliverItemRoleDO.id.eq(id))
            .fetchOne();
        return pmsDeliverItemRoleVO;

    }


    public List<PmsDeliverItemRoleVO> getList(PmsDeliverItemRoleQuery query) {
        JPAQuery<PmsDeliverItemRoleVO> jpaQuery = select(PmsDeliverItemRoleVO.class)
            .where(bulidPredicate(query));
        query.fillOrders(jpaQuery, qPmsDeliverItemRoleDO);
        List<PmsDeliverItemRoleVO> res =
            jpaQuery
                .fetch();
        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
            jpaQueryFactory.select(Projections.bean(cls,
                qPmsDeliverItemRoleDO.projectId,
                qPmsDeliverItemRoleDO.name,
                qPmsDeliverItemRoleDO.directorRelatedPartiesId,
                qPmsDeliverItemRoleDO.content,
                qPmsDeliverItemRoleDO.savePath,
                qPmsDeliverItemRoleDO.showConfigFlag,
                qPmsDeliverItemRoleDO.noShowFlag,
                qPmsDeliverItemRoleDO.sortNo,
                qPmsDeliverItemRoleDO.itemId,
                qPmsDeliverItemRoleDO.libraryId,
                qPmsDeliverItemRoleDO.createRelatedPartiesId,
                qPmsDeliverItemRoleDO.createRelatedPartiesName,
                qPmsDeliverItemRoleDO.ext1,
                qPmsDeliverItemRoleDO.ext2,
                qPmsDeliverItemRoleDO.ext3,
                qPmsDeliverItemRoleDO.ext4,
                qPmsDeliverItemRoleDO.ext5,
                qPmsDeliverItemRoleDO.id,
                qPmsDeliverItemRoleDO.createTime,
                qPmsDeliverItemRoleDO.remark

            )).from(qPmsDeliverItemRoleDO);

    }


    private Predicate bulidPredicate(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {

        Predicate predicate = PredicateBuilder.builder()
            .andEq(null != pmsDeliverItemRoleQuery.getProjectId(), qPmsDeliverItemRoleDO.projectId, pmsDeliverItemRoleQuery.getProjectId())
            .andIn(null != pmsDeliverItemRoleQuery.getIdList(), qPmsDeliverItemRoleDO.id, pmsDeliverItemRoleQuery.getIdList())
            .andLike(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getName()), qPmsDeliverItemRoleDO.name, SqlUtil.toSqlLikeString(pmsDeliverItemRoleQuery.getName()))
            .andEq(null != pmsDeliverItemRoleQuery.getDirectorRelatedPartiesId(), qPmsDeliverItemRoleDO.directorRelatedPartiesId, pmsDeliverItemRoleQuery.getDirectorRelatedPartiesId())
            .andLike(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getContent()), qPmsDeliverItemRoleDO.content, SqlUtil.toSqlLikeString(pmsDeliverItemRoleQuery.getContent()))
            .andLike(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getSavePath()), qPmsDeliverItemRoleDO.savePath, SqlUtil.toSqlLikeString(pmsDeliverItemRoleQuery.getSavePath()))
            .andEq(null != pmsDeliverItemRoleQuery.getShowConfigFlag(), qPmsDeliverItemRoleDO.showConfigFlag, pmsDeliverItemRoleQuery.getShowConfigFlag())
            .andEq(null != pmsDeliverItemRoleQuery.getNoShowFlag(), qPmsDeliverItemRoleDO.noShowFlag, pmsDeliverItemRoleQuery.getNoShowFlag())
            .andEq(null != pmsDeliverItemRoleQuery.getSortNo(), qPmsDeliverItemRoleDO.sortNo, pmsDeliverItemRoleQuery.getSortNo())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getItemId()), qPmsDeliverItemRoleDO.itemId, pmsDeliverItemRoleQuery.getItemId())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getLibraryId()), qPmsDeliverItemRoleDO.libraryId, pmsDeliverItemRoleQuery.getLibraryId())
            .andEq(null != pmsDeliverItemRoleQuery.getCreateRelatedPartiesId(), qPmsDeliverItemRoleDO.createRelatedPartiesId, pmsDeliverItemRoleQuery.getCreateRelatedPartiesId())
            .andLike(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getCreateRelatedPartiesName()), qPmsDeliverItemRoleDO.createRelatedPartiesName, SqlUtil.toSqlLikeString(pmsDeliverItemRoleQuery.getCreateRelatedPartiesName()))
            .andEq(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getExt1()), qPmsDeliverItemRoleDO.ext1, pmsDeliverItemRoleQuery.getExt1())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getExt2()), qPmsDeliverItemRoleDO.ext2, pmsDeliverItemRoleQuery.getExt2())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getExt3()), qPmsDeliverItemRoleDO.ext3, pmsDeliverItemRoleQuery.getExt3())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getExt4()), qPmsDeliverItemRoleDO.ext4, pmsDeliverItemRoleQuery.getExt4())
            .andEq(StringUtils.isNotBlank(pmsDeliverItemRoleQuery.getExt5()), qPmsDeliverItemRoleDO.ext5, pmsDeliverItemRoleQuery.getExt5())
            .build();

        return predicate;

    }


    // private Predicate bulidPredicates(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
    //
    //     List<Predicate> predicates = new ArrayList<>();
    //     // 项目主键
    //     if (null != pmsDeliverItemRoleQuery.getProjectId()) {
    //         predicates.add(qPmsDeliverItemRoleDO.projectId.eq(pmsDeliverItemRoleQuery.getProjectId()));
    //     }
    //     // 交付项
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getName())) {
    //         predicates.add(qPmsDeliverItemRoleDO.name.like(SqlUtil.toSqlLikeString(pmsDeliverItemRoleQuery.getName())));
    //     }
    //     // 负责人
    //     if (null != pmsDeliverItemRoleQuery.getDirectorRelatedPartiesId()) {
    //         predicates.add(qPmsDeliverItemRoleDO.directorRelatedPartiesId.eq(pmsDeliverItemRoleQuery.getDirectorRelatedPartiesId()));
    //     }
    //     // 说明
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getContent())) {
    //         predicates.add(qPmsDeliverItemRoleDO.content.like(SqlUtil.toSqlLikeString(pmsDeliverItemRoleQuery.getContent())));
    //     }
    //     // 存储路径
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getSavePath())) {
    //         predicates.add(qPmsDeliverItemRoleDO.savePath.like(SqlUtil.toSqlLikeString(pmsDeliverItemRoleQuery.getSavePath())));
    //     }
    //     // 是否允许裁剪 0否 1是
    //     if (null != pmsDeliverItemRoleQuery.getShowConfigFlag()) {
    //         predicates.add(qPmsDeliverItemRoleDO.showConfigFlag.eq(pmsDeliverItemRoleQuery.getShowConfigFlag()));
    //     }
    //     // 裁剪状态 0未裁剪 1 已裁剪
    //     if (null != pmsDeliverItemRoleQuery.getNoShowFlag()) {
    //         predicates.add(qPmsDeliverItemRoleDO.noShowFlag.eq(pmsDeliverItemRoleQuery.getNoShowFlag()));
    //     }
    //     // 排序字段
    //     if (null != pmsDeliverItemRoleQuery.getSortNo()) {
    //         predicates.add(qPmsDeliverItemRoleDO.sortNo.eq(pmsDeliverItemRoleQuery.getSortNo()));
    //     }
    //     // 文件夹主键
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getItemId())) {
    //         predicates.add(qPmsDeliverItemRoleDO.itemId.eq(pmsDeliverItemRoleQuery.getItemId()));
    //     }
    //     // 库主键
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getLibraryId())) {
    //         predicates.add(qPmsDeliverItemRoleDO.libraryId.eq(pmsDeliverItemRoleQuery.getLibraryId()));
    //     }
    //     // 创建人（相关方）主键
    //     if (null != pmsDeliverItemRoleQuery.getCreateRelatedPartiesId()) {
    //         predicates.add(qPmsDeliverItemRoleDO.createRelatedPartiesId.eq(pmsDeliverItemRoleQuery.getCreateRelatedPartiesId()));
    //     }
    //     // 创建人（相关方）名称(冗余）
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getCreateRelatedPartiesName())) {
    //         predicates.add(qPmsDeliverItemRoleDO.createRelatedPartiesName.like(SqlUtil.toSqlLikeString(pmsDeliverItemRoleQuery.getCreateRelatedPartiesName())));
    //     }
    //     // 扩展字段1
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getExt1())) {
    //         predicates.add(qPmsDeliverItemRoleDO.ext1.eq(pmsDeliverItemRoleQuery.getExt1()));
    //     }
    //     // 扩展字段2
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getExt2())) {
    //         predicates.add(qPmsDeliverItemRoleDO.ext2.eq(pmsDeliverItemRoleQuery.getExt2()));
    //     }
    //     // 扩展字段3
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getExt3())) {
    //         predicates.add(qPmsDeliverItemRoleDO.ext3.eq(pmsDeliverItemRoleQuery.getExt3()));
    //     }
    //     // 扩展字段4
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getExt4())) {
    //         predicates.add(qPmsDeliverItemRoleDO.ext4.eq(pmsDeliverItemRoleQuery.getExt4()));
    //     }
    //     // 扩展字段5
    //     if (StringUtils.isNotEmpty(pmsDeliverItemRoleQuery.getExt5())) {
    //         predicates.add(qPmsDeliverItemRoleDO.ext5.eq(pmsDeliverItemRoleQuery.getExt5()));
    //     }
    //
    //     Predicate predicate = ExpressionUtils.allOf(predicates);
    //
    //     return predicate;
    // }

    public Long count(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        long res = jpaQueryFactory
            .select(qPmsDeliverItemRoleDO.count())
            .from(qPmsDeliverItemRoleDO)
            .where(bulidPredicate(pmsDeliverItemRoleQuery))
            .fetchCount();
        return res;
    }

    public Long update(PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPmsDeliverItemRoleDO);

        // 项目主键
        if (null != pmsDeliverItemRolePayload.getProjectId()) {
            update.set(qPmsDeliverItemRoleDO.projectId, pmsDeliverItemRolePayload.getProjectId());
        }
        // 交付项
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getName())) {
            update.set(qPmsDeliverItemRoleDO.name, pmsDeliverItemRolePayload.getName());
        }
        // 负责人
        if (null != pmsDeliverItemRolePayload.getDirectorRelatedPartiesId()) {
            update.set(qPmsDeliverItemRoleDO.directorRelatedPartiesId, pmsDeliverItemRolePayload.getDirectorRelatedPartiesId());
        }
        // 说明
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getContent())) {
            update.set(qPmsDeliverItemRoleDO.content, pmsDeliverItemRolePayload.getContent());
        }
        // 存储路径
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getSavePath())) {
            update.set(qPmsDeliverItemRoleDO.savePath, pmsDeliverItemRolePayload.getSavePath());
        }
        // 是否允许裁剪 0否 1是
        if (null != pmsDeliverItemRolePayload.getShowConfigFlag()) {
            update.set(qPmsDeliverItemRoleDO.showConfigFlag, pmsDeliverItemRolePayload.getShowConfigFlag());
        }
        // 裁剪状态 0未裁剪 1 已裁剪
        if (null != pmsDeliverItemRolePayload.getNoShowFlag()) {
            update.set(qPmsDeliverItemRoleDO.noShowFlag, pmsDeliverItemRolePayload.getNoShowFlag());
        }
        // 排序字段
        if (null != pmsDeliverItemRolePayload.getSortNo()) {
            update.set(qPmsDeliverItemRoleDO.sortNo, pmsDeliverItemRolePayload.getSortNo());
        }
        // 文件夹主键
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getItemId())) {
            update.set(qPmsDeliverItemRoleDO.itemId, pmsDeliverItemRolePayload.getItemId());
        }
        // 库主键
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getLibraryId())) {
            update.set(qPmsDeliverItemRoleDO.libraryId, pmsDeliverItemRolePayload.getLibraryId());
        }
        // 创建人（相关方）主键
        if (null != pmsDeliverItemRolePayload.getCreateRelatedPartiesId()) {
            update.set(qPmsDeliverItemRoleDO.createRelatedPartiesId, pmsDeliverItemRolePayload.getCreateRelatedPartiesId());
        }
        // 创建人（相关方）名称(冗余）
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getCreateRelatedPartiesName())) {
            update.set(qPmsDeliverItemRoleDO.createRelatedPartiesName, pmsDeliverItemRolePayload.getCreateRelatedPartiesName());
        }
        // 扩展字段1
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getExt1())) {
            update.set(qPmsDeliverItemRoleDO.ext1, pmsDeliverItemRolePayload.getExt1());
        }
        // 扩展字段2
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getExt2())) {
            update.set(qPmsDeliverItemRoleDO.ext2, pmsDeliverItemRolePayload.getExt2());
        }
        // 扩展字段3
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getExt3())) {
            update.set(qPmsDeliverItemRoleDO.ext3, pmsDeliverItemRolePayload.getExt3());
        }
        // 扩展字段4
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getExt4())) {
            update.set(qPmsDeliverItemRoleDO.ext4, pmsDeliverItemRolePayload.getExt4());
        }
        // 扩展字段5
        if (StringUtils.isNotEmpty(pmsDeliverItemRolePayload.getExt5())) {
            update.set(qPmsDeliverItemRoleDO.ext5, pmsDeliverItemRolePayload.getExt5());
        }
        long res = update.where(qPmsDeliverItemRoleDO.id.eq(pmsDeliverItemRolePayload.getId()))
            .execute();
        return res;

    }

    public long deleteByProjectId(Long projectId) {
        Long res = jpaQueryFactory.update(qPmsDeliverItemRoleDO)
            .set(qPmsDeliverItemRoleDO.deleteFlag, 1)
            .where(qPmsDeliverItemRoleDO.projectId.eq(projectId))
            .execute();
        return res;
    }
}
