package com.elitesland.tw.tw5.server.prd.pms.deliver.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemRoleQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemRoleVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemRolePayload;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
  * @author : duwh
  * @date : 2024-2-27
  * @desc : 交付项规则Service
  */
public interface PmsDeliverItemRoleService {

    /**
     * 新增交付项规则数据
     * @param pmsDeliverItemRolePayload
     * @return
     */
    PmsDeliverItemRoleVO save(PmsDeliverItemRolePayload pmsDeliverItemRolePayload);

    /**
     * 根据主键更新
     * @param pmsDeliverItemRolePayload
     * @return
     */
    PmsDeliverItemRoleVO updateAll(PmsDeliverItemRolePayload pmsDeliverItemRolePayload);

    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PmsDeliverItemRoleVO get(Long id);

    /**
     * 分页查询列表
     * @param pmsDeliverItemRoleQuery
     * @return
     */
    PagingVO<PmsDeliverItemRoleVO> page(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery);

    /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     * @param pmsDeliverItemRoleQuery
     * @return
     */
    List<PmsDeliverItemRoleVO> getList(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery);

    /**
     * 计数
     *
     * @param pmsDeliverItemRoleQuery pms交付项目角色查询
     * @return long
     */
    long count(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery);

    /**
     * 根据条件修改
     * @param pmsDeliverItemRolePayload
     * @return
     */
    Long update(PmsDeliverItemRolePayload pmsDeliverItemRolePayload);

    /**
     * excel导入
     *
     * @param file      文件
     * @param projectId 项目id
     * @param force     武力
     * @param response  回答
     * @return {@link Map}<{@link String}, {@link Object}>
     */
    Map<String, Object> excelImport(MultipartFile file, Long projectId, Boolean force, HttpServletResponse response);

    /**
     * 按规则更新交付项
     *
     * @param projectId 项目id
     * @return long
     */
    long updateItemByRole(Long projectId);

    /**
     * 修改裁剪状态
     *
     * @param payload pms交付项目角色有效载荷
     * @return {@link Long}
     */
    Long updateNoShowFlag(PmsDeliverItemRolePayload payload);

    /**
     * 批量 修改裁剪状态
     *
     * @param list 列表
     * @return {@link Long}
     */
    Long updateNoShowFlagList(List<PmsDeliverItemRolePayload> list);
}

